/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.keys.content.x509;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.content.x509.XMLX509DataContent;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.JavaUtils;
import com.systinet.wasp.security.secext.utils.SignatureElementProxy;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sun.security.util.DerValue;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509SKI == null ? (class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509SKI = XMLX509SKI.class$("com.systinet.wasp.security.secext.keys.content.x509.XMLX509SKI")) : class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509SKI).getName());
    public static final String SKI_OID = "2.5.29.14";
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$keys$content$x509$XMLX509SKI;

    public XMLX509SKI(Document doc, byte[] skiBytes) {
        super(doc);
        this.addBase64Text(skiBytes);
    }

    public XMLX509SKI(Document doc, X509Certificate x509certificate) throws XMLSecurityException {
        super(doc);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509certificate));
    }

    public XMLX509SKI(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate cert) throws XMLSecurityException {
        try {
            byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
            if (cert.getVersion() < 3) {
                Object[] exArgs = new Object[]{new Integer(cert.getVersion())};
                throw new XMLSecurityException("certificate.noSki.lowVersion", exArgs);
            }
            DerValue dervalue = new DerValue(derEncodedValue);
            if (dervalue == null) {
                throw new XMLSecurityException("certificate.noSki.null");
            }
            if (dervalue.tag != 4) {
                throw new XMLSecurityException("certificate.noSki.notOctetString");
            }
            byte[] extensionValue = dervalue.getOctetString();
            byte[] abyte0 = new byte[extensionValue.length - 2];
            System.arraycopy(extensionValue, 2, abyte0, 0, abyte0.length);
            return abyte0;
        }
        catch (IOException ex) {
            throw new XMLSecurityException("generic.EmptyMessage", ex);
        }
    }

    private void createSKIElementFromCert(X509Certificate cert) throws XMLSecurityException {
        byte[] abyte0 = XMLX509SKI.getSKIBytesFromCert(cert);
        Base64.encodeToElement(this._doc, "X509SKI", abyte0);
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509SKI other = (XMLX509SKI)obj;
        try {
            return JavaUtils.binaryCompare(other.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException ex) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509SKI";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

