/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.utils;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.utils.I18n;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class Base64 {
    static Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$secext$utils$Base64 == null ? (class$com$systinet$wasp$security$secext$utils$Base64 = Base64.class$("com.systinet.wasp.security.secext.utils.Base64")) : class$com$systinet$wasp$security$secext$utils$Base64).getName());
    public static final String LINE_SEPARATOR = "\n";
    public static final int BASE64DEFAULTLENGTH = 76;
    static int _base64length = 76;
    static /* synthetic */ Class class$com$systinet$wasp$security$secext$utils$Base64;

    private Base64() {
    }

    public static void setBase64WrapLength(int length) {
        _base64length = length;
    }

    public static int getBase64WrapLength() {
        return _base64length;
    }

    static byte[] getBytes(BigInteger big, int bitlen) {
        if ((bitlen = bitlen + 7 >> 3 << 3) < big.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] bigBytes = big.toByteArray();
        if (big.bitLength() % 8 != 0 && big.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int bigLen = bigBytes.length;
        if (big.bitLength() % 8 == 0) {
            startSrc = 1;
            --bigLen;
        }
        int startDst = bitlen / 8 - bigLen;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, bigLen);
        return resizedBytes;
    }

    public static String encode(BigInteger big) {
        return Base64.encode(Base64.getBytes(big, big.bitLength()));
    }

    public static byte[] encode(BigInteger big, int bitlen) {
        if ((bitlen = bitlen + 7 >> 3 << 3) < big.bitLength()) {
            throw new IllegalArgumentException(I18n.translate("utils.Base64.IllegalBitlength"));
        }
        byte[] bigBytes = big.toByteArray();
        if (big.bitLength() % 8 != 0 && big.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int bigLen = bigBytes.length;
        if (big.bitLength() % 8 == 0) {
            startSrc = 1;
            --bigLen;
        }
        int startDst = bitlen / 8 - bigLen;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, bigLen);
        return resizedBytes;
    }

    public static BigInteger decodeBigIntegerFromElement(Element element) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(element));
    }

    public static BigInteger decodeBigIntegerFromText(Text text) throws Base64DecodingException {
        return new BigInteger(1, Base64.decode(text.getData()));
    }

    public static void fillElementWithBigInteger(Element element, BigInteger biginteger) {
        String encodedInt = Base64.encode(biginteger);
        if (encodedInt.length() > 76) {
            encodedInt = LINE_SEPARATOR + encodedInt + LINE_SEPARATOR;
        }
        Document doc = element.getOwnerDocument();
        Text text = doc.createTextNode(encodedInt);
        element.appendChild(text);
    }

    public static byte[] decode(Element element) throws Base64DecodingException {
        NodeList nl = element.getChildNodes();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 3) {
                Text t = (Text)nl.item(i);
                sb.append(t.getData());
            }
            ++i;
        }
        return Base64.decode(sb.toString());
    }

    public static Element encodeToElement(Document doc, String localName, byte[] bytes) {
        Element el = XMLUtils.createElementInSignatureSpace(doc, localName);
        Text text = doc.createTextNode(Base64.encode(bytes));
        el.appendChild(text);
        return el;
    }

    public static byte[] decode(byte[] base64) throws Base64DecodingException {
        try {
            return Base64.decode(new String(base64, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            return new byte[0];
        }
    }

    public static byte[] decode(String base64) throws Base64DecodingException {
        try {
            if (base64.length() < 30) {
                // empty if block
            }
            StringTokenizer tok = new StringTokenizer(base64, " \n\r\t", false);
            StringBuffer buf = new StringBuffer(base64.length());
            while (tok.hasMoreElements()) {
                buf.append(tok.nextToken());
            }
            base64 = buf.toString();
            int pad = 0;
            int i = base64.length() - 1;
            while (i > 0 && base64.charAt(i) == '=') {
                ++pad;
                --i;
            }
            int length = base64.length() / 4 * 3 - pad;
            byte[] raw = new byte[length];
            int i2 = 0;
            int rawIndex = 0;
            while (i2 < base64.length()) {
                int block = (Base64.getValue(base64.charAt(i2)) << 18) + (Base64.getValue(base64.charAt(i2 + 1)) << 12) + (Base64.getValue(base64.charAt(i2 + 2)) << 6) + Base64.getValue(base64.charAt(i2 + 3));
                int j = 2;
                while (j >= 0) {
                    if (rawIndex + j < raw.length) {
                        raw[rawIndex + j] = (byte)(block & 0xFF);
                    }
                    block >>= 8;
                    --j;
                }
                i2 += 4;
                rawIndex += 3;
            }
            return raw;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new Base64DecodingException("utils.Base64.IllegalBitlength", ex);
        }
    }

    public static String encode(byte[] raw, int wrap) {
        int encLen = (raw.length + 2) / 3 * 4;
        if (wrap > 3) {
            wrap -= wrap % 4;
            encLen += 2 * (encLen / wrap);
        } else {
            wrap = Integer.MAX_VALUE;
        }
        StringBuffer encoded = new StringBuffer(encLen);
        int len3 = raw.length / 3 * 3;
        int outLen = 0;
        int i = 0;
        while (i < len3) {
            if (outLen + 4 > wrap) {
                encoded.append(LINE_SEPARATOR);
                outLen = 0;
            }
            encoded.append(Base64.encodeFullBlock(raw, i));
            i += 3;
            outLen += 4;
        }
        if (outLen >= wrap) {
            encoded.append(LINE_SEPARATOR);
        }
        if (len3 < raw.length) {
            encoded.append(Base64.encodeBlock(raw, len3));
        }
        return encoded.toString();
    }

    public static String encode(byte[] raw) {
        return Base64.encode(raw, Base64.getBase64WrapLength());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] decode(BufferedReader reader) throws IOException, Base64DecodingException {
        String line;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (null != (line = reader.readLine())) {
            void var2_2;
            byte[] bytes = Base64.decode((String)var2_2);
            baos.write(bytes);
        }
        return baos.toByteArray();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        int i = 0;
        while (i < 3) {
            int b = offset + i < raw.length ? raw[offset + i] : 0;
            int neuter = b < 0 ? b + 256 : b;
            block <<= 8;
            block += neuter;
            ++i;
        }
        char[] base64 = new char[4];
        int i2 = 3;
        while (i2 >= 0) {
            int sixBit = block & 0x3F;
            base64[i2] = Base64.getChar(sixBit);
            block >>= 6;
            --i2;
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char[] encodeFullBlock(byte[] raw, int offset) {
        int block = 0;
        int i = 0;
        while (i < 3) {
            block <<= 8;
            block += 0xFF & raw[offset + i];
            ++i;
        }
        block = ((raw[offset] & 0xFF) << 16) + ((raw[offset + 1] & 0xFF) << 8) + (raw[offset + 2] & 0xFF);
        char[] base64 = new char[4];
        int i2 = 3;
        while (i2 >= 0) {
            int sixBit = block & 0x3F;
            base64[i2] = Base64.getChar(sixBit);
            block >>= 6;
            --i2;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit < 26) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit < 52) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit < 62) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        String testString1 = "<container><base64 value=\"Should be 'Hallo'\">SGFsbG8=</base64></container>";
        InputSource inputSource = new InputSource(new StringReader(testString1));
        Document doc = docBuilder.parse(inputSource);
        Element base64Elem = (Element)doc.getDocumentElement().getChildNodes().item(0);
        System.out.println(new String(Base64.decode(base64Elem)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

