/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import javax.xml.namespace.QName;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenHandlerSPI;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.OrderedElementConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.w3c.dom.Element;

public class SecurityTokenObject
extends WSSecurityObject {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.impl.SecurityTokenObject");
    private SecurityTokenSPI securityToken = null;
    private SecurityTokenHandlerSPI[] tokenHandlers = this.getSecurityContext().getTokenHandlers();
    private String wsuId = null;
    private boolean isExternal;

    public SecurityTokenObject(SecurityContext securityContext, Element element) throws WSSecurityException {
        super(securityContext, element);
        String valueType = element.getAttribute("ValueType");
        String handlerValueType = null;
        String wsseNamespace = securityContext.getWsseNamespace();
        handlerValueType = !WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace) ? new QName(valueType).getLocalPart() : WSSecurityHelper.getFragment(valueType);
        SecurityTokenHandlerSPI tokenHandler = this.getTokenHandler(handlerValueType, element.getLocalName());
        this.securityToken = tokenHandler.createFromXML(element, securityContext);
        this.wsuId = this.securityToken.getWsuId();
        if (this.wsuId == null) {
            this.wsuId = WSSecurityImpl.genId();
        }
        this.getSecurityContext().addSecurityToken(this.securityToken);
        this.setExternal(false);
        this.getSecurityContext().addSecurityObject(this);
    }

    public SecurityTokenObject(SecurityContext securityContext, OrderedElementConf configuration, boolean isExternal) throws WSSecurityException {
        super(securityContext, configuration);
        SecurityTokenConf securityTokenConf = (SecurityTokenConf)configuration;
        String valueType = securityTokenConf.getType();
        SecurityTokenHandlerSPI tokenHandler = this.getTokenHandler(valueType, null);
        if (tokenHandler == null) {
            log.error("No security token handler found for the value type : " + valueType);
            throw WSSecurityException.UNSUPPORTED_SECURITY_TOKEN;
        }
        this.securityToken = tokenHandler.createFromConf(securityTokenConf, securityContext, isExternal);
        this.wsuId = this.securityToken.getWsuId();
        if (this.wsuId == null) {
            this.wsuId = WSSecurityImpl.genId();
        }
        this.getSecurityContext().addSecurityToken(this.securityToken);
        this.setExternal(isExternal);
        this.getSecurityContext().addSecurityObject(this);
    }

    public void doFinal() throws WSSecurityException {
        if (this.getMode() == 1) {
            this.getSecurityContext().addSecurityToken(this.securityToken);
            this.securityToken.doFinal(1);
            SecurityTokenConf tokenConf = this.securityToken.getReceivedConf();
            if (tokenConf == null) {
                tokenConf = this.getSecurityContext().getMessageConf().newSecurityToken();
            }
            tokenConf.setType(this.securityToken.getType());
            tokenConf.setWsuId(WSSecurityHelper.getWsuIdFromElement(this.securityToken.getElement()));
            this.getSecurityContext().addReceivedSecurityTokenConf(tokenConf);
        } else {
            this.securityToken.doFinal(0);
            if (!this.getExternal()) {
                this.getSecurityContext().prependSecurityElement(this.securityToken.getElement());
                this.getSecurityContext().removeSecurityObject(this);
                this.getSecurityContext().removeSecurityToken(this.securityToken);
            }
        }
    }

    public String getWsuId() {
        return this.wsuId;
    }

    private SecurityTokenHandlerSPI getTokenHandler(String valueType, String localName) throws WSSecurityException {
        int pos;
        if (valueType == null && localName == null) {
            return null;
        }
        int n = pos = valueType == null ? -1 : valueType.indexOf(58);
        if (pos != -1 && valueType.length() > ++pos) {
            valueType = valueType.substring(pos);
        }
        int i = 0;
        while (i < this.tokenHandlers.length) {
            SecurityTokenHandlerSPI tokenHandler = this.tokenHandlers[i];
            if (valueType == null || valueType.equals("") || valueType.equals(tokenHandler.getLocalValueType())) {
                if (localName != null && !localName.equals("")) {
                    if (localName.equals(tokenHandler.getLocalElementName())) {
                        return tokenHandler;
                    }
                } else {
                    return tokenHandler;
                }
            }
            ++i;
        }
        log.error("Unable to find handler for security token, valueType : " + valueType + ", localName : " + localName);
        throw WSSecurityException.UNSUPPORTED_SECURITY_TOKEN;
    }

    public SecurityTokenSPI getSecurityToken() {
        return this.securityToken;
    }

    public boolean getExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }
}

