/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.idoox.security.util.Base64;
import com.systinet.wasp.security.ws.SymmetricKeyToken;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenHandlerSPI;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.w3c.dom.Element;

public class SymmetricKeyTokenHandler
extends SecurityTokenHandlerSPI {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.impl.SymmetricKeyTokenHandler");

    public SecurityTokenSPI createFromXML(Element constructionElement, SecurityContext securityContext) throws WSSecurityException {
        log.error("Symmetric key security token cannot be loaded from XML");
        throw WSSecurityException.UNSUPPORTED_SECURITY_TOKEN;
    }

    public String getLocalValueType() {
        return "SymmetricKey";
    }

    public SecurityTokenSPI createFromConf(SecurityTokenConf tokenConf, SecurityContext securityContext, boolean isExternal) {
        SymmetricKeyToken securityToken = new SymmetricKeyToken(securityContext, isExternal);
        PropertyConf[] props = tokenConf.getProperties();
        String encKey = WSSecurityHelper.getPropertyValue(props, "encodedkey");
        if (encKey == null) {
            log.error("Symmetric key security token configuration does not specify key");
            throw WSSecurityException.INVALID_SECURITY_TOKEN;
        }
        byte[] enckey = Base64.decode((byte[])encKey.getBytes());
        securityToken.setEncodedKey(enckey);
        String keyAlg = WSSecurityHelper.getPropertyValue(props, "keyalgorithm");
        securityToken.setKeyAlgorihm(keyAlg);
        String wsuId = tokenConf.getWsuId();
        if (wsuId != null) {
            securityToken.setWsuId(wsuId);
        }
        return securityToken;
    }

    public String getLocalElementName() {
        return "SymmetricKeyToken";
    }
}

