/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml.security;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.security.KeyContent;
import org.idoox.xml.security.SignatureException;

public class KeyContentFactory {
    private static Map keyContentMap = new HashMap();

    public static KeyContent getKeyContent(QName name) throws SignatureException {
        KeyContent keyContent = (KeyContent)keyContentMap.get(name);
        if (keyContent == null) {
            throw new SignatureException("There isn't KeyContent object associated with a given name: " + name.toString());
        }
        return keyContent.newInstance();
    }

    public static void registerKeyContent(KeyContent keyContent) {
        keyContentMap.put(keyContent.getName(), keyContent);
    }

    public static void unregisterKeyContent(QName name) {
        keyContentMap.remove(name);
    }
}

