/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.https.client;

import com.idoox.transport.http.client.HttpPool;
import com.idoox.transport.http.client.HttpRequest;
import com.idoox.transport.https.SecurityUtils;
import com.idoox.transport.https.impl.JSSEHelper;
import com.idoox.transport.util.Bytes;
import com.idoox.transport.util.ReadLine;
import com.idoox.transport.util.SocketEx;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.idoox.security.Credentials;
import org.systinet.wasp.Version;

public class HttpsPool
extends HttpPool {
    private static final byte SPACE = 32;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] CONNECT = new byte[]{67, 79, 78, 78, 69, 67, 84};
    private static final byte[] HTTP = new byte[]{72, 84, 84, 80, 47, 49, 46, 49};
    private ReadLine readLine = new ReadLine(null);
    private boolean checkCrt;
    private SSLSocketFactory sslFactory;

    public HttpsPool(int initialSize, boolean checkServerCert, SSLSocketFactory sslSocketFactory) throws GeneralSecurityException, ClassNotFoundException {
        super(initialSize);
        this.checkCrt = checkServerCert;
        this.sslFactory = sslSocketFactory;
    }

    public void setCheckServerCertificate(boolean checkCrt) {
        this.checkCrt = checkCrt;
    }

    public SocketEx get(String userinfo, String host, int port, int timeout, int updateInterval, Map properties) throws UnknownHostException, IOException {
        Credentials cred = SecurityUtils.getSSLClientCredentials();
        if (cred == null) {
            return super.get(userinfo, host, port, timeout, updateInterval, properties);
        }
        String sslUserinfo = (userinfo == null ? "" : userinfo) + cred.getName();
        SocketEx ret = super.get(sslUserinfo, host, port, timeout, updateInterval, properties);
        return ret;
    }

    protected Socket newSocket(SocketEx socket, String server, int port, int timeout) throws IOException {
        SSLSocket sslSocket;
        Socket plainSocket = super.newSocket(socket, server, port, timeout);
        if (((HttpPool.HttpSocketData)socket.ext).useProxy) {
            this.doTunnelHandshake(socket, plainSocket, server, port);
            sslSocket = (SSLSocket)this.sslFactory.createSocket(plainSocket, server, port, true);
        } else {
            sslSocket = (SSLSocket)this.sslFactory.createSocket(plainSocket, server, port, true);
        }
        sslSocket.startHandshake();
        sslSocket.getSession().invalidate();
        if (this.checkCrt) {
            String certName = JSSEHelper.getPeerName(sslSocket);
            String host = InetAddress.getByName(server).getHostName();
            if (!HttpsPool.wildcardMatch(certName.toLowerCase(), host.toLowerCase())) {
                throw new SSLException("Name in certificate '" + certName + "' doesn't match host name '" + host + "'.");
            }
        }
        return sslSocket;
    }

    private static boolean wildcardMatch(String pattern, String name) {
        return HttpsPool.wildcardMatch(pattern, name, 0, 0, pattern.length(), name.length());
    }

    /*
     * Unable to fully structure code
     */
    private static boolean wildcardMatch(String pattern, String name, int ppos, int npos, int plen, int nlen) {
        star = pattern.indexOf(42, ppos);
        if (star < 0) {
            return plen - ppos == nlen - npos && pattern.regionMatches(ppos, name, npos, plen - ppos) != false;
        }
        if (!pattern.regionMatches(ppos, name, npos, star - ppos)) {
            return false;
        }
        if (star != plen - 1) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            ++npos;
lbl9:
            // 2 sources

            ** while (!HttpsPool.wildcardMatch((String)pattern, (String)name, (int)(star + 1), (int)npos, (int)plen, (int)nlen) && npos < nlen)
        }
lbl10:
        // 1 sources

        return npos < nlen;
    }

    private void doTunnelHandshake(SocketEx socket, Socket sslSocket, String server, int port) throws IOException {
        String basicAuth;
        OutputStream output = sslSocket.getOutputStream();
        byte[] host = (server + ':' + port).getBytes("US-ASCII");
        output.write(CONNECT);
        output.write(32);
        output.write(host);
        output.write(32);
        output.write(HTTP);
        output.write(CRLF);
        output.write("Host: ".getBytes("US-ASCII"));
        output.write(host);
        output.write(CRLF);
        output.write("User-Agent: ".getBytes("US-ASCII"));
        output.write(Version.getVersion().getBytes("US-ASCII"));
        output.write(CRLF);
        String proxyBasicAuth = HttpRequest.getProxyAuthString((SocketEx)socket, (String)"https.proxyUserName", (String)"https.proxyPassword");
        if (proxyBasicAuth != null) {
            output.write("Proxy-Authorization: ".getBytes("US-ASCII"));
            output.write(proxyBasicAuth.getBytes("US-ASCII"));
            output.write(CRLF);
        }
        if ((basicAuth = HttpRequest.getBasicAuthString((SocketEx)socket, (String)"https.basicUserName", (String)"https.basicPassword")) != null) {
            output.write("Authorization: ".getBytes("US-ASCII"));
            output.write(basicAuth.getBytes("US-ASCII"));
            output.write(CRLF);
        }
        output.write(CRLF);
        output.flush();
        this.readLine.setInputStream(sslSocket.getInputStream());
        this.readLine.read();
        String statusLine = new String(this.readLine.buffer, 0, 0, this.readLine.count);
        int space1 = Bytes.indexOf((byte[])this.readLine.buffer, (int)0, (int)this.readLine.count, (byte)32);
        if (space1 == -1) {
            socket.close();
            throw new IOException("Malformed status line from the proxy during CONNECT to " + socket);
        }
        int sc = -1;
        int space2 = Bytes.indexOf((byte[])this.readLine.buffer, (int)(space1 + 1), (int)(this.readLine.count - (space1 + 1)), (byte)32);
        sc = space2 != -1 ? Bytes.parseInt((byte[])this.readLine.buffer, (int)(space1 + 1), (int)(space2 - (space1 + 1))) : Bytes.parseInt((byte[])this.readLine.buffer, (int)(space1 + 1), (int)(this.readLine.count - (space1 + 1)));
        String sm = space2 != -1 ? new String(this.readLine.buffer, 0, space2 + 1, this.readLine.count - (space2 + 1)) : "";
        if (sc < 200 || sc >= 300) {
            socket.close();
            throw new IOException("Error '" + sm + "' from the proxy during CONNECT to " + socket);
        }
        while (this.readLine.read() != 0) {
        }
    }
}

