/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.https.server;

import com.idoox.debug.Category;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.server.ReceivedCredentialsImpl;
import com.idoox.transport.https.impl.JSSEHelper;
import com.idoox.wasp.security.ssl.SSLServerProvider;
import com.mortbay.HTTP.HttpRequest;
import com.mortbay.HTTP.JsseListener;
import com.mortbay.Util.Code;
import com.mortbay.Util.InetAddrPort;
import com.mortbay.Util.ThreadedServer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.NoSuchProviderException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.util.RuntimeWrappedException;

class JsseListenerImpl
extends JsseListener {
    private boolean needsClientAuth = false;
    private String alias;
    private String password;
    private static final Category log = Category.getCategory((String)"com.idoox.transport.https.server.SunJsseListener");

    /*
     * WARNING - void declaration
     */
    protected ServerSocket newServerSocket(InetAddrPort p_address, int p_acceptQueueSize) throws IOException {
        try {
            void e;
            SSLServerSocket socket = (SSLServerSocket)super.newServerSocket(p_address, p_acceptQueueSize);
            socket.setNeedClientAuth(this.needsClientAuth);
            return e;
        }
        catch (IOException e) {
            log.warn("newServerSocket error", (Throwable)e);
            throw (IOException)e.fillInStackTrace();
        }
    }

    public void setNeedsClientAuth(boolean needsClientAuth) {
        this.needsClientAuth = needsClientAuth;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        SSLServerSocketFactory fact = JSSEHelper.createSSLServerSocketFactory(this.alias, this.password);
        return fact;
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
        super.customizeRequest(socket, request);
        if (!this.needsClientAuth) {
            return;
        }
        try {
            SSLSocket sslSocket = (SSLSocket)socket;
            X509Certificate[] jcerts = JSSEHelper.getPeerCertificates(sslSocket);
            Current current = Current.getInstance();
            WaspCallbackHandler handler = new WaspCallbackHandler(jcerts, PStore.getInstance(null).getKeyStore(), PStore.getInstance(null).getUserStore());
            ReceivedCredentialsImpl cred = new ReceivedCredentialsImpl("", "SSL", "CertsMapping", (CallbackHandler)handler);
            SSLServerProvider provider = (SSLServerProvider)current.getProvider("SSL");
            provider.presetCurrentAccepting((ReceivedCredentials)cred);
        }
        catch (NoSuchProviderException e) {
            log.debug("presetServerCredentials error ", (Throwable)e);
            throw new RuntimeWrappedException("Systinet Server SSL Security provider is not available.", (Throwable)e);
        }
        catch (SSLException e) {
            log.debug("unable get peer certificates", (Throwable)e);
            throw new RuntimeWrappedException("No client certificate available.", (Throwable)e);
        }
        catch (BadPasswordException e) {
            log.debug("Get RecCredential err:", (Throwable)e);
            throw new RuntimeWrappedException("Unable to gain acces to protected store.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Socket acceptSocket(ServerSocket serverSocket, int timeout) {
        try {
            void e;
            if (((ThreadedServer)this)._soTimeOut != timeout) {
                ((ThreadedServer)this)._soTimeOut = timeout;
                ((ThreadedServer)this)._listen.setSoTimeout(((ThreadedServer)this)._soTimeOut);
            }
            Socket s = ((ThreadedServer)this)._listen.accept();
            if (((ThreadedServer)this)._maxReadTimeMs > 0) {
                s.setSoTimeout(((ThreadedServer)this)._maxReadTimeMs);
            }
            return e;
        }
        catch (SocketException e) {
            Code.ignore((Throwable)e);
        }
        catch (InterruptedIOException e) {
            if (Code.verbose((int)99)) {
                Code.ignore((Throwable)e);
            }
        }
        catch (SSLException e) {
            log.error("SSL exception caught.", (Throwable)e);
            throw new RuntimeWrappedException("Error during socket accepting", (Throwable)e);
        }
        catch (IOException e) {
            Code.warning((Throwable)e);
            log.warn("IOException caught.", (Throwable)e);
        }
        return null;
    }
}

