/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.http.digest;

import com.idoox.security.httpdigest.AuthorizationStructureImpl;
import com.idoox.security.httpdigest.DigestCalculator;
import com.idoox.wasp.security.http.digest.AuthenticateStructure;
import com.idoox.wasp.security.http.digest.ClientInputMessage;
import com.idoox.wasp.security.http.digest.ClientOutputMessage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.idoox.config.Configurable;
import org.idoox.security.Credentials;
import org.idoox.security.httpdigest.AuthorizationStructure;
import org.idoox.security.jaas.NamePasswordCredential;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;

public class ClientInterceptor
implements TransportInterceptor {
    private static Hashtable contexts = new Hashtable(11, 0.75f);
    static /* synthetic */ Class class$org$idoox$security$jaas$NamePasswordCredential;

    public void intercept(Connection connection, InterceptorChain chain, int position) throws IOException {
        NamePasswordCredential cred = ClientInterceptor.getClientCredentials();
        if (cred == null) {
            throw new RuntimeException("No HttpDigest credentials found.");
        }
        String userId = cred.getName();
        String password = cred.getPassword();
        Context context = null;
        try {
            String uri = connection.getURI().toExternalForm();
            context = this.getContext(uri, userId);
            if (context != null && password != null && context.password != null && !password.equals(context.password)) {
                context = null;
            }
            if (context == null) {
                context = this.createContext(connection, userId, password);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("HttpDigest Authorization error. " + e.getClass().getName() + " " + (e.getMessage() == null ? "" : e.getMessage()));
        }
        connection.setInputMessage((InputMessage)new ClientInputMessage(connection.getInputMessage(), context));
        connection.setOutputMessage((OutputMessage)new ClientOutputMessage(connection.getOutputMessage(), context));
    }

    public void load(Configurable config) {
    }

    public void destroy() {
    }

    public static NamePasswordCredential getClientCredentials() {
        org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
        Map map = Current.getServiceClientContext().getContextData();
        Credentials[] creds = (Credentials[])map.get("Stub.credentials");
        if (creds == null || creds.length == 0) {
            creds = current.getCredentials();
        }
        if (creds == null || creds.length == 0) {
            throw new RuntimeException("No NamePasswordAN found.");
        }
        int i = 0;
        while (i < creds.length) {
            if (creds[i] != null && creds[i].getProviderName().equals("HttpDigest")) {
                Subject sub = creds[i].getSubject();
                Set credSet = sub.getPrivateCredentials(class$org$idoox$security$jaas$NamePasswordCredential == null ? ClientInterceptor.class$("org.idoox.security.jaas.NamePasswordCredential") : class$org$idoox$security$jaas$NamePasswordCredential);
                if (credSet != null && credSet.size() != 0) {
                    return (NamePasswordCredential)credSet.iterator().next();
                }
            }
            ++i;
        }
        throw new RuntimeException("No NamePasswordAN found.");
    }

    private Context createContext(Connection connection, String userId, String password) throws MalformedURLException, IOException {
        String uri = connection.getURI().toExternalForm();
        Endpoint endpoint = new Endpoint(uri);
        CallContext callContext = Current.getCallContext();
        Properties lookupProps = (Properties)callContext.getContextData().get("CallContext.lookupProperties");
        ClientConnection con = endpoint.newConnection(TransportMethod.POST, (Map)lookupProps);
        con.getOutputMessage().setContentType("x-idoox-req-realm");
        con.getOutputMessage().close();
        InputMessage in = con.getInputMessage();
        int status = in.getStatusCode();
        if (status != 401) {
            throw new RuntimeException("Server returns status code : " + status);
        }
        String challenge = in.getStringHeader("WWW-Authenticate");
        String peer = in.getStringHeader("Server");
        in.close();
        Context ret = new Context(challenge, userId, password, uri, peer);
        this.putContext(uri, userId, ret);
        return ret;
    }

    private void putContext(String uri, String userId, Context context) {
        contexts.put(uri + "@" + userId, context);
    }

    private Context getContext(String uri, String userId) {
        return (Context)contexts.get(uri + "@" + userId);
    }

    static void resetContext(String uri, String userId) {
        contexts.remove(uri + "@" + userId);
    }

    static void resetContexts() {
        contexts.clear();
    }

    public static void resetAuthorizationStructure(AuthenticateStructure authen, AuthorizationStructureImpl author, String username, String uri, int nonceCount) {
        author.setUsername(username);
        author.setRealm(authen.getRealm());
        author.setNonce(authen.getNonce());
        author.setUri(uri);
        author.setAlgorithm(authen.getAlgorithm());
        author.setOpaque(authen.getOpaque());
        if (authen.getQop() != null) {
            author.setCnonce(String.valueOf(Calendar.getInstance().getTime().getTime()));
            if (authen.getQop().indexOf("auth") == -1) {
                throw new RuntimeException("qop :" + authen.getQop() + " not supported");
            }
            author.setQop("auth");
            author.setNc(AuthorizationStructureImpl.getNc((int)nonceCount));
        }
        author.setPeer(authen.getPeer());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Context {
        AuthenticateStructure auth = null;
        String userId = null;
        String password = null;
        String uri = null;
        int nonceCount = 0;

        public Context(String challenge, String userId, String password, String uri, String peer) {
            this.setChallenge(challenge, peer);
            this.userId = userId;
            this.password = password;
            this.uri = uri;
        }

        public void setChallenge(String challenge, String peer) {
            this.auth = new AuthenticateStructure(challenge, peer);
        }

        public AuthorizationStructureImpl getAuthorization() {
            ++this.nonceCount;
            AuthorizationStructureImpl author = new AuthorizationStructureImpl();
            try {
                String authURI = new Endpoint(this.uri).getLocation();
                ClientInterceptor.resetAuthorizationStructure(this.auth, author, this.userId, authURI, this.nonceCount);
                String response = DigestCalculator.digestCalcResponse((AuthorizationStructure)author, (String)this.userId, (String)this.password, (String)"POST");
                author.setResponse(response);
            }
            catch (Exception e) {
                throw new RuntimeException("Error initiating authorization element. " + e.getClass().getName() + " " + (e.getMessage() != null ? e.getMessage() : ""));
            }
            return author;
        }
    }
}

