/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import java.math.BigInteger;

public final class BigInt {
    private byte[] places;
    private static final String digits = "0123456789abcdef";

    public BigInt(byte[] abyte0) {
        this.places = (byte[])abyte0.clone();
    }

    public BigInt(BigInteger biginteger) {
        byte[] abyte0 = biginteger.toByteArray();
        if ((abyte0[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (abyte0[0] != 0) {
            this.places = abyte0;
        } else {
            this.places = new byte[abyte0.length - 1];
            int i = 1;
            while (i < abyte0.length) {
                this.places[i - 1] = abyte0[i];
                ++i;
            }
        }
    }

    public BigInt(int i) {
        if (i < 256) {
            this.places = new byte[1];
            this.places[0] = (byte)i;
        } else if (i < 65536) {
            this.places = new byte[2];
            this.places[0] = (byte)(i >> 8);
            this.places[1] = (byte)i;
        } else if (i < 0x1000000) {
            this.places = new byte[3];
            this.places[0] = (byte)(i >> 16);
            this.places[1] = (byte)(i >> 8);
            this.places[2] = (byte)i;
        } else {
            this.places = new byte[4];
            this.places[0] = (byte)(i >> 24);
            this.places[1] = (byte)(i >> 16);
            this.places[2] = (byte)(i >> 8);
            this.places[3] = (byte)i;
        }
    }

    public int toInt() {
        if (this.places.length > 4) {
            throw new NumberFormatException("BigInt.toLong, too big");
        }
        int i = 0;
        int j = 0;
        while (j < this.places.length) {
            i = (i << 8) + (this.places[j] & 0xFF);
            ++j;
        }
        return i;
    }

    public String toString() {
        return this.hexify();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.places);
    }

    public byte[] toByteArray() {
        return (byte[])this.places.clone();
    }

    private String hexify() {
        if (this.places.length == 0) {
            return "  0  ";
        }
        StringBuffer stringbuffer = new StringBuffer(this.places.length * 2);
        stringbuffer.append("    ");
        int i = 0;
        while (i < this.places.length) {
            stringbuffer.append(digits.charAt(this.places[i] >> 4 & 0xF));
            stringbuffer.append(digits.charAt(this.places[i] & 0xF));
            if ((i + 1) % 32 == 0) {
                if (i + 1 != this.places.length) {
                    stringbuffer.append("\n    ");
                }
            } else if ((i + 1) % 4 == 0) {
                stringbuffer.append(' ');
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BigInt) {
            return this.equals((BigInt)obj);
        }
        return false;
    }

    public boolean equals(BigInt bigint) {
        if (this == bigint) {
            return true;
        }
        byte[] abyte0 = bigint.toByteArray();
        if (this.places.length != abyte0.length) {
            return false;
        }
        int i = 0;
        while (i < this.places.length) {
            if (this.places[i] != abyte0[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hexify().hashCode();
    }
}

