/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import com.idoox.wasp.security.kerberos.utils.asn1.BigInt;
import com.idoox.wasp.security.kerberos.utils.asn1.BitArray;
import com.idoox.wasp.security.kerberos.utils.asn1.DerIndefLenConverter;
import com.idoox.wasp.security.kerberos.utils.asn1.DerInputBuffer;
import com.idoox.wasp.security.kerberos.utils.asn1.DerValue;
import com.idoox.wasp.security.kerberos.utils.asn1.ObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Vector;

public class DerInputStream {
    DerInputBuffer buffer;

    public DerInputStream(byte[] abyte0) throws IOException {
        this.init(abyte0, 0, abyte0.length);
    }

    public DerInputStream(byte[] abyte0, int i, int j) throws IOException {
        this.init(abyte0, i, j);
    }

    private void init(byte[] abyte0, int i, int j) throws IOException {
        if (i + 2 > abyte0.length || i + j > abyte0.length) {
            throw new IOException("Encoding bytes too short");
        }
        if (DerIndefLenConverter.isIndefinite(abyte0[i + 1])) {
            byte[] abyte1 = new byte[j];
            System.arraycopy(abyte0, i, abyte1, 0, j);
            DerIndefLenConverter derindeflenconverter = new DerIndefLenConverter();
            this.buffer = new DerInputBuffer(derindeflenconverter.convert(abyte1));
        } else {
            this.buffer = new DerInputBuffer(abyte0, i, j);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer derinputbuffer) {
        this.buffer = derinputbuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int i, boolean flag) throws IOException {
        DerInputBuffer derinputbuffer = this.buffer.dup();
        derinputbuffer.truncate(i);
        if (flag) {
            this.buffer.skip(i);
        }
        return new DerInputStream(derinputbuffer);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public BigInt getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getUnsigned(DerInputStream.getLength(this.buffer));
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public BigInt getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getUnsigned(DerInputStream.getLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int i = DerInputStream.getLength(this.buffer);
        if (this.buffer.read() != 0) {
            throw new IOException("unaligned bit string");
        }
        byte[] abyte0 = new byte[--i];
        if (i != 0 && this.buffer.read(abyte0) != i) {
            throw new IOException("short read of DER bit string");
        }
        return abyte0;
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int i = DerInputStream.getLength(this.buffer) - 1;
        int j = i * 8 - this.buffer.read();
        byte[] abyte0 = new byte[i];
        if (i != 0 && this.buffer.read(abyte0) != i) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(j, abyte0);
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int i = DerInputStream.getLength(this.buffer);
        byte[] abyte0 = new byte[i];
        if (i != 0 && this.buffer.read(abyte0) != i) {
            throw new IOException("short read of DER octet string");
        }
        return abyte0;
    }

    public void getBytes(byte[] abyte0) throws IOException {
        if (abyte0.length != 0 && this.buffer.read(abyte0) != abyte0.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int i) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(i);
    }

    public DerValue[] getSet(int i) throws IOException {
        if (this.buffer.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(i);
    }

    public DerValue[] getSet(int i, boolean flag) throws IOException {
        int j = this.buffer.read();
        if (!flag && j != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(i);
    }

    protected DerValue[] readVector(int i) throws IOException {
        int j = DerInputStream.getLength(this.buffer);
        if (j == 0) {
            return new DerValue[0];
        }
        DerInputStream derinputstream = this.buffer.available() == j ? this : this.subStream(j, true);
        Vector<DerValue> vector = new Vector<DerValue>(i, 5);
        do {
            DerValue dervalue = new DerValue(derinputstream.buffer);
            vector.addElement(dervalue);
        } while (derinputstream.available() > 0);
        if (derinputstream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int l = vector.size();
        DerValue[] adervalue = new DerValue[l];
        int k = 0;
        while (k < l) {
            adervalue[k] = (DerValue)vector.elementAt(k);
            ++k;
        }
        return adervalue;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public String getUTF8String() throws IOException {
        return this.readString((byte)12, "UTF-8", "UTF8");
    }

    public String getPrintableString() throws IOException {
        return this.readString((byte)19, "Printable", "ASCII");
    }

    public String getT61String() throws IOException {
        return this.readString((byte)20, "T61", "ISO-8859-1");
    }

    public String getIA5String() throws IOException {
        return this.readString((byte)22, "IA5", "ASCII");
    }

    public String getBMPString() throws IOException {
        return this.readString((byte)30, "BMP", "UnicodeBigUnmarked");
    }

    public String getGeneralString() throws IOException {
        return this.readString((byte)27, "General", "ASCII");
    }

    private String readString(byte byte0, String s, String s1) throws IOException {
        if (this.buffer.read() != byte0) {
            throw new IOException("DER input not a " + s + " string");
        }
        int i = DerInputStream.getLength(this.buffer);
        byte[] abyte0 = new byte[i];
        if (i != 0 && this.buffer.read(abyte0) != i) {
            throw new IOException("short read of DER " + s + " string");
        }
        return new String(abyte0, s1);
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream inputstream) throws IOException {
        return DerInputStream.getLength(inputstream.read(), inputstream);
    }

    static int getLength(int i, InputStream inputstream) throws IOException {
        int j;
        int k = i;
        if ((k & 0x80) == 0) {
            j = k;
        } else {
            if ((k &= 0x7F) == 0) {
                return -1;
            }
            if (k < 0 || k > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + k + ", " + (k >= 0 ? "too big." : "incorrect DER encoding."));
            }
            j = 0;
            while (k > 0) {
                j <<= 8;
                j += 0xFF & inputstream.read();
                --k;
            }
        }
        return j;
    }

    public void mark(int i) {
        this.buffer.mark(i);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }
}

