/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.server;

import com.idoox.debug.Category;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.config.SecurityModuleConfig;
import com.idoox.wasp.security.server.InitializeSecurityListener;
import com.idoox.wasp.security.util.PropertyUtils;
import com.idoox.xml.security.SignatureFactoryImpl;
import com.idoox.xml.security.SignatureImpl;
import com.systinet.security.SecurityClientListener;
import com.systinet.security.WaspSecurityImpl;
import com.systinet.wasp.webservice.RegistryImpl;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.login.Configuration;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.Config;
import org.idoox.security.pstore.NotificationListener;
import org.idoox.security.pstore.PStore;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspSecurity;
import org.systinet.security.policy.UpdateablePolicy;
import org.systinet.security.policy.WASPAccessController;
import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.ServiceClientListener;
import org.systinet.wasp.webservice.ServiceEndpointListener;

public class SecurityModule
implements Module {
    private static final Category dbg = Category.getCategory((String)"com.idoox.wasp.security.server.SecurityModule");
    public static final String DYNAMIC_SECURITY_PROVIDERS = "DynamicSecurityProviders";
    static /* synthetic */ Class class$com$idoox$wasp$security$server$SecurityModule;
    static /* synthetic */ Class class$com$idoox$wasp$config$SecurityModuleConfig;
    static /* synthetic */ Class class$java$util$Map;

    public void load(Configurable config) {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        config = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        dbg.info("SecurityModule starts.");
        try {
            Properties props = new Properties();
            props.load((class$com$idoox$wasp$security$server$SecurityModule == null ? (class$com$idoox$wasp$security$server$SecurityModule = SecurityModule.class$("com.idoox.wasp.security.server.SecurityModule")) : class$com$idoox$wasp$security$server$SecurityModule).getClassLoader().getResourceAsStream("com/idoox/wasp/security/server/security.properties"));
            SecurityModuleConfig sc = (SecurityModuleConfig)config.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = SecurityModule.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
            Properties myProps = new Properties();
            PropertyUtils.loadPropertiesWithExpand(sc.getProperties(), myProps);
            PropertyUtils.loadPropertiesWithExpand(sc.getProperties(), System.getProperties());
            String dynamicSecProviders = System.getProperty(DYNAMIC_SECURITY_PROVIDERS);
            if (dynamicSecProviders != null && dynamicSecProviders.length() > 0) {
                this.loadDynamicSecurityProvider(dynamicSecProviders);
            }
            if ((dynamicSecProviders = myProps.getProperty(DYNAMIC_SECURITY_PROVIDERS)) != null && dynamicSecProviders.length() > 0) {
                this.loadDynamicSecurityProvider(dynamicSecProviders);
            }
            if (sc.getPStoreInitParams() != null) {
                PropertyUtils.loadPropertiesWithExpand(sc.getPStoreInitParams().getProperties(), props);
                SecurityModuleConfig.PropertySerializer[] propSers = sc.getPStoreInitParams().getPropertySerializers();
                if (propSers != null && propSers.length > 0) {
                    PropertySerializer[] instances = new PropertySerializer[propSers.length];
                    String[] keys = new String[propSers.length];
                    int i = 0;
                    while (i < propSers.length) {
                        PropertySerializer instance = SecurityModule.constructPropertySerializer(propSers[i]);
                        if (instance != null) {
                            instances[i] = instance;
                            keys[i] = propSers[i].getSerializerName();
                        }
                        ++i;
                    }
                    PStore.setAdditionalPropertySerializers((String[])keys, (PropertySerializer[])instances);
                }
            }
            try {
                Config.init((Properties)props, (ClassLoader)(class$com$idoox$wasp$security$server$SecurityModule == null ? (class$com$idoox$wasp$security$server$SecurityModule = SecurityModule.class$("com.idoox.wasp.security.server.SecurityModule")) : class$com$idoox$wasp$security$server$SecurityModule).getClassLoader());
            }
            catch (RuntimeException e) {
                dbg.warn("Security config already initialized", (Throwable)e);
            }
            HashMap<String, String> map = new HashMap<String, String>(11);
            if (sc.getUpdateablePolicy() != null) {
                PropertyUtils.loadPropertiesWithExpand(sc.getUpdateablePolicy().getProperties(), map);
                map.put("wasp.policy.impl", sc.getUpdateablePolicy().getProviderClass());
            }
            if (map.get("wasp.policy.impl") == null) {
                map.put("wasp.policy.impl", "org.systinet.security.policy.AcceptingUpdateablePolicy");
            }
            UpdateablePolicy policy = null;
            try {
                policy = UpdateablePolicy.initSingleton(map);
            }
            catch (SecurityException e) {
                if ("Singleton of WASPAccessController is already initialized!".equals(e.getMessage())) {
                    dbg.warn("Singleton of WASPAccessController is already initialized!");
                    return;
                }
                throw e;
            }
            map.clear();
            if (sc.getAccessController() != null) {
                PropertyUtils.loadPropertiesWithExpand(sc.getAccessController().getProperties(), map);
                map.put("wasp.ac.impl", sc.getAccessController().getProviderClass());
            }
            if (map.get("wasp.ac.impl") == null) {
                map.put("wasp.ac.impl", "com.systinet.security.policy.PolicyAccessController");
            }
            map.put("wasp.ac.policy.instance", (String)policy);
            WASPAccessController.initSingleton(map);
            if (sc.getPStoreInitParams() != null) {
                try {
                    PStore.getInstance(null);
                    if (System.getProperty("pstore.source.config.file") != null) {
                        try {
                            ((Hashtable)System.getProperties()).remove("pstore.source.config.file");
                        }
                        catch (Exception e) {
                            dbg.error("Unable to unset 'pstore.source.config.file' system property!");
                        }
                    }
                }
                catch (Exception e) {
                    dbg.error("Unable to initialize protected store with null password", (Throwable)e);
                }
            }
            if (policy instanceof NotificationListener) {
                PStore.getInstance(null).getUserStore().addNotificationListener((NotificationListener)policy);
            }
            try {
                Configuration.getConfiguration().getAppConfigurationEntry("");
            }
            catch (Exception e) {
                dbg.debug("Unable to initialize JAAS Config", (Throwable)e);
            }
            RegistryImpl registry = (RegistryImpl)Context.getInstance((String)"org.systinet.wasp.webservice.IRegistry");
            registry.addListener((ServiceEndpointListener)new InitializeSecurityListener());
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Cannot initialize security module", (Throwable)e);
        }
        InitialReferencesRegistrar.addInitialReference((String)"XML_SIGNATURE_FACTORY", (Object)new SignatureFactoryImpl());
        SignatureImpl.initSignature();
        WaspSecurity.init((WaspSecurity.SPI)new WaspSecurityImpl());
        Registry.addListener((ServiceClientListener)new SecurityClientListener());
    }

    private void loadDynamicSecurityProvider(String providers) {
        StringTokenizer st = new StringTokenizer(providers, " ;");
        while (st.hasMoreTokens()) {
            String providerName = st.nextToken();
            try {
                Security.addProvider((Provider)Class.forName(providerName).newInstance());
            }
            catch (Exception e) {
                dbg.warn("runtime adding security provider " + providerName + " failed");
            }
        }
    }

    public void init() {
    }

    public void destroy() {
        try {
            PStore.getInstance(null).destroy();
        }
        catch (Exception e) {
            dbg.warn("Unable to destroy PStore", (Throwable)e);
        }
        try {
            UpdateablePolicy.getUpdateablePolicy().destroy();
        }
        catch (Exception e) {
            dbg.warn("Unable to destroy UpdatablePolicy", (Throwable)e);
        }
    }

    private static PropertySerializer constructPropertySerializer(SecurityModuleConfig.PropertySerializer configEntry) {
        if (configEntry.getProviderClass() == null) {
            return null;
        }
        try {
            Class<?> cl = Class.forName(configEntry.getProviderClass());
            if (configEntry.getProperties() == null || configEntry.getProperties().length == 0) {
                return (PropertySerializer)cl.newInstance();
            }
            try {
                HashMap map = new HashMap(configEntry.getProperties().length * 2 + 1);
                PropertyUtils.loadPropertiesWithExpand(configEntry.getProperties(), map);
                Constructor<?> constr = cl.getConstructor(class$java$util$Map == null ? (class$java$util$Map = SecurityModule.class$("java.util.Map")) : class$java$util$Map);
                return (PropertySerializer)constr.newInstance(map);
            }
            catch (NoSuchMethodException nsme) {
                dbg.warn("Unable to construct property serializer with parameters, class " + configEntry.getProviderClass());
                dbg.warn("Trying to construct property serializer with no parameters");
                return (PropertySerializer)cl.newInstance();
            }
        }
        catch (Exception e) {
            dbg.error("Unable to instantiate property serilizer, class: " + configEntry.getProviderClass(), (Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

