/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.wasp.Constants;
import com.idoox.xml.security.TokenizerUtil;
import java.io.IOException;
import java.util.Stack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerResolver;
import org.idoox.xml.security.ReferencedData;
import org.idoox.xml.security.SignatureException;
import org.idoox.xml.security.Transform;

public class EnvelopedTransform
extends Transform {
    public EnvelopedTransform() {
        super("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
    }

    public ReferencedData transform(ReferencedData parm1) throws SignatureException {
        try {
            Tokenizer source = parm1.getTokenizer();
            byte[] bytesData = EnvelopedTransformResolver.toCanonicalForm(source, true);
            return new ReferencedData(bytesData);
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureException("transformation error " + (e.getMessage() == null ? "" : e.getMessage()), e);
        }
    }

    private static class EnvelopedTransformResolver
    extends TokenizerResolver {
        private EnvelopedTransformResolver() {
        }

        public static byte[] toCanonicalForm(Tokenizer source, boolean addAncestorPrefix) throws TokenizerException, IOException {
            String xmlString = "";
            Token token = new Token();
            byte state = source.currentState();
            if (state != 2 && state != 4) {
                throw new TokenizerException("Source must be in START_TOKEN or CONTENT state");
            }
            TokenizerResolver.PrefixesStack registeredPrefixes = new TokenizerResolver.PrefixesStack();
            Stack tokenNames = new Stack();
            state = EnvelopedTransformResolver.jumpOverSig(source);
            if (addAncestorPrefix && state == 2) {
                source.readToken(token);
                xmlString = xmlString + TokenizerResolver.engineCanonicalizeStartToken((Tokenizer)source, (Token)token, (TokenizerResolver.PrefixesStack)registeredPrefixes, tokenNames, (boolean)true);
                state = source.next();
            }
            while (state != 1) {
                switch (state) {
                    case 2: {
                        source.readToken(token);
                        xmlString = xmlString + TokenizerResolver.engineCanonicalizeStartToken((Tokenizer)source, (Token)token, (TokenizerResolver.PrefixesStack)registeredPrefixes, tokenNames, (boolean)false);
                        break;
                    }
                    case 3: {
                        String tokenName = (String)tokenNames.pop();
                        xmlString = xmlString + "</" + tokenName + ">";
                        registeredPrefixes.unregisterPrefixes();
                        break;
                    }
                    case 4: {
                        xmlString = xmlString + TokenizerResolver.normalizeText((String)source.readContent());
                        break;
                    }
                }
                state = source.next();
                state = EnvelopedTransformResolver.jumpOverSig(source);
            }
            return xmlString.getBytes(Constants.UTF_8);
        }

        private static byte jumpOverSig(Tokenizer source) throws TokenizerException, IOException {
            String ns;
            if (source.currentState() != 2) {
                return source.currentState();
            }
            boolean found = false;
            if (source.getLocalName().equals("Signature") && (ns = source.getNamespace()) != null && ns.equals("http://www.w3.org/2000/09/xmldsig#")) {
                found = true;
                int[] depth = new int[]{0};
                while (depth[0] >= 0) {
                    TokenizerUtil.tokenizerNext(source, depth);
                    if (depth[0] != 0 || source.currentState() != 3) continue;
                    source.next();
                    break;
                }
            }
            if (found) {
                EnvelopedTransformResolver.jumpOverSig(source);
            }
            return source.currentState();
        }
    }
}

