/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.xml.ReaderTokenizer;
import com.idoox.xml.security.Base64Transform;
import com.idoox.xml.security.C14nExcTransform;
import com.idoox.xml.security.C14nTransform;
import com.idoox.xml.security.DSAKeyContent;
import com.idoox.xml.security.EnvelopedTransform;
import com.idoox.xml.security.KeyInfo;
import com.idoox.xml.security.LicenseLocation;
import com.idoox.xml.security.RSAKeyContent;
import com.idoox.xml.security.Reference;
import com.idoox.xml.security.SignatureBase;
import com.idoox.xml.security.SignatureValue;
import com.idoox.xml.security.SignedInfo;
import com.idoox.xml.security.TokenizerUtil;
import com.idoox.xml.security.X509CertificateContent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.KeyContentFactory;
import org.idoox.xml.security.ReferencedData;
import org.idoox.xml.security.SignatureCreator;
import org.idoox.xml.security.SignatureException;
import org.idoox.xml.security.SignatureVerifier;
import org.idoox.xml.security.Transform;

public class SignatureImpl
extends SignatureBase
implements SignatureCreator,
SignatureVerifier {
    private SignedInfo signedInfo;
    private KeyInfo keyInfo;
    private Vector transformAlgorithms = new Vector();
    private String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String canonicalizationMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private String signatureMethod = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private SecretKey secretKey = null;
    private X509Certificate certificate = null;
    private String referenceURI = null;
    private Map keyContents = new HashMap();
    private String keyName = null;
    private String signatureValue = null;
    private ReferencedData dataSource = null;
    private String prefix = "";
    private Map ancestorNamespaces = new HashMap();
    private static boolean initialized = false;

    public static void initSignature() {
        if (initialized) {
            return;
        }
        Transform.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", new C14nTransform());
        Transform.addTransform("http://www.w3.org/2000/09/xmldsig#base64", new Base64Transform());
        Transform.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", new EnvelopedTransform());
        Transform.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#", new C14nExcTransform());
        KeyContentFactory.registerKeyContent(new RSAKeyContent());
        KeyContentFactory.registerKeyContent(new DSAKeyContent());
        KeyContentFactory.registerKeyContent(new X509CertificateContent());
        KeyContentFactory.registerKeyContent(new LicenseLocation());
        initialized = true;
    }

    public void addTransformAlgorithm(String transformAlgorithm) {
        this.transformAlgorithms.add(transformAlgorithm);
    }

    public String[] getTransformAlgorithms() {
        if (this.transformAlgorithms.size() == 0) {
            return new String[0];
        }
        String[] result = new String[this.transformAlgorithms.size()];
        this.transformAlgorithms.toArray(result);
        return result;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setReferenceURI(String referenceURI) {
        this.referenceURI = referenceURI;
    }

    public String getReferenceURI() {
        return this.referenceURI;
    }

    public void setKeyContentData(QName keyContentName, Map keyContentData) {
        this.keyContents.put(keyContentName, keyContentData);
    }

    public void addAncestorNamespace(String prefix, String value) {
        this.ancestorNamespaces.put(prefix, value);
    }

    public void addAncestorNamespaces(Map namespaces) {
        this.ancestorNamespaces.putAll(namespaces);
    }

    public Tokenizer createSignature(Tokenizer source, PrivateKey privateKey, PublicKey publicKey) throws SignatureException {
        try {
            this.initCreate(privateKey, publicKey);
            this.createSignedInfo(source);
            this.createKeyInfo();
            this.createSignatureValue();
            ReaderTokenizer tok = new ReaderTokenizer((Reader)new StringReader(this.toCanonicalXMLString()));
            tok.next();
            return tok;
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Signature. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public Tokenizer createSignature(Tokenizer source, PrivateKey privateKey, X509Certificate certificate) throws SignatureException {
        try {
            this.initCreate(privateKey, certificate);
            this.createSignedInfo(source);
            this.createKeyInfo();
            this.createSignatureValue();
            ReaderTokenizer tok = new ReaderTokenizer((Reader)new StringReader(this.toCanonicalXMLString()));
            tok.next();
            return tok;
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Signature. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Tokenizer createSignature(Tokenizer source, SecretKey secretKey) throws SignatureException {
        try {
            void e;
            this.initCreate(secretKey);
            this.createSignedInfo(source);
            this.createSignatureValue();
            ReaderTokenizer tok = new ReaderTokenizer((Reader)new StringReader(this.toCanonicalXMLString()));
            tok.next();
            return e;
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Signature. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private void createSignatureValue() throws SignatureException {
        if (this.privateKey != null) {
            this.signatureValue = SignatureValue.getInstance(this.signedInfo.getSignatureMethod()).getSignatureValue(this.signedInfo, this.privateKey);
        } else if (this.secretKey != null) {
            this.signatureValue = SignatureValue.getInstance(this.signedInfo.getSignatureMethod()).getSignatureValue(this.signedInfo, this.secretKey);
        }
    }

    private void initCreate(SecretKey secretKey) {
        this.secretKey = secretKey;
        if (this.signatureMethod == null) {
            this.signatureMethod = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }
    }

    private void initCreate(PrivateKey privateKey, PublicKey publicKey) throws SignatureException {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        if (this.signatureMethod == null) {
            if (privateKey instanceof DSAPrivateKey) {
                this.signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else if (privateKey instanceof RSAPrivateKey) {
                this.signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else {
                throw new SignatureException("implementation for the given key not implemented yet");
            }
        }
    }

    private void initCreate(PrivateKey privateKey, X509Certificate certificate) throws SignatureException {
        this.privateKey = privateKey;
        this.certificate = certificate;
        if (privateKey instanceof DSAPrivateKey) {
            this.signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (privateKey instanceof RSAPrivateKey) {
            this.signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            throw new SignatureException("implementation for the given key not implemented yet");
        }
    }

    private void createKeyInfo() throws SignatureException {
        try {
            this.keyInfo = new KeyInfo(this.keyName, this.publicKey, this.certificate, this.keyContents, this.prefix);
        }
        catch (Exception e) {
            throw new SignatureException("Error creating KeyInfo. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private String toCanonicalXMLString() throws SignatureException {
        try {
            StringBuffer sb = new StringBuffer();
            String startTag = "";
            String endTag = "";
            if (!this.prefix.equals("")) {
                startTag = "<" + this.prefix + ":";
                endTag = "</" + this.prefix + ":";
            } else {
                startTag = "<";
                endTag = "</";
            }
            if (this.prefix.equals("")) {
                sb.append(startTag).append("Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n");
            } else {
                sb.append(startTag).append("Signature xmlns:" + this.prefix + "=\"http://www.w3.org/2000/09/xmldsig#\">\n");
            }
            sb.append(this.signedInfo.toCanonicalXMLString()).append("\n");
            sb.append(startTag).append("SignatureValue>");
            sb.append(this.signatureValue);
            sb.append(endTag).append("SignatureValue>\n");
            if (this.keyInfo != null) {
                sb.append(this.keyInfo.toCanonicalXMLString()).append("\n");
            }
            sb.append(endTag).append("Signature>");
            String ret = sb.toString();
            return ret;
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Signature. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private void createSignedInfo(Tokenizer source) throws SignatureException {
        try {
            ReferencedData si = new ReferencedData(source);
            String[] transformsStr = this.getTransformAlgorithms();
            Transform[] transforms = new Transform[transformsStr.length];
            int i = 0;
            while (i < transforms.length) {
                transforms[i] = Transform.getInstance(transformsStr[i]);
                ++i;
            }
            Reference[] references = new Reference[]{new Reference(this.referenceURI, null, this.digestMethod, transforms, si, this.prefix)};
            this.signedInfo = new SignedInfo(si, references, this.signatureMethod, this.canonicalizationMethod, this.prefix, this.ancestorNamespaces);
            if (this.signedInfo.getSignatureMethod().equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                Mac mac = Mac.getInstance("HmacSHA1");
                mac.init(this.secretKey);
                this.signedInfo.hmacOutputLength = String.valueOf(mac.getMacLength() * 8);
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating SignedInfo. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public boolean verify(Tokenizer signature, Tokenizer source) {
        this.dataSource = new ReferencedData(source);
        return this.verify(signature);
    }

    private boolean verify(Tokenizer signature) {
        try {
            TokenizerUtil.constructChildrenElements(this, signature);
            boolean signedInfoOK = this.signedInfo.verify();
            if (!signedInfoOK) {
                return false;
            }
            SignatureValue signatureValuer = SignatureValue.getInstance(this.signedInfo.getSignatureMethod());
            boolean signatureOK = false;
            if (this.keyInfo != null) {
                signatureOK = signatureValuer.verify(this.signedInfo, this.keyInfo, this.signatureValue);
            }
            if (!signatureOK && this.secretKey != null) {
                signatureOK = signatureValuer.verify(this.signedInfo, this.secretKey, this.signatureValue);
            }
            return signatureOK;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean verify(Tokenizer signature, Tokenizer source, SecretKey secretKey) {
        this.secretKey = secretKey;
        return this.verify(signature, source);
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            String name = tokenizer.getLocalName();
            if (name.equals("SignedInfo")) {
                this.signedInfo = new SignedInfo(this.dataSource, tokenizer);
                return true;
            }
            if (name.equals("SignatureValue")) {
                tokenizer.next();
                this.signatureValue = tokenizer.readContent();
                tokenizer.next();
                return true;
            }
            if (name.equals("KeyInfo")) {
                this.keyInfo = new KeyInfo(tokenizer, this.keyContents);
                return true;
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating Signature. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
        return false;
    }

    public SignatureImpl newInstance() {
        return new SignatureImpl();
    }

    public Certificate[] getCertificates() {
        if (this.keyInfo == null) {
            return null;
        }
        return this.keyInfo.getCertificates();
    }

    public boolean verifyEnvelopedSignature(Tokenizer source) {
        Tokenizer signature = null;
        try {
            this.dataSource = new ReferencedData(source);
            signature = TokenizerUtil.getSignature((Tokenizer)new ReaderTokenizer((InputStream)new ByteArrayInputStream(this.dataSource.getBytes())));
        }
        catch (Exception e) {
            return false;
        }
        return this.verify(signature);
    }

    static {
        SignatureImpl.initSignature();
    }
}

