/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.implementations.SunJCE;

import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethodSpi;
import com.systinet.wasp.security.secext.algorithms.encryption.implementations.SunJCE.PKCS15Cipher;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.PRNG;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyTransportImpl_RSAPKCS15_Wasp
extends EncryptionMethodSpi {
    PKCS15Cipher _cipher = null;

    public String getRequiredProviderName() {
        return "SunJCE";
    }

    public int getImplementedAlgorithmType() {
        return 3;
    }

    public String getImplementedAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    }

    public int engineGetIvLength() {
        return -1;
    }

    public int engineGetBlockSize() {
        if (this._cipher != null) {
            return this._cipher.getInputBlockSize();
        }
        return 0;
    }

    public EncryptionMethodParams engineInit(Document doc, EncryptionMethodParams params) throws XMLSecurityException {
        if (params != null) {
            throw new XMLSecurityException("empty");
        }
        this._cipher = new PKCS15Cipher();
        return params;
    }

    public EncryptionMethodParams engineInit(Element encryptionMethodElem) throws XMLSecurityException {
        if (encryptionMethodElem.getChildNodes().getLength() != 0) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        this._cipher = new PKCS15Cipher();
        return null;
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey) throws XMLSecurityException {
        try {
            this._cipher.init(1, wrapKey, PRNG.getInstance().getSecureRandom());
            byte[] contentKeyBytes = contentKey.getEncoded();
            return this._cipher.encodeBlock(contentKeyBytes, 0, contentKeyBytes.length);
        }
        catch (InvalidKeyException e) {
            throw new XMLSecurityException("Invalid Key", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new XMLSecurityException("Illegal bolck size", e);
        }
        catch (BadPaddingException e) {
            throw new XMLSecurityException("Bad Padding", e);
        }
    }

    public Key engineUnwrap(byte[] wrappedKey, Key wrapKey, String wrappedKeyAlgoURI) throws XMLSecurityException {
        try {
            this._cipher.init(2, wrapKey, null);
            String keyAlgorithm = JCEMapper.translateURItoJCEID(wrappedKeyAlgoURI, this.getRequiredProviderName()).getAlgorithmID();
            int keyType = JCEMapper.getKeyTypeFromURI(wrappedKeyAlgoURI);
            byte[] decoded = this._cipher.decodeBlock(wrappedKey, 0, wrappedKey.length);
            if (keyType == 3) {
                int slashPos = keyAlgorithm.indexOf(47);
                if (slashPos > 0) {
                    return new SecretKeySpec(decoded, keyAlgorithm.substring(0, slashPos));
                }
                return new SecretKeySpec(decoded, keyAlgorithm);
            }
            try {
                KeyFactory kf = KeyFactory.getInstance(keyAlgorithm, this.getRequiredProviderName());
                if (keyType == 1) {
                    return kf.generatePublic(new X509EncodedKeySpec(decoded));
                }
                if (keyType == 2) {
                    return kf.generatePrivate(new PKCS8EncodedKeySpec(decoded));
                }
            }
            catch (NoSuchProviderException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (InvalidKeySpecException e2) {
                throw new InvalidKeyException("Unknown key type " + e2.getMessage());
            }
            throw new InvalidKeyException("Unknown key type " + keyType);
        }
        catch (BadPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey, byte[] IV) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotUnderstandIV");
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey, byte[] IV) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineDecrypt(byte[] ciphertextBytes, Key contentKey) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }
}

