/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.implementations.SunJCE;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class RSACipher_RAW
extends CipherSpi {
    private boolean encrypt;
    private BigInteger modulus;
    private BigInteger exponent;
    private int modulusLength;
    private RSAKey key;

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new IllegalArgumentException("No Modes");
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new IllegalArgumentException("No Paddings");
    }

    protected int engineGetBlockSize() {
        if (this.encrypt) {
            return (this.modulusLength + 7) / 8 - 1;
        }
        return (this.modulusLength + 7) / 8;
    }

    protected int engineGetOutputSize(int inputSize) {
        if (this.encrypt) {
            return (this.modulusLength + 7) / 8;
        }
        return (this.modulusLength + 7) / 8 - 1;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int opmode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key instanceof RSAPrivateKey) {
            this.key = (RSAKey)((Object)key);
            this.modulus = this.key.getModulus();
            this.modulusLength = this.modulus.bitLength();
            this.exponent = ((RSAPrivateKey)key).getPrivateExponent();
        } else if (key instanceof RSAPublicKey) {
            this.key = (RSAKey)((Object)key);
            this.modulus = this.key.getModulus();
            this.modulusLength = this.modulus.bitLength();
            this.exponent = ((RSAPublicKey)key).getPublicExponent();
        } else {
            throw new InvalidKeyException("Key must be an instance of RSAKey!");
        }
        this.encrypt = opmode == 1 || opmode == 3;
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParametersSpec");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameters");
    }

    protected byte[] engineUpdate(byte[] bytes, int inputOffset, int inputLen) {
        throw new RuntimeException("Update operation is unsupported");
    }

    protected int engineUpdate(byte[] bytes, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        throw new RuntimeException("Update operation is unsupported");
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] o = new byte[this.engineGetOutputSize(inputLen)];
        try {
            this.engineDoFinal(input, inputOffset, inputLen, o, 0);
        }
        catch (ShortBufferException shortbufferexception) {
            throw new RuntimeException("Should buffer for storing results, internal exception!");
        }
        return o;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] input2;
        if (inputLen > this.engineGetBlockSize()) {
            throw new IllegalBlockSizeException("Input too large");
        }
        if (inputOffset != 0 || inputLen != input.length) {
            input2 = new byte[inputLen];
            System.arraycopy(input, inputOffset, input2, 0, inputLen);
        } else {
            input2 = input;
        }
        BigInteger algInput = new BigInteger(1, input2);
        byte[] algOutput = algInput.modPow(this.exponent, this.modulus).toByteArray();
        int algOuputLength = algOutput.length;
        int engineOutputSize = this.engineGetOutputSize(inputLen);
        if (this.encrypt) {
            if (algOutput[0] == 0 && algOuputLength > engineOutputSize) {
                System.arraycopy(algOutput, 1, output, outputOffset, --algOuputLength);
            } else if (algOuputLength < engineOutputSize) {
                System.arraycopy(algOutput, 0, output, outputOffset + engineOutputSize - algOuputLength, algOuputLength);
                int i = 0;
                while (i < engineOutputSize - algOuputLength) {
                    output[outputOffset + i] = 0;
                    ++i;
                }
                algOuputLength = engineOutputSize;
            } else {
                System.arraycopy(algOutput, 0, output, outputOffset, engineOutputSize);
            }
        } else if (algOutput[0] == 0) {
            System.arraycopy(algOutput, 1, output, outputOffset, --algOuputLength);
        } else {
            System.arraycopy(algOutput, 0, output, outputOffset, engineOutputSize);
        }
        return algOuputLength;
    }
}

