/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.params;

import com.systinet.wasp.security.secext.algorithms.MessageDigestAlgorithm;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OAEPParams
extends EncryptionMethodParams {
    String _digestMethodURI;
    byte[] _OAEPParamBytes;
    public static final String DEFAULT_DIGEST = "http://www.w3.org/2000/09/xmldsig#sha1";

    public String getAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    public OAEPParams(String digestMethodURI, byte[] OAEPParamBytes) {
        this._digestMethodURI = digestMethodURI == null ? DEFAULT_DIGEST : digestMethodURI;
        this._OAEPParamBytes = (byte[])(OAEPParamBytes == null || OAEPParamBytes.length == 0 ? null : OAEPParamBytes);
    }

    public OAEPParams(Element encryptionMethodElem) throws XMLSecurityException {
        Element digestElem = XMLUtils.getDirectChild(encryptionMethodElem, "DigestMethod", "http://www.w3.org/2000/09/xmldsig#");
        Element paramElem = XMLUtils.getDirectChild(encryptionMethodElem, "OAEPparams", "http://www.w3.org/2001/04/xmlenc#");
        if (digestElem == null) {
            throw new XMLSecurityException("encryption.MissingDigestMethod");
        }
        if (paramElem == null) {
            throw new XMLSecurityException("encryption.MissingOAEPParams");
        }
        this._digestMethodURI = digestElem.getAttributeNS(null, "Algorithm");
        this._OAEPParamBytes = Base64.decode(paramElem);
    }

    public String getDigestMethodURI() {
        return this._digestMethodURI;
    }

    public byte[] getOAEPParamBytes() {
        return this._OAEPParamBytes;
    }

    public DocumentFragment createChildNodes(Document doc) throws XMLSecurityException {
        DocumentFragment nl = doc.createDocumentFragment();
        XMLUtils.addReturnToNode(nl);
        MessageDigestAlgorithm mda = MessageDigestAlgorithm.getInstance(doc, this.getDigestMethodURI());
        nl.appendChild(mda.getElement());
        XMLUtils.addReturnToNode(nl);
        if (this.getOAEPParamBytes() != null && this.getOAEPParamBytes().length > 0) {
            Element oaepElem = XMLUtils.createElementInEncryptionSpace(doc, "OAEPparams");
            if (this.getOAEPParamBytes() != null) {
                Text oaepText = doc.createTextNode(Base64.encode(this.getOAEPParamBytes()));
                oaepElem.appendChild(oaepText);
            }
            nl.appendChild(oaepElem);
            XMLUtils.addReturnToNode(nl);
        }
        return nl;
    }
}

