/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.transforms.implementations;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXSLT
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String XSLTSpecNS = "http://www.w3.org/1999/XSL/Transform";
    public static final String defaultXSLTSpecNSprefix = "xslt";
    public static final String XSLTSTYLESHEET = "stylesheet";

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return true;
    }

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, TransformationException {
        try {
            Element transformElement = this._transformObject.getElement();
            Document doc = transformElement.getOwnerDocument();
            Element nscontext = XMLUtils.createDSctx(doc, defaultXSLTSpecNSprefix, XSLTSpecNS);
            Element _xsltElement = (Element)XPathAPI.selectSingleNode((Node)transformElement, (String)"./xslt:stylesheet", (Node)nscontext);
            if (_xsltElement == null) {
                Object[] exArgs = new Object[]{"xslt:stylesheet", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(input.getBytes()));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(_xsltElement);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            StreamSource stylesheet = new StreamSource(new ByteArrayInputStream(os.toByteArray()));
            Transformer transformer2 = tFactory.newTransformer(stylesheet);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult outputTarget = new StreamResult(baos);
            transformer2.transform(xmlSource, outputTarget);
            return new XMLSignatureInput(baos.toByteArray());
        }
        catch (InvalidCanonicalizerException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (XMLSecurityException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (TransformerConfigurationException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
        catch (TransformerException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            throw new TransformationException("generic.EmptyMessage", exArgs, ex);
        }
    }
}

