/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.systinet.wasp.security.secext.encryption.Reference;
import com.systinet.wasp.security.secext.encryption.ReferenceList;
import com.systinet.wasp.security.secext.encryption.XMLCipher;
import com.systinet.wasp.security.secext.encryption.XMLEncryptionException;
import com.systinet.wasp.security.ws.impl.EncryptedDataObject;
import com.systinet.wasp.security.ws.impl.EncryptedKeyObject;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import java.util.Iterator;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.EncryptionReferenceConf;
import org.systinet.wasp.security.ws.conf.ReferenceListConf;
import org.w3c.dom.Element;

public class ReferenceListObject
extends WSSecurityObject {
    private static final Category cat = Category.getCategory((String)(class$com$systinet$wasp$security$ws$impl$ReferenceListObject == null ? (class$com$systinet$wasp$security$ws$impl$ReferenceListObject = ReferenceListObject.class$("com.systinet.wasp.security.ws.impl.ReferenceListObject")) : class$com$systinet$wasp$security$ws$impl$ReferenceListObject).getName());
    private String wsuId;
    private ReferenceList referenceList;
    protected XMLCipher.Factory factory;
    protected Element referenceListElement;
    static /* synthetic */ Class class$com$systinet$wasp$security$ws$impl$ReferenceListObject;

    public ReferenceListObject(SecurityContext securityContext, ReferenceListConf conf) throws WSSecurityException {
        super(securityContext, conf);
        this.factory = XMLCipher.getFactory(this.getSecurityContext().getMessageDocument());
        this.wsuId = conf.getWsuId();
        EncryptionReferenceConf[] refs = conf.getReferences();
        if (refs == null) {
            refs = new EncryptionReferenceConf[]{};
        }
        this.referenceList = new ReferenceList();
        int i = 0;
        while (i < refs.length) {
            String uri = refs[i].getRefUri();
            if (!uri.startsWith("#")) {
                cat.error("ReferenceList can have local references only");
                throw WSSecurityException.INVALID_SECURITY;
            }
            WSSecurityObject obj = this.getSecurityContext().resolveSecurityObjectById(uri.substring(1));
            Reference ref = null;
            if (obj == null) {
                cat.error("ReferenceList's reference \"" + uri + "\" not found");
                throw WSSecurityException.INVALID_SECURITY;
            }
            if (obj instanceof EncryptedDataObject) {
                ref = ReferenceList.newDataReference(uri);
                ((EncryptedDataObject)obj).setReferenced();
            } else if (obj instanceof EncryptedKeyObject) {
                ref = ReferenceList.newKeyReference(uri);
            } else {
                cat.error("ReferenceList's reference \"" + uri + "\" does not refere to EncryptedData or EncryptedKey");
                throw WSSecurityException.INVALID_SECURITY;
            }
            this.referenceList.add(ref);
            ++i;
        }
    }

    public ReferenceListObject(SecurityContext securityContext, Element refereceListElement) throws WSSecurityException {
        super(securityContext, refereceListElement);
        try {
            this.factory = XMLCipher.getFactory(this.getSecurityContext().getMessageDocument());
            this.referenceListElement = refereceListElement;
            this.referenceList = this.factory.newReferenceList(refereceListElement);
        }
        catch (XMLEncryptionException e) {
            cat.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    public void doFinal() throws WSSecurityException {
        if (this.getMode() == 0) {
            this.getSecurityContext().prependSecurityElement(this.factory.toElement(this.referenceList));
        } else {
            Iterator it = this.referenceList.getReferences();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                String uri = ref.getURI();
                if (!uri.startsWith("#")) {
                    cat.error("ReferenceList supports local reference only");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                Element el = this.getSecurityContext().resolveElementById(uri.substring(1));
                if (el == null) {
                    cat.error("ReferenceList does not refere to element in message");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                String localName = el.getLocalName();
                String namespace = el.getNamespaceURI();
                if (ref.getRefType() == 2 && "http://www.w3.org/2001/04/xmlenc#".equals(namespace) && "EncryptedData".equals(localName)) {
                    EncryptedDataObject edo = new EncryptedDataObject((SecurityContext)this.getSecurityContext(), el);
                    edo.doFinal();
                    continue;
                }
                if (ref.getRefType() == 1 && "http://www.w3.org/2001/04/xmlenc#".equals(namespace) && "EncryptedKey".equals(localName)) {
                    EncryptedKeyObject eko = new EncryptedKeyObject((SecurityContext)this.getSecurityContext(), el);
                    eko.doFinal();
                    continue;
                }
                cat.error("referenceList does not refere to encryptedData or encryptedKey");
                throw WSSecurityException.INVALID_SECURITY;
            }
            this.getSecurityContext().addReceivedReferenceListConf(this.getReceivedConf());
        }
    }

    public String getWsuId() {
        return this.wsuId;
    }

    protected ReferenceListConf getReceivedConf() {
        ReferenceListConf conf = this.getSecurityContext().getMessageConf().newReferenceList();
        int cnt = 0;
        Iterator it = this.referenceList.getReferences();
        while (it.hasNext()) {
            it.next();
            ++cnt;
        }
        EncryptionReferenceConf[] refs = new EncryptionReferenceConf[cnt];
        conf.setReferences(refs);
        conf.setWsuId(this.getWsuId());
        if (conf.getWsuId() == null) {
            conf.setWsuId(WSSecurityHelper.getWsuIdFromElement(this.referenceListElement));
        }
        int i = 0;
        Iterator it2 = this.referenceList.getReferences();
        while (it2.hasNext()) {
            Reference ref = (Reference)it2.next();
            String uri = ref.getURI();
            refs[i] = conf.newReference();
            refs[i].setRefUri(uri);
            ++i;
        }
        return conf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

