/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.idoox.security.jaas.WaspCallbackHandler;
import com.idoox.security.server.ReceivedCredentialsImpl;
import com.systinet.wasp.security.secext.algorithms.MessageDigestAlgorithm;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.keys.KeyInfo;
import com.systinet.wasp.security.secext.signature.Reference;
import com.systinet.wasp.security.secext.signature.SignedInfo;
import com.systinet.wasp.security.secext.signature.XMLSignature;
import com.systinet.wasp.security.secext.signature.XMLSignatureException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.Transform;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.transforms.Transforms;
import com.systinet.wasp.security.secext.transforms.params.XPathContainer;
import com.systinet.wasp.security.secext.utils.XMLUtils;
import com.systinet.wasp.security.ws.X509SecurityToken;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.WSKeyInfo;
import com.systinet.wasp.security.ws.impl.WSKeyInfoImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import com.systinet.wasp.security.ws.impl.WSSecurityObject;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.pstore.PStore;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.KeyInfoConf;
import org.systinet.wasp.security.ws.conf.OrderedElementConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.ReferenceConf;
import org.systinet.wasp.security.ws.conf.SignatureConf;
import org.systinet.wasp.security.ws.conf.TransformConf;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureSecurityObject
extends WSSecurityObject {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.impl.SignatureSecurityObject");
    private XMLSignature signature = null;
    String sigWsuId = null;
    private Document message = null;
    private WSKeyInfo keyInfo = null;
    private boolean generateWsuId = true;
    private SignatureConf receivedSignatureConf = null;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$ReferenceConf;

    public SignatureSecurityObject(SecurityContext securityContext, Element element) throws WSSecurityException {
        super(securityContext, element);
        try {
            this.signature = new XMLSignature(element, element.getNamespaceURI());
            this.keyInfo = new WSKeyInfoImpl((WSSecurityObject)this, this.signature.getKeyInfo());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.INVALID_SECURITY;
        }
    }

    public SignatureSecurityObject(SecurityContext securityContext, OrderedElementConf configuration) throws WSSecurityException {
        super(securityContext, configuration);
        this.message = this.getSecurityContext().getMessageDocument();
        SignatureConf signatureConfig = (SignatureConf)configuration;
        Boolean signBody = null;
        signBody = signatureConfig.getSignBody();
        if (signBody == null) {
            signBody = Boolean.FALSE;
        }
        try {
            ReferenceConf[] referenceConfs = signatureConfig.getReferences();
            if (referenceConfs == null && !signBody.booleanValue()) {
                return;
            }
            String signatureMethod = signatureConfig.getSignatureMethod();
            String canonicalizationMethod = signatureConfig.getCanonicalizationMethod();
            if (signatureMethod == null) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
            if (canonicalizationMethod == null) {
                canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
            }
            this.signature = new XMLSignature(this.message, "", signatureMethod, canonicalizationMethod);
            if (signBody.booleanValue()) {
                String bodyId = this.processBodyId();
                this.processReference(this.createDefaultReferenceTo(bodyId), this.signature, securityContext);
            }
            this.sigWsuId = signatureConfig.getWsuId();
            if (this.sigWsuId == null) {
                this.generateWsuId = false;
                this.sigWsuId = WSSecurityImpl.genId();
            }
            int i = 0;
            while (i < (referenceConfs == null ? 0 : referenceConfs.length)) {
                ReferenceConf referenceConf = referenceConfs[i];
                this.processReference(referenceConf, this.signature, securityContext);
                ++i;
            }
            this.keyInfo = new WSKeyInfoImpl((WSSecurityObject)this, signatureConfig.getKeyInfo());
            this.getSecurityContext().addSecurityObject(this);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(e);
        }
    }

    public void doFinal() throws WSSecurityException {
        if (this.getMode() == 0) {
            this.doFinalGenerate();
        } else {
            this.doFinalReceive();
        }
    }

    private void doFinalReceive() throws WSSecurityException {
        try {
            this.keyInfo.doFinal();
            Key secretKey = this.keyInfo.getAuthenticatingKey();
            if (secretKey != null) {
                if (!this.signature.checkSignatureValue(secretKey)) {
                    throw WSSecurityException.FAILED_CHECK;
                }
                SecurityTokenSPI securityTokenSPI = this.keyInfo.getSecurityTokenSPI();
                Current securityCurrent = Current.getInstance();
                if (securityTokenSPI != null && securityTokenSPI instanceof X509SecurityToken && securityCurrent.getReceivedCredentials() == null && this.getReceivedSignatureConf().getSignBody().booleanValue()) {
                    this.mapUser(securityCurrent, (X509SecurityToken)securityTokenSPI);
                }
            } else {
                log.error("Unable to get either the certificate or secret key");
                throw WSSecurityException.INVALID_SECURITY_TOKEN;
            }
            this.getSecurityContext().addReceivedSignatureConf(this.getReceivedSignatureConf());
        }
        catch (XMLSignatureException e) {
            log.error("", (Throwable)e);
            throw WSSecurityException.FAILED_CHECK;
        }
    }

    private void mapUser(Current securityCurrent, X509SecurityToken securityTokenSPI) {
        try {
            X509Certificate[] certs = new X509Certificate[]{securityTokenSPI.getX509Certificate()};
            WaspCallbackHandler handler = new WaspCallbackHandler(certs, PStore.getInstance(null).getKeyStore(), PStore.getInstance(null).getUserStore());
            ReceivedCredentialsImpl cred = new ReceivedCredentialsImpl("", "WS-Security", "CertsMapping", (CallbackHandler)handler);
            securityCurrent.setReceivedCredentials((ReceivedCredentials)cred);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SignatureConf getReceivedSignatureConf() {
        if (this.receivedSignatureConf != null) {
            return this.receivedSignatureConf;
        }
        this.receivedSignatureConf = this.getSecurityContext().getMessageConf().newSignature();
        SignedInfo signedInfo = this.signature.getSignedInfo();
        if (signedInfo == null) {
            return null;
        }
        this.receivedSignatureConf.setCanonicalizationMethod(signedInfo.getCanonicalizationMethodURI());
        this.receivedSignatureConf.setSignatureMethod(signedInfo.getSignatureMethodURI());
        Element element = this.signature.getElement();
        this.receivedSignatureConf.setWsuId(WSSecurityHelper.getWsuIdFromElement(element));
        Vector<ReferenceConf> references = new Vector<ReferenceConf>();
        int i = 0;
        while (i < signedInfo.getLength()) {
            try {
                ReferenceConf referenceConf = this.receivedSignatureConf.newReference();
                references.add(referenceConf);
                Reference ref = signedInfo.item(i);
                referenceConf.setRefUri(ref.getURI());
                MessageDigestAlgorithm mda = ref.getMessageDigestAlgorithm();
                if (mda != null) {
                    referenceConf.setDigestAlgorithm(mda.getAlgorithmURI());
                }
                boolean bodySigned = false;
                int j = 0;
                while (j < signedInfo.getLength()) {
                    XMLSignatureInput input = signedInfo.getReferencedContentAfterTransformsItem(j);
                    Set set = null;
                    try {
                        set = input.getNodeSet();
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                        set = null;
                    }
                    if (set != null) {
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Node node = (Node)iterator.next();
                            if (node.getNodeType() != 1 || !"Body".equals(node.getLocalName()) || !this.getSecurityContext().getSoapNamespaceUri().equals(node.getNamespaceURI())) continue;
                            bodySigned = true;
                            break;
                        }
                    }
                    ++j;
                }
                Transforms transforms = ref.getTransforms();
                if (transforms != null) {
                    Vector<TransformConf> trans = new Vector<TransformConf>();
                    int j2 = 0;
                    while (j2 < transforms.getLength()) {
                        Transform t = transforms.item(j2);
                        TransformConf transformConf = referenceConf.newTransform();
                        trans.add(transformConf);
                        transformConf.setAlgorithm(t.getURI());
                        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(t.getURI())) {
                            NodeList childs = t.getElement().getChildNodes();
                            int jj = 0;
                            while (jj < childs.getLength()) {
                                Node child = childs.item(jj);
                                if (child.getNodeType() == 1 && "XPath".equals(child.getLocalName())) {
                                    transformConf.setXPath(WSSecurityHelper.getTextNodeValue((Element)child));
                                }
                                ++jj;
                            }
                        } else if ("http://schemas.xmlsoap.org/2003/06/STR-Transform".equals(t.getURI()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(t.getURI())) {
                            // empty if block
                        }
                        ++j2;
                    }
                    referenceConf.setTransforms(trans.toArray(new TransformConf[0]));
                }
                this.receivedSignatureConf.setSignBody(bodySigned ? Boolean.TRUE : Boolean.FALSE);
                KeyInfoConf keyInfoConf = this.receivedSignatureConf.newKeyInfo();
                if (this.keyInfo.setupKeyInfoConf(keyInfoConf)) {
                    this.receivedSignatureConf.setKeyInfo(keyInfoConf);
                }
            }
            catch (XMLSecurityException e) {
                log.error("", (Throwable)e);
            }
            ++i;
        }
        this.receivedSignatureConf.setReferences(references.toArray(new ReferenceConf[0]));
        return this.receivedSignatureConf;
    }

    private void doFinalGenerate() throws WSSecurityException {
        if (this.signature == null) {
            return;
        }
        Element signatureElement = this.signature.getElement();
        if (this.generateWsuId) {
            signatureElement.setAttribute("Id", this.sigWsuId);
        }
        this.getSecurityContext().prependSecurityElement(signatureElement);
        this.keyInfo.doFinal();
        Key sigKey = this.keyInfo.getSigningKey();
        if (sigKey == null) {
            throw new WSSecurityException(null, "The security token referenced in the key info has no mapping to the private or secret key " + this.sigWsuId);
        }
        Element element = this.keyInfo.getWrappedKeyInfo().getElement();
        NodeList nodeList = element.getChildNodes();
        KeyInfo keyInfo = this.signature.getKeyInfo();
        int j = 0;
        while (j < nodeList.getLength()) {
            if (nodeList.item(j).getNodeType() == 1) {
                keyInfo.addUnknownElement((Element)nodeList.item(j));
            }
            ++j;
        }
        try {
            this.signature.sign(sigKey);
        }
        catch (XMLSignatureException e) {
            throw new WSSecurityException(e);
        }
        this.getSecurityContext().removeSecurityObject(this);
    }

    public String getWsuId() {
        return this.sigWsuId;
    }

    private void processReference(ReferenceConf referenceConf, XMLSignature signature, SecurityContext securityContext) throws XMLSignatureException {
        String digestAlgorithm;
        Transforms transforms = null;
        TransformConf[] transformConfs = referenceConf.getTransforms();
        if (transformConfs != null) {
            transforms = new Transforms(this.message);
            int j = 0;
            while (j < transformConfs.length) {
                TransformConf transformConf = transformConfs[j];
                if (transformConf != null) {
                    String transformAlg = transformConf.getAlgorithm();
                    try {
                        if (transformAlg != null) {
                            String canonicalizationMethod;
                            if (transformAlg.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
                                XPathContainer xpath = new XPathContainer(this.message);
                                this.setXPathNamespaces(xpath, transformConf.getProperties());
                                xpath.setXPath(transformConf.getXPath());
                                transforms.addTransform(transformAlg, xpath.getElementPlusReturns());
                            } else if (transformAlg.equals("http://schemas.xmlsoap.org/2003/06/STR-Transform") && (canonicalizationMethod = WSSecurityHelper.getPropertyValue(transformConf.getProperties(), "strCanonicalizationAlg")) != null) {
                                Element parameter = null;
                                String wsseNamespace = securityContext.getWsseNamespace();
                                if (!WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace)) {
                                    parameter = XMLUtils.createElementInSignatureSpace(this.message, "CanonicalizationMethod");
                                    parameter.setAttribute("Algorithm", canonicalizationMethod);
                                } else {
                                    Document messageDocument = securityContext.getMessageDocument();
                                    parameter = messageDocument.createElementNS(wsseNamespace, WSSecurityImpl.getWssePrefix() + ":" + "TransformationParameters");
                                    Element canonicalizationMethodParameter = XMLUtils.createElementInSignatureSpace(this.message, "CanonicalizationMethod");
                                    parameter.appendChild(canonicalizationMethodParameter);
                                    canonicalizationMethodParameter.setAttribute("Algorithm", canonicalizationMethod);
                                    transformAlg = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
                                }
                                transforms.addTransform(transformAlg, parameter);
                            } else {
                                transforms.addTransform(transformAlg);
                            }
                        }
                    }
                    catch (TransformationException e) {
                        log.error("", (Throwable)e);
                        throw WSSecurityException.UNSUPPORTED_ALGORITHM;
                    }
                }
                ++j;
            }
        }
        if ((digestAlgorithm = referenceConf.getDigestAlgorithm()) == null) {
            digestAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        signature.addDocument(referenceConf.getRefUri(), transforms, digestAlgorithm);
    }

    private void setXPathNamespaces(XPathContainer xpath, PropertyConf[] properties) {
        if (properties == null) {
            return;
        }
        int i = 0;
        while (i < properties.length) {
            String value;
            StringTokenizer st;
            PropertyConf property = properties[i];
            if (property != null && "xpathNsMap".equals(property.getPropertyName()) && (st = new StringTokenizer(value = property.getPropertyValue(), "=")).hasMoreTokens()) {
                String prefix = st.nextToken();
                if (st.hasMoreTokens()) {
                    String namespace = st.nextToken();
                    try {
                        xpath.setXPathNamespaceContext(prefix, namespace);
                    }
                    catch (XMLSecurityException e) {
                        log.error("", (Throwable)e);
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                }
            }
            ++i;
        }
    }

    public String processBodyId() {
        return this.getSecurityContext().getWsuIdFor(0);
    }

    private ReferenceConf createDefaultReferenceTo(String bodyId) {
        Configurable config = Configurator.newRuntimeConfigurable();
        ReferenceConf referenceConf = (ReferenceConf)config.narrow(class$org$systinet$wasp$security$ws$conf$ReferenceConf == null ? (class$org$systinet$wasp$security$ws$conf$ReferenceConf = SignatureSecurityObject.class$("org.systinet.wasp.security.ws.conf.ReferenceConf")) : class$org$systinet$wasp$security$ws$conf$ReferenceConf);
        referenceConf.setRefUri("#" + bodyId);
        referenceConf.setDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        TransformConf transformConf = referenceConf.newTransform();
        transformConf.setAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        referenceConf.setTransforms(new TransformConf[]{transformConf});
        return referenceConf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

