/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.idoox.wasp.Constants;
import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.InvalidCanonicalizerException;
import com.systinet.wasp.security.secext.exceptions.Base64DecodingException;
import com.systinet.wasp.security.secext.signature.XMLSignatureInput;
import com.systinet.wasp.security.secext.transforms.InvalidTransformException;
import com.systinet.wasp.security.secext.transforms.Transform;
import com.systinet.wasp.security.secext.transforms.TransformSpi;
import com.systinet.wasp.security.secext.transforms.TransformationException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.ElementProxy;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.InternalWSSecurityContext;
import com.systinet.wasp.security.ws.impl.SecurityTokenObject;
import com.systinet.wasp.security.ws.impl.WSSecurityHelper;
import com.systinet.wasp.security.ws.impl.WSSecurityImpl;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.systinet.wasp.security.ws.SecurityContext;
import org.systinet.wasp.security.ws.SecurityTokenSPI;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformSTR
extends TransformSpi {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.impl.TransformSTR");
    private Element strElement = null;
    private Node resultNode = null;
    public static final String RC_STR_TRANSFORM_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";

    public boolean wantsOctetStream() {
        return false;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return false;
    }

    public boolean returnsNodeSet() {
        return true;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, ParserConfigurationException, SAXException {
        Element resultNode;
        SecurityContext securityContext = (SecurityContext)Current.getCallContext().getContextData().get(WSSecurityImpl.WSSECURITY_CONTEXT_KEY);
        String wsseNamespace = null;
        String wsuNamespace = null;
        if (securityContext != null) {
            wsseNamespace = securityContext.getWsseNamespace();
            wsuNamespace = securityContext.getWsuNamespace();
        } else {
            wsseNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
            wsuNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        }
        Set inputSet = input.getNodeSet();
        if (inputSet.size() == 0) {
            throw new TransformationException("input node set contains no nodes");
        }
        Node referenceElement = null;
        Node keyIdentifierElement = null;
        Iterator iterator = inputSet.iterator();
        Element strElement = null;
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String namespaceURI = element.getNamespaceURI();
            String localName = element.getLocalName();
            if (wsseNamespace.equals(namespaceURI) && "Reference".equals(localName)) {
                referenceElement = element;
                break;
            }
            if (!wsseNamespace.equals(namespaceURI) || !"KeyIdentifier".equals(localName)) continue;
            keyIdentifierElement = element;
            break;
        }
        Element element = keyIdentifierElement != null ? (Element)keyIdentifierElement.getParentNode() : (strElement = referenceElement != null ? (Element)referenceElement.getParentNode() : null);
        if (!wsseNamespace.equals(strElement.getNamespaceURI()) || !"SecurityTokenReference".equals(strElement.getLocalName())) {
            strElement = null;
        }
        if (strElement == null) {
            log.error("The URI in the reference doesn't reference SecurityTokenReference");
            throw WSSecurityException.INVALID_SECURITY;
        }
        SecurityTokenSPI resultSecurityTokenSPI = null;
        if (referenceElement != null) {
            SecurityTokenObject tokenObject;
            String uri = referenceElement.getAttributeNS(null, "URI");
            String id = null;
            if (uri != null && uri.startsWith("#")) {
                id = uri.substring(1);
            }
            if (id == null) {
                throw new TransformationException("The uri must be a fragment : " + uri);
            }
            SecurityTokenSPI[] securityTokenSPIs = ((InternalWSSecurityContext)securityContext).getSecurityTokens();
            int i = 0;
            while (i < securityTokenSPIs.length) {
                SecurityTokenSPI securityTokenSPI = securityTokenSPIs[i];
                if (id.equals(securityTokenSPI.getWsuId())) {
                    resultSecurityTokenSPI = securityTokenSPI;
                    break;
                }
                ++i;
            }
            if (resultSecurityTokenSPI == null && (tokenObject = this.searchSecurityHeader(securityContext, id, null)) != null) {
                resultSecurityTokenSPI = tokenObject.getSecurityToken();
            }
            if (resultSecurityTokenSPI == null) {
                log.error("SecurityToken not found : Id = " + id);
                throw WSSecurityException.INVALID_SECURITY;
            }
        } else if (keyIdentifierElement != null) {
            SecurityTokenObject securityTokenObject;
            byte[] receivedKeyIdentifier = null;
            String wssePrefix = ElementProxy.getDefaultPrefix(wsseNamespace);
            String encodingType = null;
            encodingType = !WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace) ? wssePrefix + ":" + "Base64Binary" : WSSecurityHelper.fromNs2SpecLocation(wsseNamespace) + "#" + "Base64Binary";
            String encoding = keyIdentifierElement.getAttributeNS(null, "EncodingType");
            if (encoding != null && !encoding.equals("") && !encoding.equals(encodingType)) {
                log.error("KeyIdentifier supports Base64Encoding only");
                throw WSSecurityException.INVALID_SECURITY;
            }
            try {
                receivedKeyIdentifier = Base64.decode((Element)keyIdentifierElement);
                if (receivedKeyIdentifier == null) {
                    log.error("cannot get keyIdentifier value for keyInfo");
                    throw WSSecurityException.SECURITY_TOKEN_UNAVAILABLE;
                }
            }
            catch (Base64DecodingException e) {
                log.error("", (Throwable)e);
                throw WSSecurityException.INVALID_SECURITY;
            }
            SecurityTokenSPI[] tokenSPIs = ((InternalWSSecurityContext)securityContext).getSecurityTokens();
            int i = 0;
            while (i < tokenSPIs.length) {
                SecurityTokenSPI tokenSPI = tokenSPIs[i];
                if (Arrays.equals(receivedKeyIdentifier, tokenSPI.getKeyIdentifier())) {
                    resultSecurityTokenSPI = tokenSPI;
                    break;
                }
                ++i;
            }
            if (resultSecurityTokenSPI == null && (securityTokenObject = this.searchSecurityHeader(securityContext, null, receivedKeyIdentifier)) != null) {
                resultSecurityTokenSPI = securityTokenObject.getSecurityToken();
            }
            if (resultSecurityTokenSPI == null) {
                throw new TransformationException("empty", new Object[]{"Security token for STR transform was not resolved"});
            }
        } else {
            log.error("The content of SecurityTokenReference is neither Reference or KeyIdentifier");
            throw WSSecurityException.INVALID_SECURITY;
        }
        if ((resultNode = resultSecurityTokenSPI.getElement()).getParentNode() == null) {
            strElement.appendChild(resultNode);
            this.strElement = strElement;
            this.resultNode = resultNode;
        }
        try {
            try {
                Element parameter;
                NamedNodeMap namedNodeMap = resultNode.getAttributes();
                Node[] nodes = new Node[namedNodeMap.getLength()];
                if (resultSecurityTokenSPI.isExternal()) {
                    int j = 0;
                    while (j < namedNodeMap.getLength()) {
                        nodes[j] = namedNodeMap.item(j);
                        ++j;
                    }
                    int j2 = 0;
                    while (j2 < nodes.length) {
                        Node node = nodes[j2];
                        String localName = node.getLocalName();
                        if (node.getNodeType() == 2 && !"ValueType".equals(localName) && !localName.startsWith("xmlns")) {
                            resultNode.removeAttributeNode((Attr)node);
                        }
                        ++j2;
                    }
                }
                String canonicalizationAlgorithm = null;
                if (!WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace)) {
                    parameter = this._transformObject.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
                    if (parameter != null) {
                        canonicalizationAlgorithm = parameter.getAttribute("Algorithm");
                    }
                } else {
                    Node[] subParameters;
                    parameter = this._transformObject.getChildElementLocalName(0, wsseNamespace, "TransformationParameters");
                    if (parameter != null && (subParameters = WSSecurityHelper.getElementNS(WSSecurityImpl.getDsNamespace(), "CanonicalizationMethod", parameter)) != null && subParameters.length == 1) {
                        canonicalizationAlgorithm = ((Element)subParameters[0]).getAttribute("Algorithm");
                    }
                }
                XMLSignatureInput retVal = this.performTransform(canonicalizationAlgorithm, resultNode);
                retVal = this.addDefaultNamespace(retVal);
                if (resultSecurityTokenSPI.isExternal()) {
                    int j = 0;
                    while (j < nodes.length) {
                        Node node = nodes[j];
                        String localName = node.getLocalName();
                        if (node.getNodeType() == 2 && !"ValueType".equals(((Attr)node).getName()) && !localName.startsWith("xmlns")) {
                            resultNode.setAttributeNode((Attr)node);
                        }
                        ++j;
                    }
                }
                XMLSignatureInput xMLSignatureInput = retVal;
                Object var20_29 = null;
                return xMLSignatureInput;
            }
            catch (Exception e) {
                throw new TransformationException("", e);
            }
        }
        catch (Throwable throwable) {
            Object var20_30 = null;
            throw throwable;
        }
    }

    private XMLSignatureInput addDefaultNamespace(XMLSignatureInput retVal) throws IOException, CanonicalizationException, InvalidCanonicalizerException {
        String canonicalizedStr = new String(retVal.getBytes(), Constants.UTF_8);
        int index = canonicalizedStr.indexOf("xmlns=\"");
        if (index == -1) {
            int spaceIndex = canonicalizedStr.indexOf(32);
            canonicalizedStr = canonicalizedStr.substring(0, spaceIndex) + " xmlns=\"\"" + canonicalizedStr.substring(spaceIndex, canonicalizedStr.length());
            retVal = new XMLSignatureInput(canonicalizedStr.getBytes());
        }
        return retVal;
    }

    protected XMLSignatureInput performTransform(String canonicalizationAlgorithm, Element resultNode) throws InvalidTransformException, IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException, TransformerException {
        if (canonicalizationAlgorithm != null) {
            Transform transform = new Transform(resultNode.getOwnerDocument(), canonicalizationAlgorithm, null);
            XMLSignatureInput retVal = transform.performTransform(new XMLSignatureInput(resultNode));
            return retVal;
        }
        return new XMLSignatureInput(resultNode);
    }

    private SecurityTokenObject searchSecurityHeader(SecurityContext securityContext, String id, byte[] receivedKeyIdentifier) {
        Element securityElement = ((InternalWSSecurityContext)securityContext).getSecurityElement();
        NodeList nodeList = securityElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeType() == 1) {
                Element element = (Element)nodeList.item(i);
                String localName = element.getLocalName();
                if (securityContext.getWsseNamespace().equals(element.getNamespaceURI()) && ("BinarySecurityToken".equals(localName) || "UsernameToken".equals(localName))) {
                    SecurityTokenObject tokenObject = null;
                    tokenObject = new SecurityTokenObject(securityContext, element);
                    SecurityTokenSPI tokenSPI = tokenObject.getSecurityToken();
                    if (id != null && id.equals(tokenSPI.getWsuId())) {
                        return tokenObject;
                    }
                    if (receivedKeyIdentifier != null && Arrays.equals(receivedKeyIdentifier, tokenSPI.getKeyIdentifier())) {
                        return tokenObject;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    protected String engineGetURI() {
        SecurityContext securityContext = (SecurityContext)Current.getCallContext().getContextData().get(WSSecurityImpl.WSSECURITY_CONTEXT_KEY);
        String wsseNamespace = null;
        if (securityContext != null) {
            wsseNamespace = securityContext.getWsseNamespace();
        }
        if (!WSSecurity.RC_SECURITY_URI_LIST.contains(wsseNamespace)) {
            return "http://schemas.xmlsoap.org/2003/06/STR-Transform";
        }
        return RC_STR_TRANSFORM_URI;
    }

    public void clean() {
        if (this.strElement != null) {
            this.strElement.removeChild(this.resultNode);
        }
    }
}

