/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.ws.impl;

import com.idoox.debug.Category;
import com.idoox.wasp.security.SecurityProvidersConfigs;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethod;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.ws.iface.WSSecurity;
import com.systinet.wasp.security.ws.impl.InternalWSSecurityContext;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.Credentials;
import org.idoox.security.jaas.NamePasswordCredential;
import org.idoox.security.jaas.PrivateKeyCertsCredential;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.KeyStore;
import org.idoox.security.pstore.KeyStoreException;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.xsdbuiltin.DateTime;
import org.idoox.wasp.serialization.xsdbuiltin.DateTimeException;
import org.systinet.wasp.security.ws.IncomingValidator;
import org.systinet.wasp.security.ws.WSSecurityException;
import org.systinet.wasp.security.ws.conf.ExternalSecurityTokensConf;
import org.systinet.wasp.security.ws.conf.MessageConf;
import org.systinet.wasp.security.ws.conf.PropertyConf;
import org.systinet.wasp.security.ws.conf.SecuredMessage;
import org.systinet.wasp.security.ws.conf.SecurityTokenConf;
import org.systinet.wasp.security.ws.conf.WSSEConf;
import org.systinet.wasp.security.ws.conf.WSSEGlobalConf;
import org.systinet.wasp.security.ws.conf.WSSEProviderConf;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecurityHelper {
    private static final Category log = Category.getCategory((String)"com.systinet.wasp.security.ws.impl.WSSecurityHelper");
    private static SecureRandom secureRandom = new SecureRandom();
    private static WSSEGlobalConf wsSecurityConf = null;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$ExternalSecurityTokensConf;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$WSSEGlobalConf;
    static /* synthetic */ Class class$com$idoox$wasp$security$SecurityProvidersConfigs;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$WSSEProviderConf;
    static /* synthetic */ Class class$org$systinet$wasp$security$ws$conf$WSSEConf;

    public static String getPropertyValue(PropertyConf[] propertyConfs, String propertyName) {
        if (propertyConfs == null) {
            return null;
        }
        int i = 0;
        while (i < propertyConfs.length) {
            PropertyConf propertyConf = propertyConfs[i];
            if (propertyConf != null && propertyConf.getPropertyName() != null && propertyConf.getPropertyName().equals(propertyName)) {
                return propertyConf.getPropertyValue();
            }
            ++i;
        }
        return null;
    }

    public static void addNamespacePrefix(String namespaceURI, String namespacePrefix, Element element) {
        String definedNamespace = WSSecurityHelper.resolvePrefixNamespaceURI(namespacePrefix + ":dummy", element);
        if (definedNamespace == null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns" + (namespacePrefix == null ? "" : ":" + namespacePrefix), namespaceURI);
            return;
        }
        if (definedNamespace.equals(namespaceURI)) {
            return;
        }
        log.error("Namespace prefix clash - " + namespacePrefix + " prefix already defined with namespace " + definedNamespace + ", but namespace " + namespaceURI + " was required");
        throw WSSecurityException.INVALID_SECURITY;
    }

    public static String getAttributeNS(String namespaceURI, String attributName, Element element) {
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getLocalName().equals(attributName)) {
                if (attr.getNamespaceURI() != null && attr.getNamespaceURI().equals(namespaceURI)) {
                    return attr.getValue();
                }
                String nsURI = WSSecurityHelper.resolveNamespaceURI(attr.getPrefix(), element);
                if (nsURI == null && namespaceURI == null) {
                    return attr.getValue();
                }
                if (nsURI != null && nsURI.equals(namespaceURI)) {
                    return attr.getValue();
                }
            }
            ++i;
        }
        return null;
    }

    public static String getAttributeNS(String[] namespaceURIs, String attributName, Element element) {
        if (namespaceURIs == null || namespaceURIs.length == 0) {
            return WSSecurityHelper.getAttributeNS((String)null, attributName, element);
        }
        int i = 0;
        while (i < namespaceURIs.length) {
            String val = WSSecurityHelper.getAttributeNS(namespaceURIs[i], attributName, element);
            if (val != null) {
                return val;
            }
            ++i;
        }
        return null;
    }

    public static Node getSingleElementNS(String namespaceURI, String localName, Element parent) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (localName.equals(child.getLocalName())) {
                if (child.getNamespaceURI() != null && child.getNamespaceURI().equals(namespaceURI)) {
                    return child;
                }
                String foundURI = WSSecurityHelper.resolveNamespaceURI(child.getPrefix(), child);
                if (foundURI == null && namespaceURI == null) {
                    return child;
                }
                if (foundURI != null && foundURI.equals(namespaceURI)) {
                    return child;
                }
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Node[] getElementNS(String namespaceURI, String localName, Element parent) {
        ArrayList<Node> list = new ArrayList<Node>();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (localName.equals(child.getLocalName())) {
                if (child.getNamespaceURI() != null && child.getNamespaceURI().equals(namespaceURI)) {
                    list.add(child);
                } else {
                    String foundURI = WSSecurityHelper.resolveNamespaceURI(child.getPrefix(), child);
                    if (foundURI == null && namespaceURI == null) {
                        list.add(child);
                    } else if (foundURI != null && foundURI.equals(namespaceURI)) {
                        list.add(child);
                    }
                }
            }
            child = child.getNextSibling();
        }
        return list.toArray(new Node[0]);
    }

    public static Node getSingleElementNS(String[] namespaceURIs, String localName, Element parent) {
        if (namespaceURIs == null || namespaceURIs.length == 0) {
            return WSSecurityHelper.getSingleElementNS((String)null, localName, parent);
        }
        int i = 0;
        while (i < namespaceURIs.length) {
            Node node = WSSecurityHelper.getSingleElementNS(namespaceURIs[i], localName, parent);
            if (node != null) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public static Node[] getElementNS(String[] namespaceURIs, String localName, Element parent) {
        if (namespaceURIs == null || namespaceURIs.length == 0) {
            return WSSecurityHelper.getElementNS((String)null, localName, parent);
        }
        ArrayList<Node> list = new ArrayList<Node>();
        int i = 0;
        while (i < namespaceURIs.length) {
            Node[] node = WSSecurityHelper.getElementNS(namespaceURIs[i], localName, parent);
            list.addAll(Arrays.asList(node));
            ++i;
        }
        return list.toArray(new Node[0]);
    }

    public static String resolveNamespaceURI(String namespacePrefix, Node node) {
        if (node == null || namespacePrefix == null) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        int i = 0;
        while (attrs != null && i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if ("".equals(attr.getPrefix()) && "xmlns".equals(attr.getLocalName()) && namespacePrefix == null) {
                return attr.getValue();
            }
            if ("xmlns".equals(attr.getPrefix()) && namespacePrefix != null && namespacePrefix.equals(attr.getLocalName())) {
                return attr.getValue();
            }
            ++i;
        }
        return WSSecurityHelper.resolveNamespaceURI(namespacePrefix, node.getParentNode());
    }

    public static String resolvePrefixNamespaceURI(String qname, Node node) {
        int i = qname.indexOf(58);
        if (i == -1) {
            return WSSecurityHelper.resolveNamespaceURI("", node);
        }
        return WSSecurityHelper.resolveNamespaceURI(qname.substring(0, i), node);
    }

    public static Element getElementByName(NodeList childs, String nodeName, List namespaces) {
        if (childs == null) {
            return null;
        }
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            String localName = child.getLocalName();
            String namespaceURI = child.getNamespaceURI();
            if (child.getNodeType() == 1 && localName != null && localName.equals(nodeName) && namespaceURI != null && namespaces.contains(namespaceURI)) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    protected static Map getRuntimeProcessingContext() {
        if (Current.getProcessingType() == 1) {
            return Current.getServiceClientContext().getContextData();
        }
        if (Current.getProcessingType() == 2) {
            return Current.getServiceEndpointContext().getContextData();
        }
        return null;
    }

    protected static MessageConf getRuntimeMessageConf() {
        Map callContextData = Current.getCallContext().getContextData();
        Object o = callContextData.get("securityMessageConfiguration");
        if (o == null) {
            Map contextData = WSSecurityHelper.getRuntimeProcessingContext();
            o = contextData.get("securityMessageConfiguration");
        }
        if (o != null && !(o instanceof MessageConf)) {
            log.error("message configuration set in context data is not type of MessageConf");
            throw WSSecurityException.FAILED_CHECK;
        }
        return (MessageConf)o;
    }

    protected static WSSEProviderConf getPersistentConf() {
        WSSEProviderConf localConf = WSSecurityHelper.getLocalPersistentConfiguration();
        if (localConf != null) {
            return localConf;
        }
        WSSEGlobalConf globalConf = WSSecurityHelper.getGlobalConfiguration();
        return globalConf;
    }

    public static MessageConf getSenderConf() throws WSSecurityException {
        QName jaxrpcMtd;
        MessageConf runtimeConf = WSSecurityHelper.getRuntimeMessageConf();
        if (runtimeConf != null) {
            return runtimeConf;
        }
        WSSEProviderConf wsProvConf = WSSecurityHelper.getPersistentConf();
        if (wsProvConf == null) {
            return null;
        }
        CallContext callCtx = Current.getCallContext();
        String mtdSignature = null;
        String mtdName = null;
        Method calledMtd = (Method)callCtx.getContextData().get("java.signature");
        if (calledMtd != null) {
            mtdSignature = WSSecurityHelper.getMethodSignature(calledMtd);
            mtdName = calledMtd.getName();
        }
        if (mtdName == null && (jaxrpcMtd = (QName)callCtx.getContextData().get("java.methodName")) != null) {
            mtdName = jaxrpcMtd.getLocalPart();
        }
        SecuredMessage[] msgs = wsProvConf.getSecuredMessages();
        MessageConf mconf = null;
        MessageConf defaultconf = null;
        int i = 0;
        while (i < msgs.length) {
            Object[] names = msgs[i].getMethodNames();
            if (names.length == 0 || names.length == 0 && mtdSignature == null && mtdName == null) {
                if (defaultconf != null) {
                    log.error("Multiple definition of default ws-security configuration for operation \"" + mtdSignature + "\"");
                    throw WSSecurityException.INVALID_SECURITY;
                }
                defaultconf = msgs[i].getMessageConf();
            } else {
                Arrays.sort(names);
                if (mtdSignature != null && Arrays.binarySearch(names, mtdSignature) >= 0 || mtdName != null && Arrays.binarySearch(names, mtdName) >= 0) {
                    if (mconf != null) {
                        log.error("Multiple definition of ws-security configuration for operation \"" + mtdSignature + "\"");
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    mconf = msgs[i].getMessageConf();
                }
            }
            ++i;
        }
        if (mconf != null) {
            return mconf;
        }
        if (defaultconf != null) {
            return defaultconf;
        }
        return null;
    }

    public static ExternalSecurityTokensConf getExternalSecurityTokensConf() {
        LinkedList<WSSEConf> list = new LinkedList<WSSEConf>();
        list.addLast(WSSecurityHelper.getWSSEConfCallCtx());
        list.addLast(WSSecurityHelper.getWSSEConfSrvCltCtx());
        list.addLast(WSSecurityHelper.getLocalPersistentConfiguration());
        list.addLast(WSSecurityHelper.getGlobalConfiguration());
        while (list.remove(null)) {
        }
        ArrayList<SecurityTokenConf> externalTokens = new ArrayList<SecurityTokenConf>();
        int i = 0;
        while (i < list.size()) {
            SecurityTokenConf[] tokens;
            ExternalSecurityTokensConf sectoks = ((WSSEConf)list.get(i)).getExternalSecurityTokens();
            if (sectoks != null && (tokens = sectoks.getSecurityTokens()) != null) {
                int j = 0;
                while (j < tokens.length) {
                    boolean contains = false;
                    Iterator it = ((AbstractList)externalTokens).iterator();
                    while (it.hasNext()) {
                        SecurityTokenConf secToken = (SecurityTokenConf)it.next();
                        if (contains |= secToken == tokens[j]) break;
                        String wsuId = secToken.getWsuId();
                        if (wsuId == null || !wsuId.equals(tokens[j].getWsuId())) continue;
                        log.error("There is duplicit external security token wsu:Id=" + wsuId);
                        throw WSSecurityException.INVALID_SECURITY;
                    }
                    if (!contains) {
                        externalTokens.add(tokens[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        ExternalSecurityTokensConf external = (ExternalSecurityTokensConf)Configurator.newRuntimeConfigurable().narrow(class$org$systinet$wasp$security$ws$conf$ExternalSecurityTokensConf == null ? (class$org$systinet$wasp$security$ws$conf$ExternalSecurityTokensConf = WSSecurityHelper.class$("org.systinet.wasp.security.ws.conf.ExternalSecurityTokensConf")) : class$org$systinet$wasp$security$ws$conf$ExternalSecurityTokensConf);
        external.setSecurityTokens(externalTokens.toArray(new SecurityTokenConf[0]));
        return external;
    }

    public static IncomingValidator getValidatorInstance() {
        Map callContextData = Current.getCallContext().getContextData();
        Object o = callContextData.get("wssecurity_validator_instance_name");
        if (o == null) {
            Map contextData = WSSecurityHelper.getRuntimeProcessingContext();
            if (contextData == null) {
                return null;
            }
            o = contextData.get("wssecurity_validator_instance_name");
        }
        if (o != null && !(o instanceof IncomingValidator)) {
            log.error("Incoming Validator instance is set in runtime, but instance is not IncomingValidator");
            throw WSSecurityException.FAILED_CHECK;
        }
        return (IncomingValidator)o;
    }

    public static Class getValidatorClassConf() throws WSSecurityException {
        WSSEConf securityConf = WSSecurityHelper.getSecurityConfiguration();
        String validatorClassName = securityConf.getValidatorClassName();
        if ("".equals(validatorClassName)) {
            return null;
        }
        if (validatorClassName == null) {
            return null;
        }
        Class clazz = WSSecurityHelper.findClass(validatorClassName);
        return clazz;
    }

    public static Class findClass(String className) {
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.error("Cannot load validator class " + className, (Throwable)e);
                clazz = null;
            }
        }
        return clazz;
    }

    protected static String getMethodSignature(Method m) {
        String sig = m.getName() + "(";
        Class<?>[] params = m.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            sig = sig + WSSecurityHelper.type2String(params[i]);
            ++i;
        }
        return sig + ")" + WSSecurityHelper.type2String(m.getReturnType());
    }

    protected static String type2String(Class type) {
        if (type.equals(Byte.TYPE)) {
            return "B";
        }
        if (type.equals(Character.TYPE)) {
            return "C";
        }
        if (type.equals(Double.TYPE)) {
            return "D";
        }
        if (type.equals(Float.TYPE)) {
            return "F";
        }
        if (type.equals(Integer.TYPE)) {
            return "I";
        }
        if (type.equals(Long.TYPE)) {
            return "J";
        }
        if (type.equals(Short.TYPE)) {
            return "S";
        }
        if (type.equals(Boolean.TYPE)) {
            return "Z";
        }
        if (type.isArray()) {
            return "[" + WSSecurityHelper.type2String(type.getComponentType());
        }
        return "L" + type.getName() + ";";
    }

    public static byte[] getRandomBytes(int length) {
        byte[] rnd = new byte[length];
        secureRandom.nextBytes(rnd);
        return rnd;
    }

    public static int getKeyLength(String algorithm) {
        if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(algorithm)) {
            return 16;
        }
        if ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(algorithm)) {
            return 24;
        }
        if ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(algorithm)) {
            return 32;
        }
        if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(algorithm)) {
            return 24;
        }
        return -1;
    }

    public static Key createKeyFromBytes(byte[] keyBytes, EncryptionMethod encryptionMethod) throws WSSecurityException {
        try {
            if (encryptionMethod == null) {
                throw new WSSecurityException(null, "encryptionMethod is null");
            }
            String algorithmURI = encryptionMethod.getAlgorithmURI();
            if ("http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(algorithmURI)) {
                return encryptionMethod.createSecretKeyFromBytes(keyBytes);
            }
            if ("http://www.w3.org/2001/04/xmlenc#aes192-cbc".equals(algorithmURI)) {
                return encryptionMethod.createSecretKeyFromBytes(keyBytes);
            }
            if ("http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(algorithmURI)) {
                return encryptionMethod.createSecretKeyFromBytes(keyBytes);
            }
            if ("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(algorithmURI)) {
                return encryptionMethod.createSecretKeyFromBytes(keyBytes);
            }
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(e);
        }
        throw new WSSecurityException(null, "Cannot create key from keyBytes for " + encryptionMethod.getAlgorithmURI());
    }

    public static NamePasswordCredential createNamePasswordCredential(String username, String password) {
        return new NamePasswordCredential(username, password);
    }

    public static PrivateKeyCertsCredential createPrivateKeyCertsCredentials(String username, String password, InternalWSSecurityContext securityContext) {
        try {
            if (username == null) {
                log.error("Asked to create PrivateKeyCertCredentail for null username");
                throw WSSecurityException.INVALID_SECURITY;
            }
            KeyStore keyStore = securityContext.getPStore().getKeyStore();
            Certificate[] certs = keyStore.getCertificateChain(username);
            Vector<Certificate> x509Certs = new Vector<Certificate>();
            int j = 0;
            while (j < certs.length) {
                if (certs[j] instanceof X509Certificate) {
                    x509Certs.add(certs[j]);
                }
                ++j;
            }
            if (x509Certs.size() == 0) {
                log.error("User (alias) \"" + username + "\" has not certificate in KeyStore");
                throw WSSecurityException.INVALID_SECURITY;
            }
            Key privateKey = null;
            if (password != null && !((privateKey = keyStore.getKey(username, password)) instanceof PrivateKey)) {
                log.error("User (alias) \"" + username + "\"'s key is not PrivateKey");
                throw WSSecurityException.INVALID_SECURITY;
            }
            return new PrivateKeyCertsCredential((PrivateKey)privateKey, x509Certs.toArray(new X509Certificate[0]));
        }
        catch (BadPasswordException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException("wsse:InvalidSecurity");
        }
        catch (KeyStoreException e) {
            log.error("", (Throwable)e);
            throw new RuntimeException("wsse:InvalidSecurity");
        }
    }

    public static Object[] getCurrentCredentials(Class clazz) {
        org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
        Map map = null;
        map = Current.getServiceClientContext() != null ? Current.getServiceClientContext().getContextData() : Current.getServiceEndpointContext().getContextData();
        Credentials[] creds = (Credentials[])map.get("Stub.credentials");
        if (creds == null || creds.length == 0) {
            creds = current.getCredentials();
        }
        if (creds == null || creds.length == 0) {
            log.error("No Credentials found.");
            throw new WSSecurityException("wsse:InvalidSecurity", "No Credentials found.");
        }
        HashSet<Object> allCreds = new HashSet<Object>();
        int i = 0;
        while (i < creds.length) {
            if (creds[i] != null && creds[i].getProviderName().equals("WS-Security")) {
                Set<Object> credSet;
                Subject sub = creds[i].getSubject();
                Set<Object> set = credSet = clazz != null ? sub.getPrivateCredentials(clazz) : sub.getPrivateCredentials();
                if (credSet != null && credSet.size() != 0) {
                    allCreds.addAll(credSet);
                }
            }
            ++i;
        }
        if (clazz == null) {
            return allCreds.toArray();
        }
        return allCreds.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static String getTextNodeValue(Element parent) {
        if (parent == null) {
            return null;
        }
        NodeList childs = parent.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node node = childs.item(i);
            if (node.getNodeType() == 3) {
                return node.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public static synchronized WSSEGlobalConf getGlobalConfiguration() {
        if (wsSecurityConf == null) {
            Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
            Configurable configurable = Configurator.getConfigurable((String)"securityProviderPreferences", (String)"WS-Security");
            if (configurable != null) {
                wsSecurityConf = (WSSEGlobalConf)configurable.narrow(class$org$systinet$wasp$security$ws$conf$WSSEGlobalConf == null ? (class$org$systinet$wasp$security$ws$conf$WSSEGlobalConf = WSSecurityHelper.class$("org.systinet.wasp.security.ws.conf.WSSEGlobalConf")) : class$org$systinet$wasp$security$ws$conf$WSSEGlobalConf);
            }
        }
        return wsSecurityConf;
    }

    protected static synchronized WSSEProviderConf getLocalPersistentConfiguration() {
        Configurable cable = null;
        if (Current.getProcessingType() == 1) {
            cable = Current.getServiceClientContext().getServiceClient().getConfigurable();
        } else if (Current.getProcessingType() == 2) {
            cable = Current.getServiceEndpointContext().getServiceEndpoint().getConfigurable();
        } else {
            return null;
        }
        SecurityProvidersConfigs provCfg = (SecurityProvidersConfigs)cable.narrow(class$com$idoox$wasp$security$SecurityProvidersConfigs == null ? (class$com$idoox$wasp$security$SecurityProvidersConfigs = WSSecurityHelper.class$("com.idoox.wasp.security.SecurityProvidersConfigs")) : class$com$idoox$wasp$security$SecurityProvidersConfigs);
        SecurityProvidersConfigs.ProviderConfigBase[] provBase = provCfg.getSecurityProviderPreferences();
        Configurable foundCable = null;
        int i = 0;
        while (provBase != null && i < provBase.length) {
            if ("WS-Security".equals(provBase[i].getLocalName())) {
                foundCable = Configurator.getConfigurable((Object)provBase[i]);
                break;
            }
            ++i;
        }
        if (foundCable == null) {
            return null;
        }
        return (WSSEProviderConf)foundCable.narrow(class$org$systinet$wasp$security$ws$conf$WSSEProviderConf == null ? (class$org$systinet$wasp$security$ws$conf$WSSEProviderConf = WSSecurityHelper.class$("org.systinet.wasp.security.ws.conf.WSSEProviderConf")) : class$org$systinet$wasp$security$ws$conf$WSSEProviderConf);
    }

    public static String getWsuIdFromElement(Element element) {
        if (element != null) {
            return WSSecurityHelper.getAttributeNS(WSSecurity.KNOWN_WSU_URI, "Id", element);
        }
        return null;
    }

    protected static WSSEConf getWSSEConfCallCtx() {
        Map callContextData = Current.getCallContext().getContextData();
        Object val = callContextData.get("securityConfiguration");
        if (val != null && !(val instanceof WSSEConf)) {
            log.warn("WS-Security's runtime call context configuration in CD_SECURITY_CONFIGURATION does not contain type of WSSEConf - this configuration is not used");
            return null;
        }
        return (WSSEConf)val;
    }

    protected static WSSEConf getWSSEConfSrvCltCtx() {
        Map contextData = WSSecurityHelper.getRuntimeProcessingContext();
        if (contextData == null) {
            log.warn("Unknown processing context! Cannot find runtime configuration of WS-Sec.");
            return null;
        }
        Object val = contextData.get("securityConfiguration");
        if (val != null && !(val instanceof WSSEConf)) {
            log.warn("WS-Security's runtime processing context configuration in CD_SECURITY_CONFIGURATION does not contain type of WSSEConf - this configuration is not used");
            return null;
        }
        return (WSSEConf)val;
    }

    public static WSSEConf getSecurityConfiguration() {
        LinkedList<Configurable> list = new LinkedList<Configurable>();
        list.addLast(Configurator.getConfigurable((Object)WSSecurityHelper.getGlobalConfiguration()));
        list.addLast(Configurator.getConfigurable((Object)WSSecurityHelper.getLocalPersistentConfiguration()));
        list.addLast(Configurator.getConfigurable((Object)WSSecurityHelper.getWSSEConfSrvCltCtx()));
        list.addLast(Configurator.getConfigurable((Object)WSSecurityHelper.getWSSEConfCallCtx()));
        list.addLast(Configurator.newRuntimeConfigurable());
        while (list.remove(null)) {
        }
        if (list.size() <= 1) {
            log.error("There is not configuration of WS-Security");
            throw WSSecurityException.INVALID_SECURITY;
        }
        Configurable def = (Configurable)list.removeFirst();
        while (list.size() > 0) {
            Configurable dummy = (Configurable)list.removeFirst();
            def = Configurator.setDefaultsOnConfigurable((Configurable)dummy, (Configurable)def);
        }
        return (WSSEConf)def.narrow(class$org$systinet$wasp$security$ws$conf$WSSEConf == null ? (class$org$systinet$wasp$security$ws$conf$WSSEConf = WSSecurityHelper.class$("org.systinet.wasp.security.ws.conf.WSSEConf")) : class$org$systinet$wasp$security$ws$conf$WSSEConf);
    }

    public static Date parseDate(String createdStr) throws ParseException {
        DateTime dateTime = null;
        try {
            dateTime = new DateTime(createdStr);
        }
        catch (DateTimeException e) {
            log.error("Unable to parse date : " + createdStr, (Throwable)e);
            throw new ParseException("Unable to parse date : " + createdStr, 0);
        }
        return dateTime.toJavaUtilDate();
    }

    public static String getFragment(String valueType) {
        int index = valueType.indexOf(35);
        if (index == -1) {
            return "";
        }
        return valueType.substring(index + 1);
    }

    public static String fromNs2SpecLocation(String wsseNamespace) {
        int index = wsseNamespace.indexOf("wss-wssecurity-secext-1.0.xsd");
        if (index == -1) {
            log.error("Unknown specification location for namespace : " + wsseNamespace);
            throw WSSecurityException.INVALID_SECURITY;
        }
        return wsseNamespace.substring(0, index) + "wss-soap-message-security-1.0";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

