/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin.security;

import com.idoox.debug.Category;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.idoox.security.ContextExpiredException;
import org.systinet.security.policy.PrincipalEntries;
import org.systinet.security.policy.UpdateablePolicy;
import org.systinet.wasp.admin.PolicyManagement;

public class PolicyManagementProxy
extends UpdateablePolicy {
    private static final Category cat = Category.getCategory((String)"com.systinet.wasp.admin.security.PolicyManagementProxy");
    private PolicyManagement policy;

    public PolicyManagementProxy(PolicyManagement soapProxy) {
        super(new HashMap());
        this.policy = soapProxy;
    }

    public boolean isUpdatable() {
        boolean result;
        try {
            result = this.policy.isUpdatable();
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.isUpdatable();
        }
        return result;
    }

    public void addPermissions(CodeSource cs, Principal principal, PermissionCollection collection) throws AccessControlException {
        try {
            this.policy.addPermissions(cs, principal, collection);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            this.policy.addPermissions(cs, principal, collection);
        }
    }

    public boolean addPermission(CodeSource cs, Principal principal, Permission permission) throws AccessControlException {
        boolean result;
        try {
            result = this.policy.addPermission(cs, principal, permission);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.addPermission(cs, principal, permission);
        }
        return result;
    }

    public boolean removePermission(CodeSource cs, Principal principal, Permission permission) throws AccessControlException {
        boolean result;
        try {
            result = this.policy.removePermission(cs, principal, permission);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.removePermission(cs, principal, permission);
        }
        return result;
    }

    public PermissionCollection getPrincipalPermissions(CodeSource cs, Principal principal) throws AccessControlException {
        PermissionCollection result;
        try {
            result = this.policy.getPrincipalPermissions(cs, principal);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.getPrincipalPermissions(cs, principal);
        }
        return result;
    }

    public PermissionCollection getPrincipalPermissions(CodeSource cs, Principal principal, boolean roleInheritted) throws AccessControlException {
        PermissionCollection result;
        try {
            result = this.policy.getPrincipalPermissions(cs, principal, roleInheritted);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.getPrincipalPermissions(cs, principal, roleInheritted);
        }
        return result;
    }

    public PrincipalEntries getPrincipalEntries(Permission perm) throws AccessControlException {
        PrincipalEntries result;
        try {
            result = this.policy.getPrincipalEntries(perm);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.getPrincipalEntries(perm);
        }
        return result;
    }

    public PrincipalEntries getPrincipalEntries() throws AccessControlException {
        PrincipalEntries result;
        try {
            result = this.policy.getPrincipalEntries();
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.getPrincipalEntries();
        }
        return result;
    }

    public boolean isRoleManager() {
        boolean result;
        try {
            result = this.policy.isRoleManager();
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.isRoleManager();
        }
        return result;
    }

    public Iterator getRoleNames() {
        Iterator result;
        try {
            result = this.policy.getRoleNames();
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.getRoleNames();
        }
        return result;
    }

    public boolean addPermissionToRole(String roleName, Permission permission) {
        boolean result;
        try {
            result = this.policy.addPermissionToRole(roleName, permission);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.addPermissionToRole(roleName, permission);
        }
        return result;
    }

    public boolean removePermissionFromRole(String roleName, Permission permission) {
        boolean result;
        try {
            result = this.policy.removePermissionFromRole(roleName, permission);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.removePermissionFromRole(roleName, permission);
        }
        return result;
    }

    public PermissionCollection getRolePermissions(String roleName) {
        PermissionCollection result;
        try {
            result = this.policy.getRolePermissions(roleName);
        }
        catch (ContextExpiredException e) {
            cat.warn("ContextExpired", (Throwable)e);
            result = this.policy.getRolePermissions(roleName);
        }
        return result;
    }

    public void refresh() {
    }

    public PermissionCollection getPermissions(Subject subject, CodeSource codeSource) {
        throw new UnsupportedOperationException("This operation is not supported!");
    }
}

