/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.admin.security;

import com.idoox.debug.Category;
import com.idoox.security.pstore.PasswordPropertySerializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.idoox.security.pstore.AbstractUserStore;
import org.idoox.security.pstore.BadPasswordException;
import org.idoox.security.pstore.PStore;
import org.idoox.security.pstore.PropertySerializer;
import org.idoox.security.pstore.UserEntry;
import org.idoox.security.pstore.UserIterator;
import org.idoox.security.pstore.UserStore;
import org.idoox.security.pstore.UserStoreException;
import org.idoox.security.pstore.UserStoreSource;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.admin.security.PStoreService;
import org.systinet.wasp.admin.security.RawUserEntry;
import org.systinet.wasp.admin.security.UserProperty;

public class UserStoreProxy
extends AbstractUserStore {
    private static final Category cat = Category.getCategory((String)"org.systinet.wasp.admin.security.UserStoreProxy");
    PStoreService service;
    UserStore userStore;
    HashSet supported;

    private static HashMap arrayToMap(UserStore ustore, UserProperty[] array, HashSet unsupported) {
        if (array == null) {
            return new HashMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (i < array.length) {
            String name = array[i].getPropertyName();
            PropertySerializer ser = ustore.getPropertySerializer(name);
            if (ser == null && unsupported != null) {
                unsupported.add(name);
            } else {
                Object oValue = array[i] != null ? ser.decode(array[i].getPropertyValue()) : null;
                result.put(name, oValue);
            }
            ++i;
        }
        return result;
    }

    private static UserProperty[] mapToArray(UserStore ustore, Map map, HashSet supported) {
        if (map == null) {
            return new UserProperty[0];
        }
        Iterator iterator = map.entrySet().iterator();
        UserProperty[] result = new UserProperty[map.size()];
        int i = 0;
        while (i < result.length) {
            block7: {
                PropertySerializer ser;
                UserProperty prop;
                String propertyName;
                Map.Entry entry;
                block6: {
                    block5: {
                        entry = iterator.next();
                        propertyName = (String)entry.getKey();
                        prop = new UserProperty();
                        if (propertyName.equals("FILTER_STRING")) break block5;
                        ser = ustore.getPropertySerializer(propertyName);
                        if (ser == null) {
                            throw new RuntimeException("Internal: no serializer: " + propertyName);
                        }
                        if (supported == null || supported.contains(propertyName)) break block6;
                        cat.warn("Caller does not support property type: " + propertyName);
                        break block7;
                    }
                    ser = PasswordPropertySerializer.getInstance();
                }
                prop.setPropertyName(propertyName);
                Object value = entry.getValue();
                if (value != null) {
                    prop.setPropertyValue(ser.encode(value));
                } else {
                    prop.setPropertyValue(null);
                }
                result[i] = prop;
            }
            ++i;
        }
        return result;
    }

    public UserStoreProxy(PStoreService service) {
        this.service = service;
    }

    protected UserStore getUserStore() {
        try {
            if (this.userStore == null) {
                this.userStore = PStore.getInstance(null).getUserStore();
            }
            return this.userStore;
        }
        catch (BadPasswordException e) {
            cat.error("Unable to get user store instance:", (Throwable)e);
            throw new RuntimeWrappedException("Unable to get user store instance:", (Throwable)e);
        }
    }

    protected HashSet getSupported() {
        if (this.supported == null) {
            Iterator it = this.getUserStore().getSupportedAttributes();
            this.supported = new HashSet();
            while (it.hasNext()) {
                this.supported.add(it.next());
            }
        }
        return this.supported;
    }

    public void deleteUser(String userId) throws UserStoreException {
        this.service.deleteUser(userId);
        this.fireDeleteUserAction(userId);
    }

    public Map getUserProperties(String userId) throws UserStoreException {
        UserStore userStore = this.getUserStore();
        UserProperty[] props = this.service.getUserProperties(userId, this.getSupported());
        HashMap result = UserStoreProxy.arrayToMap(userStore, props, null);
        return result;
    }

    public Object getUserProperty(String userId, String key) throws UserStoreException {
        UserStore userStore = this.getUserStore();
        byte[] value = this.service.getUserProperty(userId, key, this.getSupported());
        PropertySerializer ser = userStore.getPropertySerializer(key);
        if (value != null) {
            return ser.decode(value);
        }
        return null;
    }

    public void removeUserProperty(String userId, String key) throws UserStoreException {
        this.service.removeUserProperty(userId, key);
    }

    public void setUserProperties(String userId, Map properties) throws UserStoreException {
        UserStore userStore = this.getUserStore();
        UserProperty[] result = UserStoreProxy.mapToArray(userStore, properties, null);
        HashSet unsupported = this.service.setUserProperties(userId, result);
        if (unsupported != null && unsupported.size() > 0) {
            cat.warn("Server does not support these property types: " + unsupported);
        }
    }

    public void setUserProperties(String userId, UserProperty[] properties) throws UserStoreException {
        HashSet unsupported = this.service.setUserProperties(userId, properties);
        if (unsupported != null && unsupported.size() > 0) {
            cat.warn("Server does not support these property types: " + unsupported);
        }
    }

    public void setUserProperty(String userId, String key, Object value) throws UserStoreException {
        byte[] data = value != null ? this.getUserStore().getPropertySerializer(key).encode(value) : null;
        boolean supported = this.service.setUserProperty(userId, key, data);
        if (!supported) {
            cat.warn("Server does not support property type: " + key);
        }
    }

    public UserIterator getUsers() {
        return new UserIteratorImpl(this.service.getUsers(this.getSupported()));
    }

    public String[] getUserIds() {
        return this.service.getUserIds();
    }

    public Iterator getSupportedAttributes() {
        HashSet set1 = this.service.getSupportedAttributes();
        HashSet set2 = new HashSet();
        Iterator it = this.getUserStore().getSupportedAttributes();
        while (it.hasNext()) {
            Object o = it.next();
            if (!set1.contains(o)) continue;
            set2.add(o);
        }
        return set2.iterator();
    }

    public PropertySerializer getPropertySerializer(String propertyKey) throws UserStoreException {
        return this.getUserStore().getPropertySerializer(propertyKey);
    }

    public void setPropertySerializer(String propertyKey, PropertySerializer serializer) throws UserStoreException {
        this.getUserStore().setPropertySerializer(propertyKey, serializer);
    }

    public boolean hasUser(String userId, Map filter) {
        UserStore userStore = this.getUserStore();
        return this.service.hasUser(userId, UserStoreProxy.mapToArray(userStore, filter, null));
    }

    public UserIterator getUsers(Map filter) {
        UserProperty[] array = UserStoreProxy.mapToArray(this.getUserStore(), filter, null);
        return new UserIteratorImpl(this.service.getUsers(array));
    }

    public void setUserStoreSource(UserStoreSource source) {
        throw new RuntimeException("Unsupported!");
    }

    protected class UserIteratorImpl
    implements UserIterator {
        Iterator it;

        public UserIteratorImpl(HashSet rawSet) {
            this.it = rawSet.iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public UserEntry next() throws NoSuchElementException {
            RawUserEntry entry = (RawUserEntry)this.it.next();
            String userId = entry.getUserId();
            HashSet unsup = new HashSet();
            HashMap map = UserStoreProxy.arrayToMap(UserStoreProxy.this.getUserStore(), entry.getProperties(), unsup);
            if (unsup.size() > 0) {
                cat.warn("Unable to decode properties:" + unsup);
            }
            return new UserEntry(this, userId, map){
                private final /* synthetic */ String val$userId;
                private final /* synthetic */ Map val$map;
                private final /* synthetic */ UserIteratorImpl this$1;
                {
                    this.this$1 = this$1;
                    this.val$userId = val$userId;
                    this.val$map = val$map;
                }

                public String getUserId() {
                    return this.val$userId;
                }

                public Map getProperties() {
                    return this.val$map;
                }

                public Object getProperty(String key) {
                    return this.val$map.get(key);
                }
            };
        }
    }
}

