/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.async;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.async.AsyncTask;
import org.commoncrawl.async.EventLoop;

public class ConcurrentTask<V>
extends FutureTask<V> {
    private static final Log LOG = LogFactory.getLog(ConcurrentTask.class);
    private EventLoop _eventLoop;
    private CompletionCallback<V> _callback;

    public ConcurrentTask(EventLoop eventLoop, Callable<V> callable, CompletionCallback<V> callback) {
        super(callable);
        this._eventLoop = eventLoop;
        this._callback = callback;
    }

    @Override
    protected void done() {
        AsyncTask.runAsyncTask(this._eventLoop, new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrentTask.this._callback.taskComplete(ConcurrentTask.this.get());
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                }
                catch (ExecutionException e) {
                    LOG.error((Object)e);
                    ConcurrentTask.this._callback.taskFailed(e);
                }
                catch (CancellationException e) {
                    LOG.error((Object)e);
                    ConcurrentTask.this._callback.taskFailed(e);
                }
            }
        }, false);
    }

    public static interface CompletionCallback<V> {
        public void taskComplete(V var1);

        public void taskFailed(Exception var1);
    }
}

