/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.async;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;

public final class TimerRegistry {
    private EventLoop _eventLoop;
    private Vector<Timer> _active = new Vector();
    private boolean _sort = false;

    public TimerRegistry(EventLoop eventLoop) {
        this._eventLoop = eventLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimer(Timer t) {
        Timer timer = t;
        synchronized (timer) {
            if (!t.isArmed()) {
                t.arm();
                TimerRegistry timerRegistry = this;
                synchronized (timerRegistry) {
                    this._active.add(t);
                    this._sort = true;
                }
                if (Thread.currentThread() != this._eventLoop.getEventThread()) {
                    this._eventLoop.wakeup();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(Timer t) {
        Timer timer = t;
        synchronized (timer) {
            if (t.isArmed()) {
                t.disarm();
                TimerRegistry timerRegistry = this;
                synchronized (timerRegistry) {
                    this._sort = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long fireTimers() {
        Timer t;
        long currentTime = System.currentTimeMillis();
        LinkedList<Timer> fireList = new LinkedList<Timer>();
        int fired = 0;
        TimerRegistry timerRegistry = this;
        synchronized (timerRegistry) {
            if (this._sort) {
                Collections.sort(this._active);
                this._sort = false;
            }
            for (int i = 0; i < this._active.size() && (t = this._active.get(i)).isArmed() && t.getNextFireTime() <= currentTime; ++i) {
                fireList.add(t);
            }
        }
        Iterator i$ = fireList.iterator();
        while (i$.hasNext()) {
            Timer t2;
            t = t2 = (Timer)i$.next();
            synchronized (t) {
                if (t2.isArmed() && t2.getNextFireTime() <= currentTime) {
                    t2.fire();
                    ++fired;
                }
            }
        }
        timerRegistry = this;
        synchronized (timerRegistry) {
            int activeCount = this._active.size();
            for (int i = 0; i < activeCount; ++i) {
                Timer t3 = this._active.elementAt(i);
                if (t3.isArmed()) continue;
                this._active.remove(i--);
                --activeCount;
            }
            if (fired != 0 || this._sort) {
                Collections.sort(this._active);
                this._sort = false;
            }
            return this._active.size() != 0 ? this._active.get(0).getNextFireTime() : 0L;
        }
    }
}

