/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.mapred;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.commoncrawl.hadoop.io.mapred.ARCFileRecordReader;

public class ARCFileInputFormat
extends FileInputFormat<Text, BytesWritable> {
    private static final String ARC_SUFFIX = "arc.gz";
    public static final String USE_S3_INPUTSTREAM = "fs.s3n.use.s3inputstream";

    public RecordReader<Text, BytesWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        ARCFileRecordReader reader = new ARCFileRecordReader();
        reader.initialize((Configuration)job, split);
        return reader;
    }

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        return ARCFileInputFormat.filterInputCandidates(super.listStatus(job));
    }

    public static FileStatus[] filterInputCandidates(FileStatus[] candidateArray) {
        ArrayList<FileStatus> listOut = new ArrayList<FileStatus>(candidateArray.length);
        for (int i = 0; i < candidateArray.length; ++i) {
            Path pathAtIndex = candidateArray[i].getPath();
            if (!pathAtIndex.getName().endsWith(ARC_SUFFIX)) continue;
            listOut.add(candidateArray[i]);
        }
        return listOut.toArray(new FileStatus[listOut.size()]);
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }
}

