/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.commoncrawl.hadoop.io.mapred.ARCFileInputFormat;
import org.commoncrawl.hadoop.io.mapred.ARCFileRecordReader;
import org.commoncrawl.protocol.shared.ArcFileItem;
import org.commoncrawl.util.shared.ArcFileItemUtils;

public class ARCFileItemInputFormat
extends FileInputFormat<Text, ArcFileItem> {
    public RecordReader<Text, ArcFileItem> getRecordReader(final InputSplit split, JobConf job, Reporter reporter) throws IOException {
        final ARCFileRecordReader reader = new ARCFileRecordReader();
        reader.initialize((Configuration)job, split);
        return new RecordReader<Text, ArcFileItem>(){
            BytesWritable valueBytes = new BytesWritable();

            public void close() throws IOException {
                reader.close();
            }

            public Text createKey() {
                return new Text();
            }

            public ArcFileItem createValue() {
                return new ArcFileItem();
            }

            public long getPos() throws IOException {
                return reader.getPos();
            }

            public float getProgress() throws IOException {
                return reader.getProgress();
            }

            public boolean next(Text key, ArcFileItem value) throws IOException {
                long preReadPos = reader.reader.getPosition();
                if (reader.next(key, this.valueBytes)) {
                    long postReadPos = reader.reader.getPosition();
                    ArcFileItemUtils.bytesWritableToArcFileItem(key, this.valueBytes, value);
                    value.setArcFileName(((FileSplit)split).getPath().getName());
                    value.setArcFilePos((int)preReadPos);
                    value.setArcFileSize((int)(postReadPos - preReadPos));
                    return true;
                }
                return false;
            }
        };
    }

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        return ARCFileInputFormat.filterInputCandidates(super.listStatus(job));
    }

    protected boolean isSplitable(FileSystem fs, Path filename) {
        return false;
    }
}

