/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.commoncrawl.util.shared.ARCFileReader;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.S3InputStream;
import org.jets3t.service.Jets3tProperties;

public class ARCFileRecordReader
implements RecordReader<Text, BytesWritable> {
    private static final Log LOG = LogFactory.getLog(ARCFileRecordReader.class);
    protected Configuration conf;
    protected ARCFileReader reader;
    private long start;
    private long end;

    public void initialize(Configuration conf, InputSplit split) throws IOException {
        this.conf = conf;
        FileSplit fileSplit = (FileSplit)split;
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem(conf);
        Object in = null;
        if (fs instanceof NativeS3FileSystem) {
            if (conf.getBoolean("fs.s3n.use.s3inputstream", false)) {
                in = new S3InputStream(path.toUri(), conf.get("fs.s3n.awsAccessKeyId"), conf.get("fs.s3n.awsSecretAccessKey"), 0x100000);
            } else {
                Jets3tProperties properties = Jets3tProperties.getInstance((String)"jets3t.properties");
                properties.setProperty("s3service.https-only", "false");
            }
        }
        if (in == null) {
            in = fs.open(path);
        }
        try {
            this.reader = new ARCFileReader((InputStream)in);
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            in.close();
            throw e;
        }
        this.start = fileSplit.getStart();
        this.end = fileSplit.getLength();
        if (this.start != 0L || fs.getFileStatus(path).getLen() != this.end) {
            throw new IOException("Invalid FileSplit encountered! Split Details:" + split.toString());
        }
    }

    public boolean next(Text key, BytesWritable value) throws IOException {
        if (this.reader.hasMoreItems()) {
            this.reader.nextKeyValue(key, value);
            return true;
        }
        return false;
    }

    public Text createKey() {
        return new Text();
    }

    public BytesWritable createValue() {
        return new BytesWritable();
    }

    public long getPos() throws IOException {
        return this.reader.getPosition();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public float getProgress() throws IOException {
        return (float)this.reader.getPosition() / (float)this.end;
    }
}

