/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileRecordReader;

public class EscapedNewLineSequenceFileInputFormat
extends SequenceFileInputFormat<Text, Text> {
    public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new EscapeNewLineRecordReader((Configuration)job, (FileSplit)split);
    }

    public final class EscapeNewLineRecordReader
    extends SequenceFileRecordReader<Text, Text> {
        public EscapeNewLineRecordReader(Configuration conf, FileSplit split) throws IOException {
            super(conf, split);
        }

        protected synchronized void getCurrentValue(Text value) throws IOException {
            super.getCurrentValue((Object)value);
            String cleanedup = value.toString().replaceAll("\\r", " ").trim().replaceAll("\\n", "\\\\n").replaceAll("\\t", "\\\\t");
            value.set(cleanedup);
        }
    }
}

