/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.mergeutils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Reporter;
import org.commoncrawl.hadoop.mergeutils.KeyValuePairComparator;
import org.commoncrawl.hadoop.mergeutils.OptimizedKeyGeneratorAndComparator;
import org.commoncrawl.hadoop.mergeutils.RawDataSpillWriter;
import org.commoncrawl.hadoop.mergeutils.RawKeyValueComparator;
import org.commoncrawl.hadoop.mergeutils.SpillValueCombiner;
import org.commoncrawl.hadoop.mergeutils.SpillWriter;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.IntrusiveList;

public class SequenceFileMerger<KeyType extends WritableComparable, ValueType extends Writable> {
    public static final Log LOG = LogFactory.getLog(SequenceFileMerger.class);
    IntrusiveList<MergeResultSegment<KeyType, ValueType>> _segmentList = new IntrusiveList();
    int _originalSegementCount = 0;
    int _completedSegmentCount = 0;
    long _percentComplete = 0L;
    SpillWriter<KeyType, ValueType> _writer = null;
    RawDataSpillWriter<KeyType, ValueType> _rawWriter = null;
    KeyValuePairComparator<KeyType, ValueType> _comparator;
    RawKeyValueComparator<KeyType, ValueType> _rawComparator = null;
    OptimizedKeyGeneratorAndComparator<KeyType, ValueType> _optimizedKeyGenerator = null;
    SpillValueCombiner<KeyType, ValueType> _optionalCombiner = null;
    long _inputRecordCount = 0L;
    long _mergedRecordCount = 0L;
    int _optimizedKeyType = 0;

    public SequenceFileMerger(FileSystem fileSystem, Configuration conf, Vector<Path> inputSegments, SpillWriter<KeyType, ValueType> spillWriter, Class<KeyType> keyClass, Class<ValueType> valueClass, SpillValueCombiner<KeyType, ValueType> optionalCombiner, KeyValuePairComparator<KeyType, ValueType> comparator) throws IOException {
        this.init(fileSystem, conf, inputSegments, spillWriter, keyClass, valueClass, comparator, null, optionalCombiner);
    }

    SequenceFileMerger(FileSystem fileSystem, Configuration conf, Vector<Path> inputSegments, SpillWriter<KeyType, ValueType> spillWriter, Class<KeyType> keyClass, Class<ValueType> valueClass, OptimizedKeyGeneratorAndComparator<KeyType, ValueType> keyGenerator) throws IOException {
        this._optimizedKeyType = keyGenerator.getGeneratedKeyType();
        this.init(fileSystem, conf, inputSegments, spillWriter, keyClass, valueClass, null, keyGenerator, null);
    }

    public SequenceFileMerger(FileSystem fileSystem, Configuration conf, Vector<Path> inputSegments, SpillWriter<KeyType, ValueType> spillWriter, Class<KeyType> keyClass, Class<ValueType> valueClass, RawKeyValueComparator<KeyType, ValueType> comparator) throws IOException {
        this.init(fileSystem, conf, inputSegments, spillWriter, keyClass, valueClass, comparator, null, null);
    }

    public void close() throws IOException {
        for (MergeResultSegment<KeyType, ValueType> segment : this._segmentList) {
            try {
                segment.close();
            }
            catch (IOException e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeAndSpill(Reporter reporter) throws IOException {
        long sortStartTime = System.currentTimeMillis();
        MergeResultSegment[] sortArray = new MergeResultSegment[this._segmentList.size() + 1];
        WritableComparable lastCombinerKey = null;
        Vector<ValueType> valueBuffer = new Vector<ValueType>();
        while (this._segmentList.getHead() != null) {
            block22: {
                MergeResultSegment<KeyType, ValueType> spillSegment = null;
                try {
                    spillSegment = this._segmentList.removeHead();
                    if (this._optionalCombiner == null) {
                        ++this._mergedRecordCount;
                        if (this._optimizedKeyGenerator != null) {
                            this._rawWriter.spillRawRecord(spillSegment.getRawKeyData().getData(), spillSegment.getOptimizedKey().getHeaderSize() + 4, spillSegment.getRawKeyData().getLength() - spillSegment.getOptimizedKey().getHeaderSize() - 4, spillSegment.getRawValueData().getData(), 0, spillSegment.getRawValueData().getLength() - spillSegment.getOptimizedKey().getDataBufferSize());
                        } else if (this._rawComparator != null) {
                            this._rawWriter.spillRawRecord(spillSegment.getRawKeyData().getData(), 0, spillSegment.getRawKeyData().getLength(), spillSegment.getRawValueData().getData(), 0, spillSegment.getRawValueData().getLength());
                        } else {
                            this._writer.spillRecord((WritableComparable)spillSegment.getKey(), spillSegment.getValue());
                        }
                    } else {
                        if (valueBuffer.size() != 0 && lastCombinerKey.compareTo(spillSegment.getKey()) != 0) {
                            ++this._mergedRecordCount;
                            this._writer.spillRecord(lastCombinerKey, this._optionalCombiner.combineValues(lastCombinerKey, valueBuffer));
                            valueBuffer.clear();
                        }
                        if (valueBuffer.size() == 0) {
                            lastCombinerKey = (WritableComparable)spillSegment.getKey();
                        }
                        valueBuffer.add(spillSegment.getValue());
                    }
                    if (spillSegment.next()) {
                        ++this._inputRecordCount;
                        if (this._segmentList.size() == 0) {
                            this._segmentList.addHead(spillSegment);
                        } else {
                            this.addItemsToArray(sortArray, this._segmentList);
                            MergeResultSegment<KeyType, ValueType> insertionPos = this._findInsertionPos(spillSegment, sortArray, this._segmentList.size());
                            if (insertionPos == null) {
                                this._segmentList.addHead(spillSegment);
                            } else {
                                this._segmentList.insertAfter(insertionPos, spillSegment);
                            }
                        }
                        break block22;
                    }
                    try {
                        spillSegment.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Segment:" + spillSegment.getName() + " Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                    }
                    finally {
                        ++this._completedSegmentCount;
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    if (spillSegment == null) break block22;
                    LOG.error((Object)("Error during splill of segment:" + spillSegment.getName() + " Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                }
            }
            if (this._mergedRecordCount % 100000L != 0L) continue;
            this.updateProgress(reporter);
            LOG.info((Object)("Merged " + this._mergedRecordCount + " Items"));
        }
        this.updateProgress(reporter);
        if (this._optionalCombiner != null && valueBuffer.size() != 0) {
            ++this._mergedRecordCount;
            this._writer.spillRecord(lastCombinerKey, this._optionalCombiner.combineValues(lastCombinerKey, valueBuffer));
            valueBuffer.clear();
        }
        LOG.info((Object)("Merge took:" + (System.currentTimeMillis() - sortStartTime) + " InputRecordCount:" + this._inputRecordCount + " MergedRecordCount:" + this._mergedRecordCount));
    }

    void updateProgress(Reporter reporter) {
        if (reporter != null) {
            float segmentFraction = 1.0f / (float)this._originalSegementCount;
            float pctComplete = segmentFraction * (float)this._completedSegmentCount;
            for (MergeResultSegment<KeyType, ValueType> segment : this._segmentList) {
                pctComplete += segmentFraction * segment.getPercentComplete();
            }
            reporter.incrCounter((Enum)Counters.RECORDS_MERGED, this._mergedRecordCount);
            long pctCompleteAsLong = (long)(pctComplete * 100.0f);
            long delta = pctCompleteAsLong - this._percentComplete;
            if (delta > 0L) {
                reporter.incrCounter((Enum)Counters.PCT_COMPLETED, delta);
                this._percentComplete = pctCompleteAsLong;
            }
        }
    }

    private void init(FileSystem fileSystem, Configuration conf, Vector<Path> inputSegments, SpillWriter<KeyType, ValueType> spillWriter, Class<KeyType> keyClass, Class<ValueType> valueClass, KeyValuePairComparator<KeyType, ValueType> comparator, OptimizedKeyGeneratorAndComparator<KeyType, ValueType> optionalKeyGenerator, SpillValueCombiner<KeyType, ValueType> optionalCombiner) throws IOException {
        this._comparator = comparator;
        this._optimizedKeyGenerator = optionalKeyGenerator;
        if (this._comparator instanceof RawKeyValueComparator) {
            this._rawComparator = (RawKeyValueComparator)this._comparator;
        }
        if (this._rawComparator != null && this._optimizedKeyGenerator != null) {
            throw new IOException("RawComparator not compatible with OptimizedKeyGenerator option!");
        }
        this._optionalCombiner = optionalCombiner;
        try {
            Vector<MergeResultSegment<KeyType, ValueType>> segments = new Vector<MergeResultSegment<KeyType, ValueType>>();
            for (Path path : inputSegments) {
                MergeResultSegment<KeyType, ValueType> resultSegment = new MergeResultSegment<KeyType, ValueType>(fileSystem, conf, path, keyClass, valueClass, this._rawComparator != null || this._optimizedKeyGenerator != null, this._optimizedKeyGenerator);
                if (!resultSegment.next()) {
                    try {
                        resultSegment.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("QueryResultSegment:" + path + " Threw Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                    }
                    continue;
                }
                ++this._inputRecordCount;
                segments.add(resultSegment);
            }
            MergeResultSegment[] segmentArray = segments.toArray(new MergeResultSegment[0]);
            Arrays.sort(segmentArray, new Comparator<MergeResultSegment<KeyType, ValueType>>(){

                @Override
                public int compare(MergeResultSegment<KeyType, ValueType> o1, MergeResultSegment<KeyType, ValueType> o2) {
                    try {
                        if (SequenceFileMerger.this._optimizedKeyGenerator != null) {
                            int result = 0;
                            if ((SequenceFileMerger.this._optimizedKeyType & 1) != 0) {
                                result = (int)(o1.getOptimizedKey().getLongKeyValue() - o2.getOptimizedKey().getLongKeyValue());
                            }
                            if (result == 0 && (SequenceFileMerger.this._optimizedKeyType & 2) != 0) {
                                result = SequenceFileMerger.this._optimizedKeyGenerator.compareOptimizedBufferKeys(o1.getOptimizedKey().getBufferKeyValue().get(), o1.getOptimizedKey().getBufferKeyValue().getOffset(), o1.getOptimizedKey().getBufferKeyValue().getCount(), o2.getOptimizedKey().getBufferKeyValue().get(), o2.getOptimizedKey().getBufferKeyValue().getOffset(), o2.getOptimizedKey().getBufferKeyValue().getCount());
                            }
                            return result;
                        }
                        if (SequenceFileMerger.this._rawComparator != null) {
                            return SequenceFileMerger.this._rawComparator.compareRaw(o1.getRawKeyData().getData(), 0, o1.getRawKeyData().getLength(), o2.getRawKeyData().getData(), 0, o2.getRawKeyData().getLength(), o1.getRawValueData().getData(), 0, o1.getRawValueData().getLength(), o2.getRawValueData().getData(), 0, o2.getRawValueData().getLength());
                        }
                        return SequenceFileMerger.this._comparator.compare((WritableComparable)o1.getKey(), o1.getValue(), (WritableComparable)o2.getKey(), o2.getValue());
                    }
                    catch (IOException e) {
                        LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                        throw new RuntimeException(e);
                    }
                }
            });
            int index = 0;
            for (MergeResultSegment segment : segmentArray) {
                segment.setIndex(index++);
                this._segmentList.addTail(segment);
            }
            this._originalSegementCount = segmentArray.length;
            this._writer = spillWriter;
            if (!(this._writer instanceof RawDataSpillWriter)) {
                throw new IOException("Writer supplied with RawComparator does not implement RawDataSpillWriter");
            }
            this._rawWriter = (RawDataSpillWriter)this._writer;
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            for (MergeResultSegment<KeyType, ValueType> segment : this._segmentList) {
                try {
                    segment.close();
                }
                catch (IOException e2) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e2));
                }
            }
            throw e;
        }
    }

    private final void addItemsToArray(MergeResultSegment<KeyType, ValueType>[] array, IntrusiveList<MergeResultSegment<KeyType, ValueType>> list) {
        int pos = 0;
        for (MergeResultSegment current = list.getHead(); current != null; current = (MergeResultSegment)current.getNext()) {
            array[pos++] = current;
        }
    }

    private final MergeResultSegment<KeyType, ValueType> _findInsertionPos(MergeResultSegment<KeyType, ValueType> searchSegment, MergeResultSegment<KeyType, ValueType>[] array, int arrayCount) throws IOException {
        int low = 0;
        int high = arrayCount - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            MergeResultSegment<KeyType, ValueType> segment = array[mid];
            int compareResult = 0;
            if (this._optimizedKeyGenerator != null) {
                if ((this._optimizedKeyType & 1) != 0) {
                    compareResult = (int)(segment.getOptimizedKey().getLongKeyValue() - searchSegment.getOptimizedKey().getLongKeyValue());
                }
                if (compareResult == 0 && (this._optimizedKeyType & 2) != 0) {
                    compareResult = this._optimizedKeyGenerator.compareOptimizedBufferKeys(segment.getOptimizedKey().getBufferKeyValue().get(), segment.getOptimizedKey().getBufferKeyValue().getOffset(), segment.getOptimizedKey().getBufferKeyValue().getCount(), searchSegment.getOptimizedKey().getBufferKeyValue().get(), searchSegment.getOptimizedKey().getBufferKeyValue().getOffset(), searchSegment.getOptimizedKey().getBufferKeyValue().getCount());
                }
            } else {
                compareResult = this._rawComparator != null ? this._rawComparator.compareRaw(segment.getRawKeyData().getData(), 0, segment.getRawKeyData().getLength(), searchSegment.getRawKeyData().getData(), 0, searchSegment.getRawKeyData().getLength(), segment.getRawValueData().getData(), 0, segment.getRawValueData().getLength(), searchSegment.getRawValueData().getData(), 0, searchSegment.getRawValueData().getLength()) : this._comparator.compare((WritableComparable)segment.getKey(), segment.getValue(), (WritableComparable)searchSegment.getKey(), searchSegment.getValue());
            }
            if (compareResult > 0) {
                high = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            return array[mid];
        }
        if (high == -1) {
            return null;
        }
        return array[high];
    }

    private static class MergeResultSegment<KeyType extends Writable, ValueType extends Writable>
    extends IntrusiveList.IntrusiveListElement<MergeResultSegment<KeyType, ValueType>> {
        private static final Class[] emptyArray = new Class[0];
        SequenceFile.Reader reader = null;
        KeyType key = null;
        ValueType value = null;
        Constructor<KeyType> keyConstructor = null;
        Constructor<ValueType> valConstructor = null;
        boolean eos = false;
        Path path;
        long lastPos;
        long fileSize;
        int index = -1;
        boolean useRawMode = false;
        DataOutputBuffer rawKeyData = null;
        DataOutputBuffer rawValueData = null;
        SequenceFile.ValueBytes valueBytes = null;
        OptimizedKeyGeneratorAndComparator<KeyType, ValueType> _optimizedGenerator = null;
        OptimizedKeyGeneratorAndComparator.OptimizedKey _optimizedKey = null;
        float percentComplete = 0.0f;

        public MergeResultSegment(FileSystem fileSystem, Configuration conf, Path inputFile, Class<KeyType> keyClass, Class<ValueType> valueClass, boolean useRawMode, OptimizedKeyGeneratorAndComparator<KeyType, ValueType> optionalGenerator) throws IOException {
            try {
                this.useRawMode = useRawMode;
                this._optimizedGenerator = optionalGenerator;
                if (this._optimizedGenerator != null) {
                    this._optimizedKey = new OptimizedKeyGeneratorAndComparator.OptimizedKey(this._optimizedGenerator.getGeneratedKeyType());
                }
                this.keyConstructor = keyClass.getDeclaredConstructor(emptyArray);
                this.keyConstructor.setAccessible(true);
                this.valConstructor = valueClass.getDeclaredConstructor(emptyArray);
                this.valConstructor.setAccessible(true);
                if (useRawMode) {
                    this.rawKeyData = new DataOutputBuffer();
                    this.rawValueData = new DataOutputBuffer();
                }
            }
            catch (SecurityException e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                throw new RuntimeException(e);
            }
            this.path = inputFile;
            this.lastPos = 0L;
            this.fileSize = fileSystem.getFileStatus(inputFile).getLen();
            this.reader = new SequenceFile.Reader(fileSystem, inputFile, conf);
            if (useRawMode) {
                this.valueBytes = this.reader.createValueBytes();
            }
            this.index = -1;
        }

        public MergeResultSegment() {
            this.eos = true;
            this.percentComplete = 1.0f;
        }

        void setIndex(int index) {
            this.index = index;
        }

        int getIndex() {
            return this.index;
        }

        public boolean isNullSegment() {
            return this.reader == null;
        }

        public OptimizedKeyGeneratorAndComparator.OptimizedKey getOptimizedKey() {
            return this._optimizedKey;
        }

        public KeyType getKey() throws IOException {
            if (this.useRawMode) {
                throw new IOException("getKey Unsupported in RawMode");
            }
            return this.key;
        }

        public ValueType getValue() throws IOException {
            if (this.useRawMode) {
                throw new IOException("getValue Unsupported in RawMode");
            }
            return this.value;
        }

        public DataOutputBuffer getRawKeyData() {
            return this.rawKeyData;
        }

        public DataOutputBuffer getRawValueData() {
            return this.rawValueData;
        }

        public float getPercentComplete() {
            return this.percentComplete;
        }

        public boolean next() throws IOException {
            if (!this.eos) {
                try {
                    if (!this.useRawMode) {
                        this.key = (Writable)this.keyConstructor.newInstance(new Object[0]);
                        this.value = (Writable)this.valConstructor.newInstance(new Object[0]);
                    } else {
                        this.rawKeyData.reset();
                        this.rawValueData.reset();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to create key or value type with Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                    throw new RuntimeException(e);
                }
                if (!this.useRawMode) {
                    this.eos = !this.reader.next(this.key, this.value);
                } else {
                    boolean bl = this.eos = this.reader.nextRawKey(this.rawKeyData) == -1;
                    if (!this.eos) {
                        if (this.reader.nextRawValue(this.valueBytes) != 0) {
                            this.valueBytes.writeUncompressedBytes((DataOutputStream)this.rawValueData);
                        }
                        if (!this.eos && this._optimizedGenerator != null) {
                            this._optimizedKey.initFromKeyValuePair(this.rawKeyData.getData(), 0, this.rawKeyData.getLength(), this.rawValueData.getData(), 0, this.rawValueData.getLength());
                        }
                    }
                }
                if (!this.eos) {
                    if (this.lastPos != this.reader.getPosition()) {
                        this.percentComplete = (float)((double)this.reader.getPosition() / (double)this.fileSize);
                        this.lastPos = this.reader.getPosition();
                    }
                } else {
                    this.percentComplete = 1.0f;
                }
            }
            return !this.eos;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        public Path getPath() {
            return this.path;
        }

        public String getName() {
            return "Seg:" + this.index + "(" + this.path.toString() + ")";
        }
    }

    public static enum Counters {
        RECORDS_MERGED,
        PCT_COMPLETED;

    }
}

