/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.mergeutils;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.commoncrawl.hadoop.mergeutils.SpillWriter;
import org.commoncrawl.util.shared.CCStringUtils;

public class SequenceFileReader<KeyType extends WritableComparable, ValueType extends Writable> {
    public static final Log LOG = LogFactory.getLog(SequenceFileReader.class);
    FileSystem _sourceFileSystem;
    Configuration _config;
    SpillWriter<KeyType, ValueType> _writer = null;
    Vector<Path> _inputSegments = null;
    Constructor<KeyType> _keyConstructor = null;
    Constructor<ValueType> _valConstructor = null;
    long _recordCount = 0L;
    private static final Class[] emptyArray = new Class[0];

    public SequenceFileReader(FileSystem fileSystem, Configuration conf, Vector<Path> inputSegments, SpillWriter<KeyType, ValueType> spillWriter, Class<KeyType> keyClass, Class<ValueType> valueClass) throws IOException {
        this._sourceFileSystem = fileSystem;
        this._config = conf;
        this._inputSegments = inputSegments;
        this._writer = spillWriter;
        try {
            this._keyConstructor = keyClass.getDeclaredConstructor(emptyArray);
            this._keyConstructor.setAccessible(true);
            this._valConstructor = valueClass.getDeclaredConstructor(emptyArray);
            this._valConstructor.setAccessible(true);
        }
        catch (SecurityException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndSpill() throws IOException {
        long cumilativeReadTimeStart = System.currentTimeMillis();
        for (Path sequenceFilePath : this._inputSegments) {
            long individualReadTimeStart = System.currentTimeMillis();
            SequenceFile.Reader reader = new SequenceFile.Reader(this._sourceFileSystem, sequenceFilePath, this._config);
            try {
                boolean eos = false;
                while (!eos) {
                    WritableComparable key = null;
                    Writable value = null;
                    try {
                        key = (WritableComparable)this._keyConstructor.newInstance(new Object[0]);
                        value = (Writable)this._valConstructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to create key or value type with Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                        throw new RuntimeException(e);
                    }
                    eos = !reader.next((Writable)key, value);
                    if (eos) continue;
                    ++this._recordCount;
                    this._writer.spillRecord(key, value);
                }
                while (!eos) {
                }
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }
}

