/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOClientSocketListener;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.io.internal.NIOSocketListener;

public class NIOClientTCPSocket
extends NIOClientSocket {
    public static final Log LOG = LogFactory.getLog(NIOClientTCPSocket.class);
    int _socketId = NIOSocket._idFactory.getNextId();
    SocketType _socketType;
    SocketChannel _channel;
    NIOClientSocketListener _listener;
    InetSocketAddress _localAddress;
    InetSocketAddress _address;

    public NIOClientTCPSocket(InetSocketAddress localAddress, NIOClientSocketListener socketListener) throws IOException {
        this._socketType = SocketType.Outgoing;
        this._channel = SocketChannel.open();
        if (localAddress != null) {
            InetSocketAddress modifiedLocalAddress = new InetSocketAddress(localAddress.getAddress(), 0);
            this._channel.socket().bind(modifiedLocalAddress);
        }
        this._localAddress = (InetSocketAddress)this._channel.socket().getLocalSocketAddress();
        NIOClientTCPSocket.setClientSocketOptions(this._channel);
        this._listener = socketListener;
    }

    private static void setClientSocketOptions(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
    }

    NIOClientTCPSocket(SocketChannel channel) throws IOException {
        this._socketType = SocketType.Incoming;
        this._channel = channel;
        this._address = new InetSocketAddress(channel.socket().getInetAddress(), channel.socket().getPort());
    }

    @Override
    public int getSocketId() {
        return this._socketId;
    }

    @Override
    public boolean isOpen() {
        return this._channel != null;
    }

    @Override
    public void close() {
        if (this._channel != null) {
            try {
                this._channel.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
            this._channel = null;
        }
    }

    @Override
    public void connect(InetSocketAddress address) throws IOException {
        if (this._socketType == SocketType.Incoming) {
            throw new IOException("Invalid State-Connect called on an Incoming (server) Socket");
        }
        this._address = address;
        if (this._channel == null) {
            throw new IOException("Invalid State- Channel Not Open during connect call");
        }
        this._channel.connect(address);
    }

    @Override
    public AbstractSelectableChannel getChannel() {
        return this._channel;
    }

    @Override
    public NIOSocketListener getListener() {
        return this._listener;
    }

    @Override
    public void setListener(NIOSocketListener listener) {
        this._listener = (NIOClientSocketListener)listener;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this._channel == null) {
            throw new IOException("Invalid State - read called on closed channel");
        }
        return this._channel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this._channel == null) {
            throw new IOException("Invalid State - read called on closed channel");
        }
        return this._channel.write(src);
    }

    @Override
    public boolean finishConnect() throws IOException {
        if (this._socketType == SocketType.Incoming) {
            throw new IOException("Invalid State-Connect called on an Incoming (server) Socket");
        }
        if (this._channel == null) {
            throw new IOException("Invalid State - finishConnect called on closed channel");
        }
        if (this._channel.finishConnect()) {
            this._channel.socket().setKeepAlive(true);
            return true;
        }
        return false;
    }

    @Override
    public InetSocketAddress getSocketAddress() throws IOException {
        return this._address;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() throws IOException {
        if (this._channel != null && this._channel.isOpen()) {
            return (InetSocketAddress)this._channel.socket().getLocalSocketAddress();
        }
        return this._localAddress;
    }

    static enum SocketType {
        Outgoing,
        Incoming;

    }
}

