/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.DomainNameUtils;
import org.commoncrawl.util.shared.IPAddressUtils;
import org.commoncrawl.util.shared.MovingAverage;
import org.junit.Assert;
import org.junit.Test;

public class NIODNSCache {
    private static final Log LOG = LogFactory.getLog(NIODNSCache.class);
    private Node _root = new Node();
    private Node _ipRoot = new Node();
    private Stack<TreePosition> _iterationStack = new Stack();
    private TreeSet<String> _cannonicalNames = new TreeSet();
    private long numberOfNodes = 0L;
    private long numberOfNodesRemoved = 0L;
    private boolean enableIPAddressTracking = false;
    public MovingAverage _dnsAddToCacheTime = new MovingAverage(25);
    public MovingAverage _dnsLookupFromCacheTime = new MovingAverage(25);
    private static final int searchMode_NodeChar = 1;
    private static final int searchMode_MultiNodeChar = 2;
    static int numberOfNodesChildEQ1 = 0;
    static int numberOfNodesChildLTEQ4 = 0;
    static int numberOfNodesChildLTEQ8 = 0;
    static int numberOfNodesChildGT8 = 0;

    public NIODNSCache() {
        this._iterationStack.ensureCapacity(1024);
    }

    public synchronized long getActiveNodeCount() {
        return this.numberOfNodes - this.numberOfNodesRemoved;
    }

    public synchronized void enableIPAddressTracking() {
        this.enableIPAddressTracking = true;
    }

    public synchronized void clear() {
        this._root = new Node();
        this._ipRoot = new Node();
        this._cannonicalNames.clear();
        this._iterationStack.clear();
        this.numberOfNodes = 0L;
        this.numberOfNodesRemoved = 0L;
    }

    public synchronized DNSResult getIPAddressForHost(String hostName) {
        long startTime = System.currentTimeMillis();
        DNSResult result = null;
        Node resolvedNode = this.findNode(hostName);
        String cName = null;
        int ipAddress = 0;
        long ttl = 0L;
        if (resolvedNode != null) {
            Node cannonicalNode;
            if (resolvedNode.getIPAddress() != 0) {
                ipAddress = resolvedNode.getIPAddress();
                ttl = resolvedNode.getTimeToLive();
                cName = resolvedNode.getCannonicalName();
            }
            if (cName != null && ttl <= System.currentTimeMillis() && (cannonicalNode = this.findNode(cName)) != null && cannonicalNode.getTimeToLive() > resolvedNode.getTimeToLive()) {
                ipAddress = cannonicalNode.getIPAddress();
                ttl = cannonicalNode.getTimeToLive();
                resolvedNode.setIPAddress(ipAddress);
                resolvedNode.setTimeToLive(ttl);
            }
        }
        if (ipAddress != 0) {
            result = new DNSResult(ipAddress, ttl, cName);
        }
        long endTime = System.currentTimeMillis();
        this._dnsLookupFromCacheTime.addSample(endTime - startTime);
        return result;
    }

    private void addIPToNameNode(int ipAddress, String hostName) {
        String ipAddressStr = IPAddressUtils.IntegerToIPAddressString(ipAddress);
        Node ipAddressNode = this.addNode(this._ipRoot, ipAddressStr);
        ipAddressNode._expireTime++;
        String previousHostName = ipAddressNode._cannonicalName;
        if (previousHostName == null) {
            this.setCannonicalNameForNode(ipAddressNode, hostName);
        } else if (previousHostName.compareTo(hostName) != 0) {
            String previousTLDName = DomainNameUtils.extractRootDomainName(previousHostName);
            String currentTLDName = DomainNameUtils.extractRootDomainName(hostName);
            if (previousTLDName != null && currentTLDName != null && previousTLDName.length() == currentTLDName.length() && previousTLDName.length() != previousHostName.length() && previousTLDName.compareTo(currentTLDName) == 0) {
                if (currentTLDName.length() == hostName.length()) {
                    this.setCannonicalNameForNode(ipAddressNode, hostName);
                } else {
                    String[] previousSubDomainNameParts = previousHostName.substring(0, previousHostName.length() - previousTLDName.length()).split("\\.");
                    String[] newSubDomainNameParts = hostName.substring(0, hostName.length() - currentTLDName.length()).split("\\.");
                    int partsToCompare = Math.min(previousSubDomainNameParts.length, newSubDomainNameParts.length);
                    int i = 0;
                    for (i = 0; i < partsToCompare && previousSubDomainNameParts[previousSubDomainNameParts.length - (i + 1)].compareTo(newSubDomainNameParts[newSubDomainNameParts.length - (i + 1)]) == 0; ++i) {
                    }
                    if (i == 0) {
                        this.setCannonicalNameForNode(ipAddressNode, previousTLDName);
                    } else if (i < previousSubDomainNameParts.length) {
                        StringBuffer builder = new StringBuffer();
                        for (int j = i; j < previousSubDomainNameParts.length; ++j) {
                            builder.append(previousSubDomainNameParts[j]);
                            builder.append(".");
                        }
                        builder.append(previousTLDName);
                        this.setCannonicalNameForNode(ipAddressNode, builder.toString());
                    }
                }
            }
        }
    }

    public synchronized Node cacheIPAddressForHost(String hostName, int ipAddress, long ttl, String cName) {
        long startTime = System.currentTimeMillis();
        Node node = this.addNameNode(hostName);
        node.setIPAddress(ipAddress);
        node.setTimeToLive(ttl);
        node.setLastTouchedTime(System.currentTimeMillis());
        if (cName != null) {
            this.setCannonicalNameForNode(node, cName);
            Node cannonicalNameNode = this.addNameNode(cName);
            if (cannonicalNameNode != node && cannonicalNameNode.getTimeToLive() < node.getTimeToLive()) {
                cannonicalNameNode.setIPAddress(ipAddress);
                cannonicalNameNode.setTimeToLive(ttl);
            }
        }
        if (this.enableIPAddressTracking) {
            this.addIPToNameNode(ipAddress, cName != null ? cName : hostName);
        }
        long endTime = System.currentTimeMillis();
        this._dnsAddToCacheTime.addSample(endTime - startTime);
        return node;
    }

    private void setCannonicalNameForNode(Node node, String cName) {
        SortedSet<String> subset = this._cannonicalNames.subSet(cName, cName + "\u0000");
        if (!subset.isEmpty()) {
            node._cannonicalName = subset.first();
        } else {
            node._cannonicalName = cName;
            this._cannonicalNames.add(cName);
        }
    }

    private synchronized void pruneCache() {
        int nodesIterated = 0;
        if (this._iterationStack.size() == 0) {
            Node activeNode;
            Node node = activeNode = this._root.getChildCount() != 0 ? this._root.getChildAt(0) : null;
            if (activeNode != null) {
                this._iterationStack.add(new TreePosition(this._root, 0));
            }
        }
        long startTime = System.currentTimeMillis();
        while (this._iterationStack.size() != 0) {
            TreePosition pos = this._iterationStack.peek();
            Node currentNode = pos.resolve();
            if (currentNode != null && currentNode.getChildCount() != 0) {
                this._iterationStack.push(new TreePosition(currentNode, 0));
                continue;
            }
            if (currentNode == null) {
                currentNode = pos.getNode();
                if (currentNode == this._root) break;
                this._iterationStack.pop();
                pos = this._iterationStack.peek();
            }
            ++nodesIterated;
            if (currentNode.getTimeToLive() <= startTime && currentNode.getChildCount() == 0) {
                ++this.numberOfNodesRemoved;
                pos.getNode().removeChildAt(pos.getIndex());
                if (System.currentTimeMillis() - startTime > 100L) {
                    LOG.info((Object)("Time Up. breaking out. Nodes Iterated:" + nodesIterated));
                    this.dumpStats();
                    LOG.info((Object)("Prune Took:" + (System.currentTimeMillis() - startTime) + " MS"));
                    return;
                }
            } else {
                pos.setIndex(pos.getIndex() + 1);
            }
            if (pos.getIndex() < pos.getNode().getChildCount()) continue;
            this._iterationStack.pop();
            if (this._iterationStack.size() == 0) continue;
            TreePosition parentPos = this._iterationStack.peek();
            parentPos.setIndex(parentPos.getIndex() + 1);
        }
        long timeAfterPrune = System.currentTimeMillis();
        this._iterationStack.removeAllElements();
        LOG.info((Object)"Prune Finished Iterating Whole Tree");
        this.dumpStats();
        LOG.info((Object)("Prune Took:" + (timeAfterPrune - startTime) + " MS"));
    }

    private final synchronized void dumpStats() {
        LOG.info((Object)("Nodes Count:" + this.numberOfNodes));
        LOG.info((Object)("Nodes Removed:" + this.numberOfNodesRemoved));
    }

    public Node addNameNode(String nodeName) {
        return this.addNode(this._root, nodeName);
    }

    private Node addNode(Node rootNode, String path) {
        String s = path.toLowerCase();
        Node node = rootNode;
        if (s.length() > 0) {
            int multiNodeIdx = -1;
            int searchMode = 1;
            for (int i = s.length() - 1; i >= 0; --i) {
                if (searchMode == 1) {
                    int multiNodeScanStart;
                    int multiNodeCharEndPos;
                    if ((node = node.findOrAddChild(this, s.charAt(i), true)).isMultiCharNode()) {
                        searchMode = 2;
                        multiNodeIdx = node.getMultiCharArray().length - 1;
                        continue;
                    }
                    if (node.getChildCount() != 0 || i == 0 || s.charAt(i) == '.' || node.isTerminalNode()) continue;
                    for (multiNodeCharEndPos = multiNodeScanStart = i - 1; multiNodeCharEndPos >= 0 && s.charAt(multiNodeCharEndPos) != '.'; --multiNodeCharEndPos) {
                    }
                    if (multiNodeScanStart - multiNodeCharEndPos == 0) continue;
                    if (multiNodeCharEndPos != -1) {
                        node.markAsMultiCharNode(s.toCharArray(), multiNodeCharEndPos + 1, i - (multiNodeCharEndPos + 1));
                        i = multiNodeCharEndPos + 1;
                        searchMode = 1;
                        continue;
                    }
                    node.markAsMultiCharNode(s.toCharArray(), 0, i);
                    break;
                }
                if (multiNodeIdx == -1 || i == -1) {
                    throw new RuntimeException();
                }
                if (node.getMultiCharArray()[multiNodeIdx] != s.charAt(i)) {
                    node.splitMultiCharNodeAt(this, multiNodeIdx);
                    ++i;
                    searchMode = 1;
                    continue;
                }
                if (--multiNodeIdx >= 0) continue;
                searchMode = 1;
            }
            if (searchMode == 2 && multiNodeIdx != -1) {
                node.splitMultiCharNodeAt(this, multiNodeIdx);
            }
            node.markAsTerminalNode();
            return node;
        }
        return null;
    }

    public Node findNode(String nodeName) {
        Node nodeOut = this._findNode(this._root, nodeName);
        if (nodeOut != null && nodeOut.isTerminalNode()) {
            nodeOut.setLastTouchedTime(System.currentTimeMillis());
        }
        return nodeOut;
    }

    private synchronized Node _findNode(Node rootNode, String nodeName) {
        String s = nodeName.toLowerCase();
        Node node = rootNode;
        if (s.length() > 0) {
            Node lastSubTerminalNode = null;
            for (int i = s.length() - 1; i >= 0 && node != null; --i) {
                int multiCharArrayScanPos;
                if (s.charAt(i) == '.' && node != this._root) {
                    lastSubTerminalNode = node;
                }
                if ((node = node.findOrAddChild(this, s.charAt(i), false)) == null || !node.isMultiCharNode()) continue;
                int innerScanPos = i - 1;
                for (multiCharArrayScanPos = node.getMultiCharArray().length - 1; innerScanPos >= 0 && multiCharArrayScanPos >= 0 && s.charAt(innerScanPos) == node.getMultiCharArray()[multiCharArrayScanPos]; --innerScanPos, --multiCharArrayScanPos) {
                }
                if (multiCharArrayScanPos == -1) {
                    if (innerScanPos == -1) {
                        return node.isTerminalNode() ? node : null;
                    }
                    i = innerScanPos + 1;
                    continue;
                }
                node = null;
                break;
            }
            if (node == null && lastSubTerminalNode != null && lastSubTerminalNode.isSuperNode()) {
                node = lastSubTerminalNode;
            }
            if (node != null) {
                return node.isTerminalNode() ? node : null;
            }
        }
        return null;
    }

    @Test
    public void simpleTest() throws Exception {
        int ipAddress = IPAddressUtils.IPV4AddressStrToInteger("68.178.211.35");
        this.cacheIPAddressForHost("www.matlockpark.com", ipAddress, 1226959057707L, "matlockpark.com");
        DNSResult result = this.getIPAddressForHost("www.matlockpark.com");
        Assert.assertTrue((boolean)result.getCannonicalName().equals("matlockpark.com"));
        Assert.assertTrue((result.getIPAddress() == ipAddress ? 1 : 0) != 0);
        Assert.assertTrue((result.getTTL() == 1226959057707L ? 1 : 0) != 0);
    }

    public synchronized void loadTree(InputStream inputStream, LoadFilter loadFilter) throws IOException {
        int lineCount = 0;
        this.clear();
        BufferedReader lineReader = new BufferedReader(new InputStreamReader(inputStream), 1024000);
        String line = null;
        while ((line = lineReader.readLine()) != null) {
            try {
                String[] elements = line.split(",");
                if (elements.length >= 4) {
                    String hostName = elements[0];
                    String ipAddress = elements[1].substring(1);
                    long ttl = Long.parseLong(elements[2]);
                    String cname = null;
                    if (!elements[3].equals("null")) {
                        cname = elements[3];
                    }
                    long lastTouched = -1L;
                    if (elements.length > 5) {
                        lastTouched = Long.parseLong(elements[4]);
                    }
                    int ipAddressInteger = IPAddressUtils.IPV4AddressStrToInteger(ipAddress);
                    if (loadFilter != null) {
                        hostName = loadFilter.validateName(hostName);
                    }
                    if (loadFilter == null || loadFilter.loadItem(hostName, ipAddress, cname, ttl, lastTouched)) {
                        this.cacheIPAddressForHost(hostName, ipAddressInteger, ttl, cname);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            }
            if (++lineCount % 100000 != 0) continue;
            LOG.info((Object)("Processed " + lineCount + " lines"));
        }
        LOG.info((Object)("Processed a total of:" + lineCount + " lines"));
    }

    public synchronized void dumpNameTree(OutputStream outputStream, NodeDumpFilter filter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream));
        this.dumpNode(printWriter, this._root, filter);
    }

    public synchronized void dumpIPAddressTree(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream));
        this.dumpIPNode(printWriter, this._ipRoot);
    }

    private synchronized void collectTerminalNodes(Node node, List<Node> terminalNodeVector) throws IOException {
        if (node.isTerminalNode()) {
            terminalNodeVector.add(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.collectTerminalNodes(node.getChildAt(i), terminalNodeVector);
        }
    }

    public synchronized void collectTerminalIPNodes(List<Node> terminalNodeVector) {
        try {
            this.collectTerminalNodes(this._ipRoot, terminalNodeVector);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void collectTerminalNodes(List<Node> terminalNodeVector) {
        try {
            this.collectTerminalNodes(this._root, terminalNodeVector);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void dumpNode(PrintWriter printWriter, Node node, NodeDumpFilter filter) throws IOException {
        if (node.isTerminalNode() && (filter == null || filter.dumpTerminalNode(node))) {
            printWriter.append(node.getFullName());
            printWriter.append(",");
            try {
                printWriter.append(IPAddressUtils.IntegerToInetAddress(node.getIPAddress()).toString());
            }
            catch (UnknownHostException e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            }
            printWriter.append(",");
            printWriter.append(Long.toString(node.getTimeToLive()));
            printWriter.append(",");
            if (node._cannonicalName != null) {
                printWriter.append(node._cannonicalName);
            } else {
                printWriter.append("null");
            }
            printWriter.append(",");
            printWriter.append(Long.toString(node.getLastTouchedTime()));
            printWriter.append("\n");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.dumpNode(printWriter, node.getChildAt(i), filter);
        }
    }

    void dumpIPNode(PrintWriter printWriter, Node node) throws IOException {
        if (node.isTerminalNode()) {
            printWriter.append(node.getFullName());
            printWriter.append(",");
            printWriter.append(node.getCannonicalName());
            printWriter.append("\n");
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.dumpIPNode(printWriter, node.getChildAt(i));
        }
    }

    @Test
    public void validateDumpCode() throws Exception {
        this.addNameNode("www.feeds.feedburner.com");
        this.addNameNode("pictures.google.com");
        this.addNameNode("pictures2.google.com");
        this.addNameNode("gmail.google.com");
        this.addNameNode("foobar.google.com");
        Assert.assertTrue((this.findNode("feeds.feedburner.com") == null ? 1 : 0) != 0);
        Assert.assertTrue((this.findNode("www.feeds.feedburner.com") != null ? 1 : 0) != 0);
        Assert.assertTrue((this.findNode("pictures.google.com") != null ? 1 : 0) != 0);
        Assert.assertTrue((this.findNode("pictures2.google.com") != null ? 1 : 0) != 0);
        Assert.assertTrue((this.findNode("gmail.google.com") != null ? 1 : 0) != 0);
        Assert.assertTrue((this.findNode("foobar.google.com") != null ? 1 : 0) != 0);
        this.dumpNameTree(System.out, null);
    }

    @Test
    public void validateTrieCode() throws Exception {
        URL resourceURL = ClassLoader.getSystemResource("urls.txt");
        if (resourceURL == null) {
            throw new FileNotFoundException();
        }
        HashSet hostSet = new HashSet();
        for (int pass = 0; pass < 1; ++pass) {
            String line;
            System.out.println("running pass:" + pass);
            InputStream stream = resourceURL.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            int lineCount = 0;
            while ((line = reader.readLine()) != null) {
                try {
                    URL url = new URL(line);
                    if (url.getHost() != null && url.getHost().length() != 0) {
                        if (pass == 0) {
                            this.cacheIPAddressForHost(url.getHost(), url.getHost().hashCode(), System.currentTimeMillis() + 5000L + (long)((int)(Math.random() * 30000.0)), Integer.toString(url.getHost().hashCode()));
                        } else {
                            Node node = this.findNode(url.getHost());
                            if (node != null) {
                                if (node.getIPAddress() != url.getHost().hashCode()) {
                                    throw new RuntimeException("Metadata Mismatch for host:" + url.getHost() + ".Excpected:" + url.getHost().hashCode() + " Got: " + node.getIPAddress());
                                }
                            } else {
                                throw new RuntimeException("Node Null! Excpected:" + url.getHost());
                            }
                        }
                    }
                    if (++lineCount % 10000 != 0) continue;
                    System.out.println("pruning mid-stream");
                    this.pruneCache();
                    System.out.println("sleeping a little while ..");
                    Thread.sleep(100L);
                    System.out.println("wokeup");
                }
                catch (MalformedURLException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("done reading entries");
        }
        System.out.println("Host Count:" + hostSet.size());
        System.out.println("Number of Nodes:" + this.numberOfNodes);
        System.out.println("Number of Nodes EQ_1:" + numberOfNodesChildEQ1);
        System.out.println("Number of Nodes LTEQ_4:" + numberOfNodesChildLTEQ4);
        System.out.println("Number of Nodes LTEQ_8:" + numberOfNodesChildLTEQ8);
        System.out.println("Number of Nodes GT_8:" + numberOfNodesChildGT8);
        while (true) {
            System.out.println("sleeping...");
            Thread.sleep(100L);
            System.out.println("pruning.. ");
            this.pruneCache();
        }
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        NIODNSCache dnsCache = new NIODNSCache();
        try {
            FileInputStream stream = new FileInputStream(file);
            long timeStart = System.currentTimeMillis();
            LOG.info((Object)"Loading Tree from Stream");
            dnsCache.loadTree(stream, null);
            long timeEnd = System.currentTimeMillis();
            LOG.info((Object)("Load took:" + (timeEnd - timeStart) + " NodeCount:" + dnsCache.getActiveNodeCount()));
            LOG.info((Object)"Pruning cache based on filter (TTL)");
            timeStart = System.currentTimeMillis();
            ByteArrayOutputStream streamOut = new ByteArrayOutputStream(0x6400000);
            dnsCache.dumpNameTree(streamOut, new NodeDumpFilter(){

                @Override
                public boolean dumpTerminalNode(Node node) {
                    return node.getTimeToLive() >= System.currentTimeMillis();
                }
            });
            timeEnd = System.currentTimeMillis();
            LOG.info((Object)("Dump took:" + (timeEnd - timeStart)));
            LOG.info((Object)"Reloading cache from stream");
            timeStart = System.currentTimeMillis();
            dnsCache = new NIODNSCache();
            dnsCache.loadTree(new ByteArrayInputStream(streamOut.toByteArray()), null);
            timeEnd = System.currentTimeMillis();
            LOG.info((Object)("Reload took:" + (timeEnd - timeStart) + "NodeCount:" + dnsCache.getActiveNodeCount()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface NodeDumpFilter {
        public boolean dumpTerminalNode(Node var1);
    }

    public static interface LoadFilter {
        public String validateName(String var1);

        public boolean loadItem(String var1, String var2, String var3, long var4, long var6);
    }

    public static class Node {
        private static final int GROWTH_FACTOR = 1;
        private char _nodeChar;
        private char[] _nodeCharArray;
        private long _expireTime = 0L;
        private int _flags = 0;
        private int _count = 0;
        private Object _children;
        private int _ipAddress = 0;
        private String _cannonicalName = null;
        private Node _parent = null;
        private long _lastTouched = -1L;
        public static final short Flag_Is_RootNode = 1;
        public static final short Flag_Is_TerminalNode = 2;
        public static final short Flag_Is_SuperNode = 4;
        public static final short Flag_Is_MultiCharNode = 8;
        public static final short Flag_NEXT_AVAILABLE_BIT_POS = 4;

        private Node() {
            this._parent = null;
            this._flags = 1;
        }

        public boolean isRootNode() {
            return (this._flags & 1) != 0;
        }

        public Node getParentNode() {
            return this._parent;
        }

        public Node(Node parent, char nodeChar, int flags) {
            ++numberOfNodesChildEQ1;
            this._nodeChar = nodeChar;
            this._flags = (short)flags;
            this._parent = parent;
        }

        public final char getNodeChar() {
            return this._nodeChar;
        }

        public final char[] getMultiCharArray() {
            return this._nodeCharArray;
        }

        public final boolean isTerminalNode() {
            return (this._flags & 2) != 0;
        }

        public final void markAsTerminalNode() {
            this._flags |= 2;
        }

        public final boolean isSuperNode() {
            return (this._flags & 4) != 0;
        }

        public final void markAsSuperNode() {
            this._flags |= 4;
        }

        public final boolean isMultiCharNode() {
            return (this._flags & 8) != 0;
        }

        public final void setFlag(short flag) {
            this._flags |= flag;
        }

        public final void clearFlag(short flag) {
            this._flags &= ~flag;
        }

        public final boolean isFlagSet(short flag) {
            return (this._flags & flag) != 0;
        }

        public final long getTimeToLive() {
            return this._expireTime;
        }

        public final void setTimeToLive(long ttl) {
            this._expireTime = ttl;
        }

        public final void setLastTouchedTime(long timeInMilliseconds) {
            this._lastTouched = timeInMilliseconds;
        }

        public final long getLastTouchedTime() {
            return this._lastTouched;
        }

        public final void setIPAddress(int address) {
            this._ipAddress = address;
        }

        public final int getIPAddress() {
            return this._ipAddress;
        }

        public String getCannonicalName() {
            return this._cannonicalName;
        }

        public String getFullName() {
            StringBuffer nameOut = new StringBuffer();
            Node currentNode = this;
            while (!currentNode.isRootNode()) {
                if (currentNode.isMultiCharNode()) {
                    nameOut.append(currentNode.getMultiCharArray());
                }
                nameOut.append(currentNode.getNodeChar());
                currentNode = currentNode.getParentNode();
            }
            return nameOut.toString();
        }

        public final int compareTo(char c) {
            if (this._nodeChar < c) {
                return -1;
            }
            if (this._nodeChar > c) {
                return 1;
            }
            return 0;
        }

        public final int getChildCount() {
            return this._count;
        }

        public final Node getChildAt(int index) {
            return this._count == 1 ? (Node)this._children : ((Node[])this._children)[index];
        }

        public final void removeChildAt(int index) {
            if (index >= this._count) {
                throw new RuntimeException("Invalid Index");
            }
            if (this._count == 1) {
                this._children = null;
            } else {
                int rightOfIndexCount = this._count - (index + 1);
                if (rightOfIndexCount > 0) {
                    if (this._count > 2) {
                        System.arraycopy(this._children, index + 1, this._children, index, rightOfIndexCount);
                    } else {
                        this._children = ((Node[])this._children)[1];
                    }
                } else if (this._count == 2) {
                    this._children = ((Node[])this._children)[0];
                }
            }
            --this._count;
        }

        public final Node findOrAddChild(NIODNSCache cacheObject, char nodeChar, boolean addChild) {
            int itemPosition = -1;
            if (this._count == 1) {
                if (((Node)this._children).getNodeChar() == nodeChar) {
                    itemPosition = 0;
                } else if (((Node)this._children).getNodeChar() < nodeChar) {
                    itemPosition = -2;
                }
            } else if (this._count > 1) {
                itemPosition = Node.binarySearch((Node[])this._children, 0, this._count, nodeChar);
            }
            if (itemPosition < 0 && addChild) {
                Node newNode = new Node(this, nodeChar, 0);
                cacheObject.numberOfNodes++;
                itemPosition = Math.abs(itemPosition + 1);
                if (this._count == 0) {
                    this._children = newNode;
                } else {
                    Node[] copyArray;
                    int leftCopyItems = itemPosition;
                    int rightCopyItems = this._count - itemPosition;
                    Node[] nodeArray = copyArray = this._count == 1 ? null : (Node[])this._children;
                    if (this._count == 1 || this._count == ((Node[])this._children).length) {
                        if (this._count == 1) {
                            --numberOfNodesChildEQ1;
                            ++numberOfNodesChildLTEQ4;
                        } else if (this._count == 4) {
                            --numberOfNodesChildLTEQ4;
                            ++numberOfNodesChildLTEQ8;
                        } else if (this._count == 8) {
                            --numberOfNodesChildLTEQ8;
                            ++numberOfNodesChildGT8;
                        }
                        int growAmount = (this._count / 1 + 1) * 1;
                        copyArray = new Node[growAmount];
                    }
                    if (leftCopyItems != 0 && copyArray != null) {
                        if (this._count == 1) {
                            copyArray[0] = (Node)this._children;
                        } else {
                            System.arraycopy(this._children, 0, copyArray, 0, leftCopyItems);
                        }
                    }
                    if (rightCopyItems != 0) {
                        if (this._count == 1) {
                            copyArray[1] = (Node)this._children;
                        } else {
                            System.arraycopy(this._children, itemPosition, copyArray, itemPosition + 1, rightCopyItems);
                        }
                    }
                    this._children = copyArray;
                    ((Node[])this._children)[itemPosition] = newNode;
                }
                ++this._count;
            }
            if (itemPosition >= 0) {
                return this._count == 1 ? (Node)this._children : ((Node[])this._children)[itemPosition];
            }
            return null;
        }

        private static int binarySearch(Node[] a, int fromIndex, int toIndex, char key) {
            int low = fromIndex;
            int high = toIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                Node midVal = a[mid];
                int cmp = midVal.compareTo(key);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public void markAsMultiCharNode(char[] s, int startOffset, int length) {
            if (length == 0) {
                throw new RuntimeException();
            }
            this._flags |= 8;
            this._nodeCharArray = new char[length];
            System.arraycopy(s, startOffset, this._nodeCharArray, 0, length);
        }

        public Node splitMultiCharNodeAt(NIODNSCache cacheObject, int splitIdx) {
            Node newIntermediateNode = new Node(this, this._nodeCharArray[splitIdx], 0);
            cacheObject.numberOfNodes++;
            newIntermediateNode._ipAddress = this._ipAddress;
            newIntermediateNode._expireTime = this._expireTime;
            newIntermediateNode._cannonicalName = this._cannonicalName;
            this._ipAddress = 0;
            newIntermediateNode._flags = (short)(this._flags & 0xFFFFFFF7);
            this._flags = 0;
            this._cannonicalName = null;
            int leftOfSplitLength = splitIdx;
            int rightOfSplitLength = this._nodeCharArray.length - splitIdx - 1;
            if (leftOfSplitLength != 0) {
                newIntermediateNode.markAsMultiCharNode(this._nodeCharArray, 0, leftOfSplitLength);
            }
            if (rightOfSplitLength != 0) {
                char[] array = new char[rightOfSplitLength];
                System.arraycopy(this._nodeCharArray, splitIdx + 1, array, 0, rightOfSplitLength);
                this._nodeCharArray = array;
                this._flags |= 8;
            } else {
                this._nodeCharArray = null;
                this._flags &= 0xFFFFFFF7;
            }
            newIntermediateNode._children = this._children;
            newIntermediateNode._count = this._count;
            for (int i = 0; i < newIntermediateNode.getChildCount(); ++i) {
                newIntermediateNode.getChildAt((int)i)._parent = newIntermediateNode;
            }
            this._children = newIntermediateNode;
            this._count = 1;
            return newIntermediateNode;
        }
    }

    private static final class TreePosition {
        private Node _node;
        private int _index;

        TreePosition(Node node, int index) {
            this._node = node;
            this._index = index;
        }

        public final Node getNode() {
            return this._node;
        }

        public final int getIndex() {
            return this._index;
        }

        public final void setIndex(int index) {
            this._index = index;
        }

        public final Node resolve() {
            if (this._index < this._node.getChildCount()) {
                return this._node.getChildAt(this._index);
            }
            return null;
        }
    }

    public static class DNSResult {
        int _ipV4Address;
        long _ttl;
        String _cName;

        DNSResult(int ipAddress, long ipAddressTTL, String cName) {
            this._ipV4Address = ipAddress;
            this._ttl = ipAddressTTL;
            this._cName = cName;
        }

        public int getIPAddress() {
            return this._ipV4Address;
        }

        public long getTTL() {
            return this._ttl;
        }

        public String getCannonicalName() {
            return this._cName;
        }
    }
}

