/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.commoncrawl.io.internal.NIOBufferList;

public class NIOStreamDecoder
extends Reader {
    private volatile boolean isOpen = true;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private Charset cs;
    private CharsetDecoder decoder;
    private ByteBuffer bb;
    private NIOBufferList ch;

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    @Override
    public int read() throws IOException {
        return this.read0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.haveLeftoverChar) {
                this.haveLeftoverChar = false;
                return this.leftoverChar;
            }
            char[] cb = new char[2];
            int n = this.read(cb, 0, 2);
            switch (n) {
                case -1: {
                    return -1;
                }
                case 2: {
                    this.leftoverChar = cb[1];
                    this.haveLeftoverChar = true;
                }
                case 1: {
                    return cb[0];
                }
            }
            assert (false) : n;
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int offset, int length) throws IOException {
        int off = offset;
        int len = length;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int n = 0;
            if (this.haveLeftoverChar) {
                cbuf[off] = this.leftoverChar;
                ++off;
                this.haveLeftoverChar = false;
                n = 1;
                if (--len == 0 || !this.implReady()) {
                    return n;
                }
            }
            if (len == 1) {
                int c = this.read0();
                if (c == -1) {
                    return n == 0 ? -1 : n;
                }
                cbuf[off] = (char)c;
                return n + 1;
            }
            return n + this.implRead(cbuf, off, off + len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.haveLeftoverChar || this.implReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    NIOStreamDecoder(NIOBufferList ch, CharsetDecoder dec) throws IOException {
        this.ch = ch;
        this.decoder = dec;
        this.cs = dec.charset();
        this.bb = ch.read();
    }

    private int readBytes() throws IOException {
        try {
            if (this.bb.remaining() != 0) {
                this.ch.putBack(this.bb);
            }
            this.bb = null;
            this.bb = this.ch.read(8);
        }
        catch (IOException e) {
            this.bb = null;
        }
        if (this.bb != null) {
            return this.bb.remaining();
        }
        return -1;
    }

    int implRead(char[] cbuf, int off, int end) throws IOException {
        assert (end - off > 1);
        CharBuffer cb = CharBuffer.wrap(cbuf, off, end - off);
        if (cb.position() != 0) {
            cb = cb.slice();
        }
        boolean eof = false;
        while (true) {
            CoderResult cr;
            if ((cr = this.decoder.decode(this.bb, cb, eof)).isUnderflow()) {
                if (eof || !cb.hasRemaining() || cb.position() > 0 && !this.inReady()) break;
                int n = this.readBytes();
                if (n >= 0) continue;
                eof = true;
                if (cb.position() == 0 && (this.bb == null || !this.bb.hasRemaining())) break;
                this.decoder.reset();
                continue;
            }
            if (cr.isOverflow()) {
                assert (cb.position() > 0);
                break;
            }
            cr.throwException();
        }
        if (eof) {
            this.decoder.reset();
        }
        if (cb.position() == 0) {
            if (eof) {
                return -1;
            }
            assert (false);
        }
        return cb.position();
    }

    String encodingName() {
        return this.cs.name();
    }

    private boolean inReady() {
        return this.ch != null && this.ch.isDataAvailable();
    }

    boolean implReady() {
        return this.bb.hasRemaining() || this.inReady();
    }

    void implClose() throws IOException {
        if (this.bb != null) {
            this.bb = null;
        }
    }
}

