/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.commoncrawl.io.internal.NIOBufferList;

public class NIOStreamEncoder
extends Writer {
    private volatile boolean isOpen = true;
    private Charset cs;
    private CharsetEncoder encoder;
    private ByteBuffer bb;
    private NIOBufferList ch;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private CharBuffer lcb = null;

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException("Stream closed");
            }
            this.implFlushBuffer();
        }
    }

    @Override
    public void write(int c) throws IOException {
        char[] cbuf = new char[]{(char)c};
        this.write(cbuf, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.implWrite(cbuf, off, len);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cbuf = new char[len];
        str.getChars(off, off + len, cbuf, 0);
        this.write(cbuf, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.implFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    public NIOStreamEncoder(NIOBufferList ch, CharsetEncoder enc) throws IOException {
        this.ch = ch;
        this.cs = enc.charset();
        this.encoder = enc;
        this.bb = ch.allocateBuffer();
    }

    private void writeBytes() throws IOException {
        int rem;
        int lim = this.bb.limit();
        int pos = this.bb.position();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem > 0) {
            this.ch.write(this.bb);
            this.bb = this.ch.allocateBuffer();
        } else {
            this.bb.clear();
        }
    }

    private void flushLeftoverChar(CharBuffer cb, boolean endOfInput) throws IOException {
        if (!this.haveLeftoverChar && !endOfInput) {
            return;
        }
        if (this.lcb == null) {
            this.lcb = CharBuffer.allocate(2);
        } else {
            this.lcb.clear();
        }
        if (this.haveLeftoverChar) {
            this.lcb.put(this.leftoverChar);
        }
        if (cb != null && cb.hasRemaining()) {
            this.lcb.put(cb.get());
        }
        this.lcb.flip();
        while (this.lcb.hasRemaining() || endOfInput) {
            CoderResult cr = this.encoder.encode(this.lcb, this.bb, endOfInput);
            if (cr.isUnderflow()) {
                if (!this.lcb.hasRemaining()) break;
                this.leftoverChar = this.lcb.get();
                if (cb != null && cb.hasRemaining()) {
                    this.flushLeftoverChar(cb, endOfInput);
                }
                return;
            }
            if (cr.isOverflow()) {
                assert (this.bb.position() > 0);
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
        this.haveLeftoverChar = false;
    }

    void implWrite(char[] cbuf, int off, int len) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
        if (this.haveLeftoverChar) {
            this.flushLeftoverChar(cb, false);
        }
        while (cb.hasRemaining()) {
            CoderResult cr = this.encoder.encode(cb, this.bb, false);
            if (cr.isUnderflow()) {
                assert (cb.remaining() <= 1) : cb.remaining();
                if (cb.remaining() != 1) break;
                this.haveLeftoverChar = true;
                this.leftoverChar = cb.get();
                break;
            }
            if (cr.isOverflow()) {
                assert (this.bb.position() > 0);
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
    }

    void implFlushBuffer() throws IOException {
        if (this.bb.position() > 0) {
            this.writeBytes();
        }
    }

    void implFlush() throws IOException {
        this.implFlushBuffer();
    }

    void implClose() throws IOException {
        this.flushLeftoverChar(null, true);
        try {
            CoderResult cr;
            while (!(cr = this.encoder.flush(this.bb)).isUnderflow()) {
                if (cr.isOverflow()) {
                    assert (this.bb.position() > 0);
                    this.writeBytes();
                    continue;
                }
                cr.throwException();
            }
            if (this.bb.position() > 0) {
                this.writeBytes();
            }
        }
        catch (IOException x) {
            this.encoder.reset();
            throw x;
        }
    }

    String encodingName() {
        return this.cs.name();
    }
}

