/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.ImmutableBuffer;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class ParseOutput
extends RPCStruct<ParseOutput>
implements Writable {
    public static final int Field_NORMALIZEDMIMETYPE = 3;
    public static final int Field_HOSTIPADDRESS = 4;
    public static final int Field_FETCHTIME = 5;
    public static final int Field_HEADERS = 8;
    public static final int Field_RAWCONTENT = 9;
    static final int FieldID_MAX = 9;
    private BitSet __validFields = new BitSet(10);
    private TextBytes normalizedMimeType = new TextBytes();
    private TextBytes hostIPAddress = new TextBytes();
    private long fetchTime;
    private TextBytes headers = new TextBytes();
    private FlexBuffer rawContent = new FlexBuffer();

    public static ParseOutput newInstance(Configuration conf) {
        return (ParseOutput)ReflectionUtils.newInstance(ParseOutput.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final ParseOutput setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final ParseOutput setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public TextBytes getNormalizedMimeTypeAsTextBytes() {
        return this.normalizedMimeType;
    }

    public String getNormalizedMimeType() {
        return this.normalizedMimeType.toString();
    }

    public ParseOutput setNormalizedMimeType(String normalizedMimeType) {
        this.__validFields.set(3);
        this.normalizedMimeType.set(normalizedMimeType);
        return this;
    }

    public TextBytes getHostIPAddressAsTextBytes() {
        return this.hostIPAddress;
    }

    public String getHostIPAddress() {
        return this.hostIPAddress.toString();
    }

    public ParseOutput setHostIPAddress(String hostIPAddress) {
        this.__validFields.set(4);
        this.hostIPAddress.set(hostIPAddress);
        return this;
    }

    public long getFetchTime() {
        return this.fetchTime;
    }

    public ParseOutput setFetchTime(long fetchTime) {
        this.__validFields.set(5);
        this.fetchTime = fetchTime;
        return this;
    }

    public TextBytes getHeadersAsTextBytes() {
        return this.headers;
    }

    public String getHeaders() {
        return this.headers.toString();
    }

    public ParseOutput setHeaders(String headers) {
        this.__validFields.set(8);
        this.headers.set(headers);
        return this;
    }

    public ImmutableBuffer getRawContent() {
        return new ImmutableBuffer(this.rawContent);
    }

    public ParseOutput setRawContent(FlexBuffer rawContent) {
        this.__validFields.set(9);
        this.rawContent = rawContent;
        return this;
    }

    public ParseOutput setRawContent(Buffer rawContent, boolean shared) {
        this.__validFields.set(9);
        this.rawContent = new FlexBuffer(rawContent.get(), 0, rawContent.getCount(), shared);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "normalizedMimeType", 3);
            encoder.writeTextBytes(output, this.normalizedMimeType);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "hostIPAddress", 4);
            encoder.writeTextBytes(output, this.hostIPAddress);
        }
        if (this.__validFields.get(5)) {
            encoder.beginField(output, "fetchTime", 5);
            encoder.writeLong(output, this.fetchTime);
        }
        if (this.__validFields.get(8)) {
            encoder.beginField(output, "headers", 8);
            encoder.writeTextBytes(output, this.headers);
        }
        if (this.__validFields.get(9)) {
            encoder.beginField(output, "rawContent", 9);
            encoder.writeFlexBuffer(output, this.rawContent);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.normalizedMimeType);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    decoder.readTextBytes(input, this.hostIPAddress);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    this.fetchTime = decoder.readLong(input);
                    break;
                }
                case 8: {
                    this.__validFields.set(8);
                    decoder.readTextBytes(input, this.headers);
                    break;
                }
                case 9: {
                    this.__validFields.set(9);
                    decoder.readFlexBuffer(input, this.rawContent);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.normalizedMimeType.clear();
        this.hostIPAddress.clear();
        this.fetchTime = 0L;
        this.headers.clear();
        this.rawContent.reset();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof ParseOutput)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ParseOutput peer = (ParseOutput)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(3) && !(ret = this.normalizedMimeType.equals(peer.normalizedMimeType))) {
            return ret;
        }
        if (this.__validFields.get(4) && !(ret = this.hostIPAddress.equals(peer.hostIPAddress))) {
            return ret;
        }
        if (this.__validFields.get(5)) {
            boolean bl = ret = this.fetchTime == peer.fetchTime;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(8) && !(ret = this.headers.equals(peer.headers))) {
            return ret;
        }
        if (this.__validFields.get(9) && !(ret = this.rawContent.equals(peer.rawContent))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        ParseOutput other = new ParseOutput();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(3)) {
            other.normalizedMimeType = (TextBytes)this.normalizedMimeType.clone();
        }
        if (this.__validFields.get(4)) {
            other.hostIPAddress = (TextBytes)this.hostIPAddress.clone();
        }
        if (this.__validFields.get(5)) {
            other.fetchTime = this.fetchTime;
        }
        if (this.__validFields.get(8)) {
            other.headers = (TextBytes)this.headers.clone();
        }
        if (this.__validFields.get(9)) {
            other.rawContent = (FlexBuffer)this.rawContent.clone();
        }
        return other;
    }

    @Override
    public final void merge(ParseOutput peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(3)) {
            this.normalizedMimeType = (TextBytes)peer.normalizedMimeType.clone();
        }
        if (peer.__validFields.get(4)) {
            this.hostIPAddress = (TextBytes)peer.hostIPAddress.clone();
        }
        if (peer.__validFields.get(5)) {
            this.fetchTime = peer.fetchTime;
        }
        if (peer.__validFields.get(8)) {
            this.headers = (TextBytes)peer.headers.clone();
        }
        if (peer.__validFields.get(9)) {
            this.rawContent = (FlexBuffer)peer.rawContent.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hash(this.normalizedMimeType.getBytes(), this.normalizedMimeType.getOffset(), this.normalizedMimeType.getLength(), result);
        result = MurmurHash.hash(this.hostIPAddress.getBytes(), this.hostIPAddress.getOffset(), this.hostIPAddress.getLength(), result);
        result = MurmurHash.hashLong(this.fetchTime, result);
        result = MurmurHash.hash(this.headers.getBytes(), this.headers.getOffset(), this.headers.getLength(), result);
        result = MurmurHash.hash(this.rawContent.get(), this.rawContent.getOffset(), this.rawContent.getCount(), result);
        return result;
    }
}

