/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.protocol.shared.ArcFileHeaderItem;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.ImmutableBuffer;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class CacheItem
extends RPCStruct<CacheItem>
implements Writable {
    public static final int Field_URL = 1;
    public static final int Field_URLFINGERPRINT = 2;
    public static final int Field_SOURCE = 3;
    public static final int Field_FLAGS = 4;
    public static final int Field_FINALURL = 5;
    public static final int Field_HEADERITEMS = 6;
    public static final int Field_CONTENT = 7;
    static final int FieldID_MAX = 7;
    private BitSet __validFields = new BitSet(8);
    private TextBytes url = new TextBytes();
    private long urlFingerprint;
    private byte source;
    private int flags;
    private TextBytes finalURL = new TextBytes();
    private ArrayList<ArcFileHeaderItem> headerItems = new ArrayList();
    private FlexBuffer content = new FlexBuffer();

    public static CacheItem newInstance(Configuration conf) {
        return (CacheItem)ReflectionUtils.newInstance(CacheItem.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final CacheItem setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final CacheItem setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public TextBytes getUrlAsTextBytes() {
        return this.url;
    }

    public String getUrl() {
        return this.url.toString();
    }

    public CacheItem setUrl(String url) {
        this.__validFields.set(1);
        this.url.set(url);
        return this;
    }

    public long getUrlFingerprint() {
        return this.urlFingerprint;
    }

    public CacheItem setUrlFingerprint(long urlFingerprint) {
        this.__validFields.set(2);
        this.urlFingerprint = urlFingerprint;
        return this;
    }

    public byte getSource() {
        return this.source;
    }

    public CacheItem setSource(byte source) {
        this.__validFields.set(3);
        this.source = source;
        return this;
    }

    public int getFlags() {
        return this.flags;
    }

    public CacheItem setFlags(int flags) {
        this.__validFields.set(4);
        this.flags = flags;
        return this;
    }

    public TextBytes getFinalURLAsTextBytes() {
        return this.finalURL;
    }

    public String getFinalURL() {
        return this.finalURL.toString();
    }

    public CacheItem setFinalURL(String finalURL) {
        this.__validFields.set(5);
        this.finalURL.set(finalURL);
        return this;
    }

    public ArrayList<ArcFileHeaderItem> getHeaderItems() {
        return this.headerItems;
    }

    public CacheItem setHeaderItems(ArrayList<ArcFileHeaderItem> headerItems) {
        this.__validFields.set(6);
        this.headerItems = headerItems;
        return this;
    }

    public ImmutableBuffer getContent() {
        return new ImmutableBuffer(this.content);
    }

    public CacheItem setContent(FlexBuffer content) {
        this.__validFields.set(7);
        this.content = content;
        return this;
    }

    public CacheItem setContent(Buffer content, boolean shared) {
        this.__validFields.set(7);
        this.content = new FlexBuffer(content.get(), 0, content.getCount(), shared);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty;
        boolean bl = isDirty = !this.__validFields.isEmpty();
        if (!isDirty && !isDirty) {
            isDirty = this.headerItems.size() != 0;
        }
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "url", 1);
            encoder.writeTextBytes(output, this.url);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "urlFingerprint", 2);
            encoder.writeLong(output, this.urlFingerprint);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "source", 3);
            encoder.writeByte(output, this.source);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "flags", 4);
            encoder.writeInt(output, this.flags);
        }
        if (this.__validFields.get(5)) {
            encoder.beginField(output, "finalURL", 5);
            encoder.writeTextBytes(output, this.finalURL);
        }
        if (this.headerItems.size() != 0) {
            this.__validFields.set(6);
            encoder.beginField(output, "headerItems", 6);
            int len1 = this.headerItems.size();
            encoder.writeInt(output, len1);
            for (int vidx1 = 0; vidx1 < len1; ++vidx1) {
                ArcFileHeaderItem e1 = this.headerItems.get(vidx1);
                e1.serialize(output, encoder);
            }
        } else {
            this.__validFields.clear(6);
        }
        if (this.__validFields.get(7)) {
            encoder.beginField(output, "content", 7);
            encoder.writeFlexBuffer(output, this.content);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        block9: while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    decoder.readTextBytes(input, this.url);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    this.urlFingerprint = decoder.readLong(input);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    this.source = decoder.readByte(input);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    this.flags = decoder.readInt(input);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    decoder.readTextBytes(input, this.finalURL);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    int itemCount1 = decoder.readInt(input);
                    this.headerItems = new ArrayList();
                    for (int i1 = 0; i1 < itemCount1; ++i1) {
                        ArcFileHeaderItem e1 = new ArcFileHeaderItem();
                        e1.deserialize(input, decoder);
                        this.headerItems.add(e1);
                    }
                    continue block9;
                }
                case 7: {
                    this.__validFields.set(7);
                    decoder.readFlexBuffer(input, this.content);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.url.clear();
        this.urlFingerprint = 0L;
        this.source = 0;
        this.flags = 0;
        this.finalURL.clear();
        this.headerItems.clear();
        this.content.reset();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof CacheItem)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        CacheItem peer = (CacheItem)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1) && !(ret = this.url.equals(peer.url))) {
            return ret;
        }
        if (this.__validFields.get(2)) {
            boolean bl = ret = this.urlFingerprint == peer.urlFingerprint;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(3)) {
            boolean bl = ret = this.source == peer.source;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(4)) {
            boolean bl = ret = this.flags == peer.flags;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(5) && !(ret = this.finalURL.equals(peer.finalURL))) {
            return ret;
        }
        if (this.headerItems.size() != 0 && !(ret = this.headerItems.equals(peer.headerItems))) {
            return ret;
        }
        if (this.__validFields.get(7) && !(ret = this.content.equals(peer.content))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        CacheItem other = new CacheItem();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.url = (TextBytes)this.url.clone();
        }
        if (this.__validFields.get(2)) {
            other.urlFingerprint = this.urlFingerprint;
        }
        if (this.__validFields.get(3)) {
            other.source = this.source;
        }
        if (this.__validFields.get(4)) {
            other.flags = this.flags;
        }
        if (this.__validFields.get(5)) {
            other.finalURL = (TextBytes)this.finalURL.clone();
        }
        other.headerItems = new ArrayList();
        int len0 = this.headerItems.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            ArcFileHeaderItem src0 = this.headerItems.get(vidx0);
            ArcFileHeaderItem tgt0 = (ArcFileHeaderItem)src0.clone();
            other.headerItems.add(tgt0);
        }
        if (this.__validFields.get(7)) {
            other.content = (FlexBuffer)this.content.clone();
        }
        return other;
    }

    @Override
    public final void merge(CacheItem peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.url = (TextBytes)peer.url.clone();
        }
        if (peer.__validFields.get(2)) {
            this.urlFingerprint = peer.urlFingerprint;
        }
        if (peer.__validFields.get(3)) {
            this.source = peer.source;
        }
        if (peer.__validFields.get(4)) {
            this.flags = peer.flags;
        }
        if (peer.__validFields.get(5)) {
            this.finalURL = (TextBytes)peer.finalURL.clone();
        }
        int len0 = peer.headerItems.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            ArcFileHeaderItem src0 = peer.headerItems.get(vidx0);
            ArcFileHeaderItem tgt0 = (ArcFileHeaderItem)src0.clone();
            this.headerItems.add(tgt0);
        }
        if (peer.__validFields.get(7)) {
            this.content = (FlexBuffer)peer.content.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hash(this.url.getBytes(), this.url.getOffset(), this.url.getLength(), result);
        result = MurmurHash.hashLong(this.urlFingerprint, result);
        result = MurmurHash.hashInt(this.source, result);
        result = MurmurHash.hashInt(this.flags, result);
        result = MurmurHash.hash(this.finalURL.getBytes(), this.finalURL.getOffset(), this.finalURL.getLength(), result);
        result = MurmurHash.hashInt(this.headerItems.hashCode(), result);
        result = MurmurHash.hash(this.content.get(), this.content.getOffset(), this.content.getCount(), result);
        return result;
    }

    public static final class Flags {
        public static final int Flag_IsTemporaryRedirect = 1;
        public static final int Flag_IsPermanentRedirect = 2;
        public static final int Flag_IsCompressed = 4;
        public static final int Flag_WasTruncatedDuringDownload = 8;
        public static final int Flag_WasTruncatedDuringInflate = 16;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "Flag_IsTemporaryRedirect";
                }
                case 2: {
                    return "Flag_IsPermanentRedirect";
                }
                case 4: {
                    return "Flag_IsCompressed";
                }
                case 8: {
                    return "Flag_WasTruncatedDuringDownload";
                }
                case 16: {
                    return "Flag_WasTruncatedDuringInflate";
                }
            }
            return "";
        }
    }

    public static final class Source {
        public static final int WebRequest = 1;
        public static final int S3Cache = 2;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "WebRequest";
                }
                case 2: {
                    return "S3Cache";
                }
            }
            return "";
        }
    }
}

