/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class HTMLMetaTags
extends RPCStruct<HTMLMetaTags>
implements Writable {
    public static final int Field_ROBOTSFLAGS = 1;
    public static final int Field_PRAGMAS = 2;
    public static final int Field_OPTIONALREFRESHURL = 3;
    public static final int Field_OPTIONALREFRESHTIME = 4;
    public static final int Field_OTHERMETATAGS = 6;
    static final int FieldID_MAX = 6;
    private BitSet __validFields = new BitSet(7);
    private byte robotsFlags;
    private byte pragmas;
    private TextBytes optionalRefreshURL = new TextBytes();
    private int optionalRefreshTime;
    private TextBytes otherMetaTags = new TextBytes();

    public static HTMLMetaTags newInstance(Configuration conf) {
        return (HTMLMetaTags)ReflectionUtils.newInstance(HTMLMetaTags.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final HTMLMetaTags setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final HTMLMetaTags setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public byte getRobotsFlags() {
        return this.robotsFlags;
    }

    public HTMLMetaTags setRobotsFlags(byte robotsFlags) {
        this.__validFields.set(1);
        this.robotsFlags = robotsFlags;
        return this;
    }

    public byte getPragmas() {
        return this.pragmas;
    }

    public HTMLMetaTags setPragmas(byte pragmas) {
        this.__validFields.set(2);
        this.pragmas = pragmas;
        return this;
    }

    public TextBytes getOptionalRefreshURLAsTextBytes() {
        return this.optionalRefreshURL;
    }

    public String getOptionalRefreshURL() {
        return this.optionalRefreshURL.toString();
    }

    public HTMLMetaTags setOptionalRefreshURL(String optionalRefreshURL) {
        this.__validFields.set(3);
        this.optionalRefreshURL.set(optionalRefreshURL);
        return this;
    }

    public int getOptionalRefreshTime() {
        return this.optionalRefreshTime;
    }

    public HTMLMetaTags setOptionalRefreshTime(int optionalRefreshTime) {
        this.__validFields.set(4);
        this.optionalRefreshTime = optionalRefreshTime;
        return this;
    }

    public TextBytes getOtherMetaTagsAsTextBytes() {
        return this.otherMetaTags;
    }

    public String getOtherMetaTags() {
        return this.otherMetaTags.toString();
    }

    public HTMLMetaTags setOtherMetaTags(String otherMetaTags) {
        this.__validFields.set(6);
        this.otherMetaTags.set(otherMetaTags);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "robotsFlags", 1);
            encoder.writeByte(output, this.robotsFlags);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "pragmas", 2);
            encoder.writeByte(output, this.pragmas);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "optionalRefreshURL", 3);
            encoder.writeTextBytes(output, this.optionalRefreshURL);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "optionalRefreshTime", 4);
            encoder.writeVInt(output, this.optionalRefreshTime);
        }
        if (this.__validFields.get(6)) {
            encoder.beginField(output, "otherMetaTags", 6);
            encoder.writeTextBytes(output, this.otherMetaTags);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.robotsFlags = decoder.readByte(input);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    this.pragmas = decoder.readByte(input);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.optionalRefreshURL);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    this.optionalRefreshTime = decoder.readVInt(input);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    decoder.readTextBytes(input, this.otherMetaTags);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.robotsFlags = 0;
        this.pragmas = 0;
        this.optionalRefreshURL.clear();
        this.optionalRefreshTime = 0;
        this.otherMetaTags.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof HTMLMetaTags)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        HTMLMetaTags peer = (HTMLMetaTags)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.robotsFlags == peer.robotsFlags;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(2)) {
            boolean bl = ret = this.pragmas == peer.pragmas;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(3) && !(ret = this.optionalRefreshURL.equals(peer.optionalRefreshURL))) {
            return ret;
        }
        if (this.__validFields.get(4)) {
            boolean bl = ret = this.optionalRefreshTime == peer.optionalRefreshTime;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(6) && !(ret = this.otherMetaTags.equals(peer.otherMetaTags))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        HTMLMetaTags other = new HTMLMetaTags();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.robotsFlags = this.robotsFlags;
        }
        if (this.__validFields.get(2)) {
            other.pragmas = this.pragmas;
        }
        if (this.__validFields.get(3)) {
            other.optionalRefreshURL = (TextBytes)this.optionalRefreshURL.clone();
        }
        if (this.__validFields.get(4)) {
            other.optionalRefreshTime = this.optionalRefreshTime;
        }
        if (this.__validFields.get(6)) {
            other.otherMetaTags = (TextBytes)this.otherMetaTags.clone();
        }
        return other;
    }

    @Override
    public final void merge(HTMLMetaTags peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.robotsFlags = peer.robotsFlags;
        }
        if (peer.__validFields.get(2)) {
            this.pragmas = peer.pragmas;
        }
        if (peer.__validFields.get(3)) {
            this.optionalRefreshURL = (TextBytes)peer.optionalRefreshURL.clone();
        }
        if (peer.__validFields.get(4)) {
            this.optionalRefreshTime = peer.optionalRefreshTime;
        }
        if (peer.__validFields.get(6)) {
            this.otherMetaTags = (TextBytes)peer.otherMetaTags.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashInt(this.robotsFlags, result);
        result = MurmurHash.hashInt(this.pragmas, result);
        result = MurmurHash.hash(this.optionalRefreshURL.getBytes(), this.optionalRefreshURL.getOffset(), this.optionalRefreshURL.getLength(), result);
        result = MurmurHash.hashInt(this.optionalRefreshTime, result);
        result = MurmurHash.hash(this.otherMetaTags.getBytes(), this.otherMetaTags.getOffset(), this.otherMetaTags.getLength(), result);
        return result;
    }

    public static final class Pragmas {
        public static final int NO_CACHE = 1;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "NO_CACHE";
                }
            }
            return "";
        }
    }

    public static final class RobotsFlags {
        public static final int ALL = 1;
        public static final int NO_INDEX = 2;
        public static final int NO_FOLLOW = 4;
        public static final int NO_ARCHIVE = 8;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "ALL";
                }
                case 2: {
                    return "NO_INDEX";
                }
                case 4: {
                    return "NO_FOLLOW";
                }
                case 8: {
                    return "NO_ARCHIVE";
                }
            }
            return "";
        }
    }
}

