/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class BaseConfig
extends RPCStruct<BaseConfig>
implements Writable {
    public static final int Field_FILESYSTEM = 1;
    public static final int Field_QUERYRESULTSDIR = 3;
    public static final int Field_SLAVENAME = 6;
    static final int FieldID_MAX = 6;
    private BitSet __validFields = new BitSet(7);
    private TextBytes fileSystem = new TextBytes();
    private TextBytes queryResultsDir = new TextBytes();
    private TextBytes slaveName = new TextBytes();

    public static BaseConfig newInstance(Configuration conf) {
        return (BaseConfig)ReflectionUtils.newInstance(BaseConfig.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final BaseConfig setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final BaseConfig setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public TextBytes getFileSystemAsTextBytes() {
        return this.fileSystem;
    }

    public String getFileSystem() {
        return this.fileSystem.toString();
    }

    public BaseConfig setFileSystem(String fileSystem) {
        this.__validFields.set(1);
        this.fileSystem.set(fileSystem);
        return this;
    }

    public TextBytes getQueryResultsDirAsTextBytes() {
        return this.queryResultsDir;
    }

    public String getQueryResultsDir() {
        return this.queryResultsDir.toString();
    }

    public BaseConfig setQueryResultsDir(String queryResultsDir) {
        this.__validFields.set(3);
        this.queryResultsDir.set(queryResultsDir);
        return this;
    }

    public TextBytes getSlaveNameAsTextBytes() {
        return this.slaveName;
    }

    public String getSlaveName() {
        return this.slaveName.toString();
    }

    public BaseConfig setSlaveName(String slaveName) {
        this.__validFields.set(6);
        this.slaveName.set(slaveName);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "fileSystem", 1);
            encoder.writeTextBytes(output, this.fileSystem);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "queryResultsDir", 3);
            encoder.writeTextBytes(output, this.queryResultsDir);
        }
        if (this.__validFields.get(6)) {
            encoder.beginField(output, "slaveName", 6);
            encoder.writeTextBytes(output, this.slaveName);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    decoder.readTextBytes(input, this.fileSystem);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.queryResultsDir);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    decoder.readTextBytes(input, this.slaveName);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.fileSystem.clear();
        this.queryResultsDir.clear();
        this.slaveName.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof BaseConfig)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        BaseConfig peer = (BaseConfig)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1) && !(ret = this.fileSystem.equals(peer.fileSystem))) {
            return ret;
        }
        if (this.__validFields.get(3) && !(ret = this.queryResultsDir.equals(peer.queryResultsDir))) {
            return ret;
        }
        if (this.__validFields.get(6) && !(ret = this.slaveName.equals(peer.slaveName))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        BaseConfig other = new BaseConfig();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.fileSystem = (TextBytes)this.fileSystem.clone();
        }
        if (this.__validFields.get(3)) {
            other.queryResultsDir = (TextBytes)this.queryResultsDir.clone();
        }
        if (this.__validFields.get(6)) {
            other.slaveName = (TextBytes)this.slaveName.clone();
        }
        return other;
    }

    @Override
    public final void merge(BaseConfig peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.fileSystem = (TextBytes)peer.fileSystem.clone();
        }
        if (peer.__validFields.get(3)) {
            this.queryResultsDir = (TextBytes)peer.queryResultsDir.clone();
        }
        if (peer.__validFields.get(6)) {
            this.slaveName = (TextBytes)peer.slaveName.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hash(this.fileSystem.getBytes(), this.fileSystem.getOffset(), this.fileSystem.getLength(), result);
        result = MurmurHash.hash(this.queryResultsDir.getBytes(), this.queryResultsDir.getOffset(), this.queryResultsDir.getLength(), result);
        result = MurmurHash.hash(this.slaveName.getBytes(), this.slaveName.getOffset(), this.slaveName.getLength(), result);
        return result;
    }
}

