/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.query.BaseConfig;
import org.commoncrawl.query.QueryCommon;
import org.commoncrawl.query.QueryStatus;
import org.commoncrawl.query.RemoteQueryInfo;
import org.commoncrawl.query.SlaveStatus;
import org.commoncrawl.rpc.ActorInterface;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.Channel;
import org.commoncrawl.rpc.EmptyStruct;
import org.commoncrawl.rpc.InProcessActor;
import org.commoncrawl.rpc.IncomingMessageContext;
import org.commoncrawl.rpc.OutgoingMessageContext;
import org.commoncrawl.rpc.RPCException;
import org.commoncrawl.rpc.RPCMessageDispatcher;
import org.commoncrawl.rpc.RPCServerChannel;

public interface QueryServerSlave
extends ActorInterface {
    public static final Log LOG_PRIVATE = LogFactory.getLog(QueryServerSlave.class);
    public static final ActorInterface.RPCSpecification spec = new ActorInterface.RPCSpecification("QueryServerSlave", new Dispatcher());

    public void initializeQuerySlave(IncomingMessageContext<BaseConfig, SlaveStatus> var1) throws RPCException;

    public void doQuery(IncomingMessageContext<RemoteQueryInfo, QueryStatus> var1) throws RPCException;

    public void cancelQuery(IncomingMessageContext<QueryCommon, EmptyStruct> var1) throws RPCException;

    public void heartbeatQuerySlave(IncomingMessageContext<EmptyStruct, SlaveStatus> var1) throws RPCException;

    public static class InProcessActorFactory {
        public static InProcessActor createInProcessActor(final QueryServerSlave instance, ThreadPoolExecutor executor, InProcessActor.Events optionalListener) throws IOException {
            InProcessActor actor = new InProcessActor(executor, optionalListener){

                @Override
                public void dispatch(Channel channel, InProcessActor.IncomingMessage message) throws RPCException {
                    if (message.getServiceName().equals(QueryServerSlave.spec._name)) {
                        if (message.getMethodName().equals("initializeQuerySlave")) {
                            instance.initializeQuerySlave(message);
                        }
                        if (message.getMethodName().equals("doQuery")) {
                            instance.doQuery(message);
                        }
                        if (message.getMethodName().equals("cancelQuery")) {
                            instance.cancelQuery(message);
                        }
                        if (message.getMethodName().equals("heartbeatQuerySlave")) {
                            instance.heartbeatQuerySlave(message);
                        } else {
                            LOG_PRIVATE.error((Object)("Method:" + message.getMethodName() + " Not Found"));
                        }
                    }
                }
            };
            return actor;
        }
    }

    public static class Dispatcher
    implements RPCMessageDispatcher {
        @Override
        public void dispatch(ActorInterface instance, RPCServerChannel serverChannel, String serviceId, String methodName, DataInputStream messagePayload, int requestId, Channel channel) throws RPCException {
            if (methodName.equals("initializeQuerySlave")) {
                BaseConfig input = new BaseConfig();
                SlaveStatus output = new SlaveStatus();
                try {
                    input.deserialize(messagePayload, new BinaryProtocol());
                }
                catch (IOException e) {
                    LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new RPCException(e);
                }
                IncomingMessageContext<BaseConfig, SlaveStatus> messageData = new IncomingMessageContext<BaseConfig, SlaveStatus>(channel, requestId, input, output);
                ((QueryServerSlave)instance).initializeQuerySlave(messageData);
            } else if (methodName.equals("doQuery")) {
                RemoteQueryInfo input = new RemoteQueryInfo();
                QueryStatus output = new QueryStatus();
                try {
                    input.deserialize(messagePayload, new BinaryProtocol());
                }
                catch (IOException e) {
                    LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new RPCException(e);
                }
                IncomingMessageContext<RemoteQueryInfo, QueryStatus> messageData = new IncomingMessageContext<RemoteQueryInfo, QueryStatus>(channel, requestId, input, output);
                ((QueryServerSlave)instance).doQuery(messageData);
            } else if (methodName.equals("cancelQuery")) {
                QueryCommon input = new QueryCommon();
                EmptyStruct output = EmptyStruct.getSingleton();
                try {
                    input.deserialize(messagePayload, new BinaryProtocol());
                }
                catch (IOException e) {
                    LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new RPCException(e);
                }
                IncomingMessageContext<QueryCommon, EmptyStruct> messageData = new IncomingMessageContext<QueryCommon, EmptyStruct>(channel, requestId, input, output);
                ((QueryServerSlave)instance).cancelQuery(messageData);
            } else if (methodName.equals("heartbeatQuerySlave")) {
                EmptyStruct input = EmptyStruct.getSingleton();
                SlaveStatus output = new SlaveStatus();
                IncomingMessageContext<EmptyStruct, SlaveStatus> messageData = new IncomingMessageContext<EmptyStruct, SlaveStatus>(channel, requestId, input, output);
                ((QueryServerSlave)instance).heartbeatQuerySlave(messageData);
            } else {
                LOG_PRIVATE.error((Object)("UNKNOWN METHOD NAME:" + methodName));
            }
        }
    }

    public static class BlockingStub
    extends ActorInterface.BlockingStub<AsyncStub> {
        public BlockingStub(Channel channel, EventLoop optionalEventLoop) {
            super(new AsyncStub(channel, optionalEventLoop));
        }

        public SlaveStatus initializeQuerySlave(BaseConfig input) throws RPCException {
            final CountDownLatch latch = new CountDownLatch(1);
            OutgoingMessageContext<BaseConfig, SlaveStatus> request = ((AsyncStub)this.getAsyncStub()).initializeQuerySlave(input, new OutgoingMessageContext.Callback(){

                public void requestComplete(OutgoingMessageContext request) {
                    latch.countDown();
                }
            });
            try {
                if (super.waitForResult(latch)) {
                    return (SlaveStatus)request.getOutput();
                }
                throw new RPCException("RPC Timeout");
            }
            catch (IOException e) {
                LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new RPCException(e);
            }
        }

        public QueryStatus doQuery(RemoteQueryInfo input) throws RPCException {
            final CountDownLatch latch = new CountDownLatch(1);
            OutgoingMessageContext<RemoteQueryInfo, QueryStatus> request = ((AsyncStub)this.getAsyncStub()).doQuery(input, new OutgoingMessageContext.Callback(){

                public void requestComplete(OutgoingMessageContext request) {
                    latch.countDown();
                }
            });
            try {
                if (super.waitForResult(latch)) {
                    return (QueryStatus)request.getOutput();
                }
                throw new RPCException("RPC Timeout");
            }
            catch (IOException e) {
                LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new RPCException(e);
            }
        }

        public void cancelQuery(QueryCommon input) throws RPCException {
            final CountDownLatch latch = new CountDownLatch(1);
            OutgoingMessageContext<QueryCommon, EmptyStruct> request = ((AsyncStub)this.getAsyncStub()).cancelQuery(input, new OutgoingMessageContext.Callback(){

                public void requestComplete(OutgoingMessageContext request) {
                    latch.countDown();
                }
            });
            try {
                if (super.waitForResult(latch)) {
                    return;
                }
                throw new RPCException("RPC Timeout");
            }
            catch (IOException e) {
                LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new RPCException(e);
            }
        }

        public SlaveStatus heartbeatQuerySlave() throws RPCException {
            final CountDownLatch latch = new CountDownLatch(1);
            OutgoingMessageContext<EmptyStruct, SlaveStatus> request = ((AsyncStub)this.getAsyncStub()).heartbeatQuerySlave(new OutgoingMessageContext.Callback(){

                public void requestComplete(OutgoingMessageContext request) {
                    latch.countDown();
                }
            });
            try {
                if (super.waitForResult(latch)) {
                    return (SlaveStatus)request.getOutput();
                }
                throw new RPCException("RPC Timeout");
            }
            catch (IOException e) {
                LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new RPCException(e);
            }
        }
    }

    public static class AsyncStub
    extends ActorInterface.AsyncStub {
        public AsyncStub(Channel channel, EventLoop optionalEventLoop) {
            super(channel, optionalEventLoop);
        }

        public OutgoingMessageContext<BaseConfig, SlaveStatus> initializeQuerySlave(BaseConfig input, OutgoingMessageContext.Callback<BaseConfig, SlaveStatus> callback) throws RPCException {
            OutgoingMessageContext<BaseConfig, SlaveStatus> request = new OutgoingMessageContext<BaseConfig, SlaveStatus>(QueryServerSlave.spec._name, "initializeQuerySlave", input, new SlaveStatus(), callback);
            this.getChannel().sendRequest(request);
            return request;
        }

        public OutgoingMessageContext<RemoteQueryInfo, QueryStatus> doQuery(RemoteQueryInfo input, OutgoingMessageContext.Callback<RemoteQueryInfo, QueryStatus> callback) throws RPCException {
            OutgoingMessageContext<RemoteQueryInfo, QueryStatus> request = new OutgoingMessageContext<RemoteQueryInfo, QueryStatus>(QueryServerSlave.spec._name, "doQuery", input, new QueryStatus(), callback);
            this.getChannel().sendRequest(request);
            return request;
        }

        public OutgoingMessageContext<QueryCommon, EmptyStruct> cancelQuery(QueryCommon input, OutgoingMessageContext.Callback<QueryCommon, EmptyStruct> callback) throws RPCException {
            OutgoingMessageContext<QueryCommon, EmptyStruct> request = new OutgoingMessageContext<QueryCommon, EmptyStruct>(QueryServerSlave.spec._name, "cancelQuery", input, EmptyStruct.getSingleton(), callback);
            this.getChannel().sendRequest(request);
            return request;
        }

        public OutgoingMessageContext<EmptyStruct, SlaveStatus> heartbeatQuerySlave(OutgoingMessageContext.Callback<EmptyStruct, SlaveStatus> callback) throws RPCException {
            OutgoingMessageContext<EmptyStruct, SlaveStatus> request = new OutgoingMessageContext<EmptyStruct, SlaveStatus>(QueryServerSlave.spec._name, "heartbeatQuerySlave", EmptyStruct.getSingleton(), new SlaveStatus(), callback);
            this.getChannel().sendRequest(request);
            return request;
        }
    }
}

