/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class TestQueryData
extends RPCStruct<TestQueryData>
implements Writable {
    public static final int Field_SOMEDATA = 1;
    static final int FieldID_MAX = 1;
    private BitSet __validFields = new BitSet(2);
    private TextBytes someData = new TextBytes();

    public static TestQueryData newInstance(Configuration conf) {
        return (TestQueryData)ReflectionUtils.newInstance(TestQueryData.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final TestQueryData setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final TestQueryData setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public TextBytes getSomeDataAsTextBytes() {
        return this.someData;
    }

    public String getSomeData() {
        return this.someData.toString();
    }

    public TestQueryData setSomeData(String someData) {
        this.__validFields.set(1);
        this.someData.set(someData);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "someData", 1);
            encoder.writeTextBytes(output, this.someData);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    decoder.readTextBytes(input, this.someData);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.someData.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof TestQueryData)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        TestQueryData peer = (TestQueryData)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1) && !(ret = this.someData.equals(peer.someData))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        TestQueryData other = new TestQueryData();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.someData = (TextBytes)this.someData.clone();
        }
        return other;
    }

    @Override
    public final void merge(TestQueryData peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.someData = (TextBytes)peer.someData.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hash(this.someData.getBytes(), this.someData.getOffset(), this.someData.getLength(), result);
        return result;
    }
}

