/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.rpc.Channel;
import org.commoncrawl.rpc.RPCMessageDispatcher;

public interface ActorInterface {

    public static class BlockingStub<StubType extends AsyncStub> {
        private static final int DEFAULT_RPC_TIMEOUT = 60000;
        private StubType _asyncStub;
        private int _rpcTimeout = 60000;

        public StubType getAsyncStub() {
            return this._asyncStub;
        }

        public void setRPCTimeout(int milliseconds) {
            this._rpcTimeout = milliseconds;
        }

        public int getRPCTimeout() {
            return this._rpcTimeout;
        }

        public BlockingStub(StubType asyncStub) {
            this._asyncStub = asyncStub;
        }

        protected boolean waitForResult(CountDownLatch latch) throws IOException {
            EventLoop sourceEventLoop = ((AsyncStub)this._asyncStub).getEventLoop();
            if (sourceEventLoop != null && Thread.currentThread() == sourceEventLoop.getEventThread()) {
                long timeoutTime = System.currentTimeMillis() + (long)this.getRPCTimeout();
                do {
                    sourceEventLoop.waitForIO(1L);
                } while (latch.getCount() == 1L || System.currentTimeMillis() >= timeoutTime);
            } else {
                try {
                    latch.await(this.getRPCTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return latch.getCount() == 0L;
        }
    }

    public static class AsyncStub {
        private Channel _channel;
        private EventLoop _eventLoop;

        public AsyncStub(Channel channel, EventLoop optionalEventLoop) {
            this._channel = channel;
            this._eventLoop = optionalEventLoop;
        }

        public Channel getChannel() {
            return this._channel;
        }

        public EventLoop getEventLoop() {
            return this._eventLoop;
        }
    }

    public static class RPCSpecification {
        public String _name;
        public RPCMessageDispatcher _dispatcher;

        public RPCSpecification(String name, RPCMessageDispatcher dispatcher) {
            this._name = name;
            this._dispatcher = dispatcher;
        }
    }
}

