/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOBufferListInputStream;
import org.commoncrawl.io.internal.NIOBufferListOutputStream;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.IncomingMessageContext;
import org.commoncrawl.rpc.MessageData;
import org.commoncrawl.rpc.OutgoingMessageContext;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.rpc.UnitTestStruct1;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.TextBytes;
import org.junit.Assert;
import org.junit.Test;

public class RPCFrame {
    public static final Log LOG = LogFactory.getLog(RPCFrame.class);
    static int FRAME_HEADER_SIZE = 12;
    static byte[] SIGNATURE = new byte[]{67, 67};
    static byte[] VERSION = new byte[]{48, 48};
    static int MSG_HEADER_SIZE_OFFSET = 4;
    static int MSG_PAYLOAD_SIZE_OFFSET = 8;
    static final int MSG_HEADER_FIELD_TYPE = 1;
    static final int MSG_HEADER_FIELD_SERVICE = 2;
    static final int MSG_HEADER_FIELD_METHOD = 3;
    static final int MSG_HEADER_FIELD_REQUEST_ID = 4;
    static final int MSG_HEADER_FIELD_STATUS = 5;
    static final int REQUEST_ESSENTIAL_FIELDS_MASK = 30;
    static final int RESPONSE_ESSENTIAL_FIELDS_MASK = 50;

    @Test
    public void testEncoderDecoder() throws Exception {
        NIOBufferList output = new NIOBufferList();
        NIOBufferList input = new NIOBufferList();
        NIOBufferListOutputStream outputStream = new NIOBufferListOutputStream(output);
        NIOBufferListInputStream inputStream = new NIOBufferListInputStream(input);
        Encoder encoder = new Encoder(outputStream);
        Decoder decoder = new Decoder(inputStream);
        UnitTestStruct1 inputStruct = new UnitTestStruct1();
        UnitTestStruct1 outputStruct = new UnitTestStruct1();
        inputStruct.setIntType(10);
        inputStruct.setLongType(20L);
        inputStruct.setStringType("one");
        inputStruct.setFieldDirty(4);
        inputStruct.getVectorOfStrings().add(new TextBytes("one"));
        inputStruct.getVectorOfStrings().add(new TextBytes("two"));
        inputStruct.getVectorOfStrings().add(new TextBytes("three"));
        OutgoingMessageContext<UnitTestStruct1, UnitTestStruct1> request = new OutgoingMessageContext<UnitTestStruct1, UnitTestStruct1>("testService", "testMethod", inputStruct, outputStruct, null);
        request.setRequestId(10);
        encoder.encodeRequest(request);
        while (output.available() != 0) {
            ByteBuffer buffer = output.read();
            input.getWriteBuf().put(buffer.get());
            input.flush();
            if (buffer.remaining() != 0) {
                output.putBack(buffer);
            }
            if (output.available() == 0) continue;
            Assert.assertTrue((decoder.getNextRequestFrame() == null ? 1 : 0) != 0);
        }
        IncomingFrame incomingFrame = decoder.getNextRequestFrame();
        Assert.assertTrue((incomingFrame != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)incomingFrame._service.equals("testService"));
        Assert.assertTrue((boolean)incomingFrame._method.equals("testMethod"));
        Assert.assertTrue((incomingFrame._requestId == 10 ? 1 : 0) != 0);
        Assert.assertTrue((incomingFrame._type == MSG_TYPE.REQUEST.ordinal() ? 1 : 0) != 0);
        outputStruct.deserialize(new DataInputStream(incomingFrame._payload), new BinaryProtocol());
        Assert.assertTrue((outputStruct.getIntType() == inputStruct.getIntType() ? 1 : 0) != 0);
        Assert.assertTrue((outputStruct.getLongType() == inputStruct.getLongType() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)outputStruct.getStringType().equals(inputStruct.getStringType()));
        Assert.assertTrue((outputStruct.getVectorOfStrings().size() == inputStruct.getVectorOfStrings().size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)outputStruct.getVectorOfStrings().get(0).equals(inputStruct.getVectorOfStrings().get(0)));
        Assert.assertTrue((boolean)outputStruct.getVectorOfStrings().get(1).equals(inputStruct.getVectorOfStrings().get(1)));
        Assert.assertTrue((boolean)outputStruct.getVectorOfStrings().get(2).equals(inputStruct.getVectorOfStrings().get(2)));
    }

    public static final class Decoder {
        NIOBufferListInputStream _stream;
        byte[] _lookAheadBuffer = new byte[FRAME_HEADER_SIZE];
        int _lookAheadSize = 0;
        int _headerSize = -1;
        int _payloadSize = -1;

        Decoder(NIOBufferListInputStream stream) {
            this._stream = stream;
        }

        public void reset() {
            this._lookAheadSize = 0;
            this._headerSize = -1;
            this._payloadSize = -1;
        }

        private static int readInt(byte[] fromArray, int offset) {
            int ch1 = fromArray[offset] & 0xFF;
            int ch2 = fromArray[offset + 1] & 0xFF;
            int ch3 = fromArray[offset + 2] & 0xFF;
            int ch4 = fromArray[offset + 3] & 0xFF;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }

        public IncomingFrame getNextRequestFrame() throws IOException {
            return this.getNextFrame(true);
        }

        public IncomingFrame getNextResponseFrame() throws IOException {
            return this.getNextFrame(false);
        }

        private IncomingFrame getNextFrame(boolean isRequestFrame) throws IOException {
            IncomingFrame frame = new IncomingFrame();
            try {
                if (this._lookAheadSize != FRAME_HEADER_SIZE && this._stream.available() != 0) {
                    this._lookAheadSize += this._stream.read(this._lookAheadBuffer, this._lookAheadSize, FRAME_HEADER_SIZE - this._lookAheadSize);
                }
                if (this._lookAheadSize == FRAME_HEADER_SIZE) {
                    if (this._headerSize == -1 || this._payloadSize == -1) {
                        if (this._lookAheadBuffer[0] != SIGNATURE[0] || this._lookAheadBuffer[1] != SIGNATURE[1] || this._lookAheadBuffer[2] != VERSION[0] || this._lookAheadBuffer[3] != VERSION[1]) {
                            throw new IOException("Invalid Frame Header Detected:" + this._lookAheadBuffer.toString());
                        }
                        this._headerSize = Decoder.readInt(this._lookAheadBuffer, MSG_HEADER_SIZE_OFFSET);
                        this._payloadSize = Decoder.readInt(this._lookAheadBuffer, MSG_PAYLOAD_SIZE_OFFSET);
                    }
                    if (this._stream.available() >= this._headerSize + this._payloadSize) {
                        int requiredFieldMask;
                        byte[] header = new byte[this._headerSize];
                        this._stream.read(header);
                        HeaderInputStream headerDataStream = new HeaderInputStream(header);
                        int fieldCount = headerDataStream.readByte();
                        int fieldMask = 0;
                        block15: while (fieldCount-- != 0) {
                            byte fieldId = headerDataStream.readByte();
                            HeaderOutputStream.FieldType fieldType = HeaderOutputStream.FieldType.values()[headerDataStream.readByte()];
                            fieldMask |= 1 << fieldId;
                            switch (fieldId) {
                                case 2: {
                                    frame._service = headerDataStream.readUTF();
                                    continue block15;
                                }
                                case 3: {
                                    frame._method = headerDataStream.readUTF();
                                    continue block15;
                                }
                                case 4: {
                                    frame._requestId = headerDataStream.readInt();
                                    continue block15;
                                }
                                case 5: {
                                    frame._status = headerDataStream.readByte();
                                    continue block15;
                                }
                                case 1: {
                                    frame._type = headerDataStream.readByte();
                                    continue block15;
                                }
                            }
                            int skipBytes = 0;
                            switch (fieldType) {
                                case Byte: {
                                    skipBytes = 1;
                                    break;
                                }
                                case Short: {
                                    skipBytes = 2;
                                    break;
                                }
                                case Integer: {
                                    skipBytes = 4;
                                    break;
                                }
                                case UTFString: {
                                    skipBytes = headerDataStream.readInt();
                                }
                            }
                            headerDataStream.skip(skipBytes);
                        }
                        int n = requiredFieldMask = isRequestFrame ? 30 : 50;
                        if ((fieldMask & requiredFieldMask) != requiredFieldMask) {
                            throw new IOException("Invalid Frame Header Detected");
                        }
                        frame._payload = new PayloadInputStream(this._stream.subStream(this._payloadSize), this._payloadSize);
                        this.reset();
                        return frame;
                    }
                }
                return null;
            }
            catch (IOException e) {
                StringBuilder debugBuffer = new StringBuilder();
                debugBuffer.append("LookAheadSize == FRAME_HEADER_SIZE:" + (this._lookAheadSize == FRAME_HEADER_SIZE) + "\n");
                if (this._lookAheadSize == FRAME_HEADER_SIZE) {
                    if (this._lookAheadBuffer[0] != SIGNATURE[0] || this._lookAheadBuffer[1] != SIGNATURE[1] || this._lookAheadBuffer[2] != VERSION[0] || this._lookAheadBuffer[3] != VERSION[1]) {
                        debugBuffer.append("Frame Signature is Wrong:\n");
                        debugBuffer.append("  Got:[" + this._lookAheadBuffer[0] + "][" + this._lookAheadBuffer[1] + "][" + this._lookAheadBuffer[2] + "][" + this._lookAheadBuffer[3] + "]\n");
                        debugBuffer.append("  Exp:[" + SIGNATURE[0] + "][" + SIGNATURE[1] + "][" + VERSION[0] + "][" + VERSION[1] + "]\n");
                    } else {
                        debugBuffer.append("Frame Signature is Valid\n");
                        debugBuffer.append("Header Size is:" + this._headerSize + "\n");
                        debugBuffer.append("Payload Size is:" + this._payloadSize + "\n");
                        debugBuffer.append("Service Field:" + frame._service + "\n");
                        debugBuffer.append("Method  Field:" + frame._method + "\n");
                        debugBuffer.append("ReqId   Field:" + frame._requestId + "\n");
                        debugBuffer.append("Status  Field:" + frame._status + "\n");
                        debugBuffer.append("Type    Field:" + frame._type + "\n");
                    }
                    LOG.error((Object)("getNextFrame Threw Exception:" + CCStringUtils.stringifyException((Throwable)e)));
                    LOG.error((Object)"Details:");
                    LOG.error((Object)debugBuffer);
                }
                throw e;
            }
        }
    }

    static final class HeaderInputStream {
        private byte[] bytearr;
        private int count = 0;

        public HeaderInputStream(byte[] data) {
            this.bytearr = data;
        }

        public final void checkBounds(int bytesRequired) throws IOException {
            if (this.count + bytesRequired > this.bytearr.length) {
                throw new EOFException();
            }
        }

        public final void skip(int bytes) throws IOException {
            this.checkBounds(bytes);
            this.count += bytes;
        }

        public final byte readByte() throws IOException {
            this.checkBounds(1);
            int ch = this.bytearr[this.count++] & 0xFF;
            if (ch < 0) {
                throw new EOFException();
            }
            return (byte)ch;
        }

        public final short readShort() throws IOException {
            this.checkBounds(2);
            int ch1 = this.bytearr[this.count++] & 0xFF;
            int ch2 = this.bytearr[this.count++] & 0xFF;
            if ((ch1 | ch2) < 0) {
                throw new EOFException();
            }
            return (short)((ch1 << 8) + (ch2 << 0));
        }

        public final int readInt() throws IOException {
            this.checkBounds(4);
            int ch1 = this.bytearr[this.count++] & 0xFF;
            int ch2 = this.bytearr[this.count++] & 0xFF;
            int ch3 = this.bytearr[this.count++] & 0xFF;
            int ch4 = this.bytearr[this.count++] & 0xFF;
            if ((ch1 | ch2 | ch3 | ch4) < 0) {
                throw new EOFException();
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }

        public final String readUTF() throws IOException {
            int c;
            int utflen = this.readInt();
            int strlen = this.readInt();
            char[] chararr = new char[strlen];
            int chararr_count = 0;
            int charCountMax = this.count + (utflen -= 4);
            while (this.count < charCountMax && (c = this.bytearr[this.count] & 0xFF) <= 127) {
                ++this.count;
                chararr[chararr_count++] = (char)c;
            }
            block6: while (this.count < charCountMax) {
                c = this.bytearr[this.count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++this.count;
                        chararr[chararr_count++] = (char)c;
                        continue block6;
                    }
                    case 12: 
                    case 13: {
                        this.count += 2;
                        if (this.count > charCountMax) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = this.bytearr[this.count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + this.count);
                        }
                        chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block6;
                    }
                    case 14: {
                        this.count += 3;
                        if (this.count > charCountMax) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = this.bytearr[this.count - 2];
                        byte char3 = this.bytearr[this.count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (this.count - 1));
                        }
                        chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block6;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + this.count);
            }
            return new String(chararr, 0, chararr_count);
        }
    }

    public static final class IncomingFrame {
        public int _type;
        public int _requestId;
        public int _status;
        public String _service;
        public String _method;
        public PayloadInputStream _payload;
    }

    public static final class PayloadInputStream
    extends FilterInputStream {
        private int _payloadBytes;

        public PayloadInputStream(InputStream in, int payloadSize) {
            super(in);
            this._payloadBytes = payloadSize;
        }

        @Override
        public int available() throws IOException {
            return this._payloadBytes;
        }

        @Override
        public int read() throws IOException {
            if (this._payloadBytes == 0) {
                throw new IOException("Out of Bounds Read");
            }
            --this._payloadBytes;
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this._payloadBytes < len) {
                throw new IOException("Out of Bounds Read");
            }
            this._payloadBytes -= len;
            return super.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this._payloadBytes < b.length) {
                throw new IOException("Out of Bounds Read");
            }
            this._payloadBytes -= b.length;
            return super.read(b);
        }

        @Override
        public long skip(long n) throws IOException {
            if ((long)this._payloadBytes < n) {
                throw new IOException("Out of Bounds Read");
            }
            this._payloadBytes = (int)((long)this._payloadBytes - n);
            return super.skip(n);
        }
    }

    public static final class Encoder {
        private NIOBufferListOutputStream _stream;

        public Encoder(NIOBufferListOutputStream stream) {
            this._stream = stream;
        }

        public synchronized int encodeResponse(IncomingMessageContext context) throws IOException {
            HeaderOutputStream headerStream = new HeaderOutputStream();
            PayloadOutputStream payload = new PayloadOutputStream();
            DataOutputStream payloadStream = new DataOutputStream(payload);
            headerStream.writeFiledCount(3);
            headerStream.writeByteField(1, MSG_TYPE.RESPONSE.ordinal());
            headerStream.writeIntField(4, context.getRequestId());
            headerStream.writeByteField(5, context.getStatus().ordinal());
            if (context.getStatus() != MessageData.Status.Success) {
                if (context.getErrorDesc() != null && context.getErrorDesc().length() != 0) {
                    payloadStream.writeUTF(context.getErrorDesc());
                }
            } else {
                ((RPCStruct)context.getOutput()).serialize(payloadStream, new BinaryProtocol());
            }
            payload.flush();
            return this.encode(headerStream, payload);
        }

        public synchronized int encodeRequest(OutgoingMessageContext request) throws IOException {
            HeaderOutputStream headerStream = new HeaderOutputStream();
            PayloadOutputStream payload = new PayloadOutputStream();
            DataOutputStream payloadStream = new DataOutputStream(payload);
            headerStream.writeFiledCount(4);
            headerStream.writeByteField(1, MSG_TYPE.REQUEST.ordinal());
            headerStream.writeUTFField(2, request.getServiceName());
            headerStream.writeUTFField(3, request.getMethodName());
            headerStream.writeIntField(4, request.getRequestId());
            ((RPCStruct)request.getInput()).serialize(payloadStream, new BinaryProtocol());
            payload.flush();
            return this.encode(headerStream, payload);
        }

        private synchronized int encode(HeaderOutputStream header, PayloadOutputStream payload) throws IOException {
            DataOutputStream out = new DataOutputStream(this._stream);
            out.write(SIGNATURE);
            out.write(VERSION);
            out.writeInt(header.getLength());
            out.writeInt(payload.getLength());
            out.write(header.getBuffer(), 0, header.getLength());
            out.write(payload.getBuffer(), 0, payload.getLength());
            this._stream.flush();
            return FRAME_HEADER_SIZE + header.getLength() + payload.getLength();
        }

        public void reset() {
        }
    }

    private static final class HeaderOutputStream
    extends ByteArrayOutputStream {
        private HeaderOutputStream() {
        }

        public final void writeFiledCount(int fieldCount) throws IOException {
            this.write((byte)fieldCount);
        }

        public final void writeByteField(int fieldId, int v) throws IOException {
            this.write((byte)fieldId);
            this.write((byte)FieldType.Byte.ordinal());
            this.write((byte)v);
        }

        public final void writeShortField(int fieldId, int v) throws IOException {
            this.write((byte)fieldId);
            this.write((byte)FieldType.Short.ordinal());
            this.write((byte)(v >>> 8) & 0xFF);
            this.write((byte)(v >>> 0) & 0xFF);
        }

        public final void writeIntField(int fieldId, int v) throws IOException {
            this.write((byte)fieldId);
            this.write((byte)FieldType.Integer.ordinal());
            this.writeInt(v);
        }

        private final void writeInt(int v) {
            this.write(v >>> 24 & 0xFF);
            this.write(v >>> 16 & 0xFF);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }

        public void writeUTFField(int fieldId, String str) throws IOException {
            char c;
            int strlen = str.length();
            this.write((byte)fieldId);
            this.write((byte)FieldType.UTFString.ordinal());
            int newcount = this.count + str.length() * 3 + 4;
            if (newcount > this.buf.length) {
                byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
                System.arraycopy(this.buf, 0, newbuf, 0, this.count);
                this.buf = newbuf;
            }
            int utfLengthPos = this.count;
            this.count += 4;
            this.writeInt(str.length());
            int i = 0;
            for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
                this.buf[this.count++] = (byte)c;
            }
            while (i < strlen) {
                c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    this.buf[this.count++] = (byte)c;
                } else if (c > '\u07ff') {
                    this.buf[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.buf[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                } else {
                    this.buf[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                ++i;
            }
            int fieldLength = this.count - (utfLengthPos + 4);
            this.buf[utfLengthPos + 0] = (byte)(fieldLength >>> 24 & 0xFF);
            this.buf[utfLengthPos + 1] = (byte)(fieldLength >>> 16 & 0xFF);
            this.buf[utfLengthPos + 2] = (byte)(fieldLength >>> 8 & 0xFF);
            this.buf[utfLengthPos + 3] = (byte)(fieldLength >>> 0 & 0xFF);
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getLength() {
            return this.count;
        }

        public static enum FieldType {
            Byte,
            Short,
            Integer,
            UTFString;

        }
    }

    private static final class PayloadOutputStream
    extends ByteArrayOutputStream {
        private PayloadOutputStream() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getLength() {
            return this.count;
        }
    }

    public static class OutgoingFrame {
    }

    static enum MSG_TYPE {
        REQUEST,
        RESPONSE,
        ERROR;

    }
}

