/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.rpc.ActorInterface;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.Channel;
import org.commoncrawl.rpc.InProcessActor;
import org.commoncrawl.rpc.IncomingMessageContext;
import org.commoncrawl.rpc.OutgoingMessageContext;
import org.commoncrawl.rpc.RPCException;
import org.commoncrawl.rpc.RPCMessageDispatcher;
import org.commoncrawl.rpc.RPCServerChannel;
import org.commoncrawl.rpc.UnitTestStruct1;

public interface RPCTestService
extends ActorInterface {
    public static final Log LOG_PRIVATE = LogFactory.getLog(RPCTestService.class);
    public static final ActorInterface.RPCSpecification spec = new ActorInterface.RPCSpecification("RPCTestService", new Dispatcher());

    public void hello(IncomingMessageContext<UnitTestStruct1, UnitTestStruct1> var1) throws RPCException;

    public static class InProcessActorFactory {
        public static InProcessActor createInProcessActor(final RPCTestService instance, ThreadPoolExecutor executor, InProcessActor.Events optionalListener) throws IOException {
            InProcessActor actor = new InProcessActor(executor, optionalListener){

                @Override
                public void dispatch(Channel channel, InProcessActor.IncomingMessage message) throws RPCException {
                    if (message.getServiceName().equals(RPCTestService.spec._name)) {
                        if (message.getMethodName().equals("hello")) {
                            instance.hello(message);
                        } else {
                            LOG_PRIVATE.error((Object)("Method:" + message.getMethodName() + " Not Found"));
                        }
                    }
                }
            };
            return actor;
        }
    }

    public static class Dispatcher
    implements RPCMessageDispatcher {
        @Override
        public void dispatch(ActorInterface instance, RPCServerChannel serverChannel, String serviceId, String methodName, DataInputStream messagePayload, int requestId, Channel channel) throws RPCException {
            if (methodName.equals("hello")) {
                UnitTestStruct1 input = new UnitTestStruct1();
                UnitTestStruct1 output = new UnitTestStruct1();
                try {
                    input.deserialize(messagePayload, new BinaryProtocol());
                }
                catch (IOException e) {
                    LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new RPCException(e);
                }
                IncomingMessageContext<UnitTestStruct1, UnitTestStruct1> messageData = new IncomingMessageContext<UnitTestStruct1, UnitTestStruct1>(channel, requestId, input, output);
                ((RPCTestService)instance).hello(messageData);
            } else {
                LOG_PRIVATE.error((Object)("UNKNOWN METHOD NAME:" + methodName));
            }
        }
    }

    public static class BlockingStub
    extends ActorInterface.BlockingStub<AsyncStub> {
        public BlockingStub(Channel channel, EventLoop optionalEventLoop) {
            super(new AsyncStub(channel, optionalEventLoop));
        }

        public UnitTestStruct1 hello(UnitTestStruct1 input) throws RPCException {
            final CountDownLatch latch = new CountDownLatch(1);
            OutgoingMessageContext<UnitTestStruct1, UnitTestStruct1> request = ((AsyncStub)this.getAsyncStub()).hello(input, new OutgoingMessageContext.Callback(){

                public void requestComplete(OutgoingMessageContext request) {
                    latch.countDown();
                }
            });
            try {
                if (super.waitForResult(latch)) {
                    return (UnitTestStruct1)request.getOutput();
                }
                throw new RPCException("RPC Timeout");
            }
            catch (IOException e) {
                LOG_PRIVATE.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new RPCException(e);
            }
        }
    }

    public static class AsyncStub
    extends ActorInterface.AsyncStub {
        public AsyncStub(Channel channel, EventLoop optionalEventLoop) {
            super(channel, optionalEventLoop);
        }

        public OutgoingMessageContext<UnitTestStruct1, UnitTestStruct1> hello(UnitTestStruct1 input, OutgoingMessageContext.Callback<UnitTestStruct1, UnitTestStruct1> callback) throws RPCException {
            OutgoingMessageContext<UnitTestStruct1, UnitTestStruct1> request = new OutgoingMessageContext<UnitTestStruct1, UnitTestStruct1>(RPCTestService.spec._name, "hello", input, new UnitTestStruct1(), callback);
            this.getChannel().sendRequest(request);
            return request;
        }
    }
}

