/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.commoncrawl.rpc.compiler.CodeBuffer;
import org.commoncrawl.rpc.compiler.JCompType;
import org.commoncrawl.rpc.compiler.JComparator;
import org.commoncrawl.rpc.compiler.JEnum;
import org.commoncrawl.rpc.compiler.JEnumValue;
import org.commoncrawl.rpc.compiler.JField;
import org.commoncrawl.rpc.compiler.JType;

public class JRecord
extends JCompType {
    private String fullyQualifiedName;
    private ArrayList<JField<JType.JavaType>> fields = new ArrayList();
    private ArrayList<JEnum> enums = new ArrayList();
    private Vector<JField<JType.JavaType>> keys = new Vector();
    private int modifiers = 0;

    public JRecord(String name, ArrayList<JField<JType>> flist, ArrayList<JEnum> enums, Set<String> modifiers, ArrayList<JComparator> comparators) {
        this.fullyQualifiedName = name;
        for (JField<JType> f : flist) {
            JField<JType.JavaType> newField = new JField<JType.JavaType>(f.getName(), f.getType().getJavaType(), f.getOrdinal(), f.getModifiers());
            this.fields.add(newField);
            if ((newField.getModifiers() & JField.Modifiers.KEY) == 0) continue;
            if (!newField.getType().isComparable()) {
                throw new Error("key attribute assigned to a non Comparable Field:" + newField + " Record:" + name);
            }
            this.keys.add(newField);
        }
        this.enums = enums;
        this.parseModifiers(modifiers);
        this.setJavaType(new JavaRecord());
    }

    private void parseModifiers(Set<String> modifierSet) {
        if (modifierSet != null) {
            for (String modifier : modifierSet) {
                if (modifier.equals("recordid")) {
                    this.modifiers |= Modifiers.HAS_RECORDID;
                    continue;
                }
                if (modifier.equals("nodirty")) {
                    this.modifiers |= Modifiers.HAS_NO_DIRTY_TRACKING;
                    continue;
                }
                if (modifier.equals("anonymous")) {
                    this.modifiers |= Modifiers.IS_ANONYMOUS_RECORD;
                    continue;
                }
                if (modifier.equals("raw")) {
                    this.modifiers |= Modifiers.IS_RAW;
                    continue;
                }
                throw new Error("Invalid Record Modifier token:" + modifier + " encountered while parsing Record:" + this.fullyQualifiedName);
            }
        }
    }

    void genJavaCode(String destDir, ArrayList<String> options) throws IOException {
        ((JavaRecord)this.getJavaType()).genCode(destDir, options);
    }

    class JavaRecord
    extends JCompType.JavaCompType {
        private String fullName;
        private String name;
        private String module;

        JavaRecord() {
            super(JRecord.this.fullyQualifiedName, "Record", JRecord.this.fullyQualifiedName);
            this.fullName = JRecord.this.fullyQualifiedName;
            int idx = JRecord.this.fullyQualifiedName.lastIndexOf(46);
            this.name = JRecord.this.fullyQualifiedName.substring(idx + 1);
            this.module = JRecord.this.fullyQualifiedName.substring(0, idx);
        }

        @Override
        boolean isComparable() {
            return JRecord.this.keys.size() != 0;
        }

        private boolean trackDirtyFields() {
            return (JRecord.this.modifiers & (Modifiers.HAS_NO_DIRTY_TRACKING | Modifiers.IS_RAW)) == 0;
        }

        private boolean serializeRaw() {
            return (JRecord.this.modifiers & Modifiers.IS_RAW) != 0;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getShortName() {
            return this.name;
        }

        public Vector<JField<JType.JavaType>> getKeys() {
            return JRecord.this.keys;
        }

        public int getKeyCount() {
            return JRecord.this.keys.size();
        }

        @Override
        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.fullName + " " + fname + ";\n");
            }
            cb.append(fname + "= new " + this.fullName + "();\n");
            cb.append(fname + ".deserialize(input,decoder);\n");
        }

        @Override
        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            cb.append(fname + ".serialize(output,encoder);\n");
        }

        void genCode(String destDir, ArrayList<String> options) throws IOException {
            JType.JavaType type;
            String name;
            JType.JavaType type2;
            String name2;
            String pkg = this.module;
            String pkgpath = pkg.replaceAll("\\.", "/");
            File pkgdir = new File(destDir, pkgpath);
            if (!pkgdir.exists()) {
                boolean ret = pkgdir.mkdirs();
                if (!ret) {
                    throw new IOException("Cannnot create directory: " + pkgpath);
                }
            } else if (!pkgdir.isDirectory()) {
                throw new IOException(pkgpath + " is not a directory.");
            }
            File jfile = new File(pkgdir, this.name + ".java");
            FileWriter jj = new FileWriter(jfile);
            CodeBuffer cb = new CodeBuffer();
            cb.append("// File generated by rpc compiler. Do not edit.\n\n");
            cb.append("package " + this.module + ";\n\n");
            cb.append("import java.io.DataInput;\n");
            cb.append("import java.io.DataOutput;\n");
            cb.append("import java.util.BitSet;\n");
            cb.append("import java.io.IOException;\n");
            cb.append("import org.apache.hadoop.io.Writable;\n");
            cb.append("import org.apache.hadoop.io.WritableComparable;\n");
            cb.append("import org.apache.hadoop.record.Buffer;\n");
            cb.append("import org.commoncrawl.util.shared.FlexBuffer;\n");
            cb.append("import org.commoncrawl.util.shared.TextBytes;\n");
            cb.append("import org.commoncrawl.util.shared.MurmurHash;\n");
            cb.append("import org.commoncrawl.util.shared.ImmutableBuffer;\n");
            cb.append("import org.commoncrawl.rpc.BinaryProtocol;\n");
            cb.append("import org.apache.hadoop.util.ReflectionUtils;\n");
            cb.append("import org.apache.hadoop.conf.Configuration;\n");
            cb.append("// Generated File: " + this.name + "\n");
            cb.append("public class " + this.name);
            if ((JRecord.this.modifiers & Modifiers.HAS_RECORDID) != 0) {
                cb.append(" extends org.commoncrawl.rpc.RPCStructWithId");
            } else {
                cb.append(" extends org.commoncrawl.rpc.RPCStruct");
            }
            cb.append("<" + this.name + "> ");
            if (this.getKeyCount() == 0) {
                cb.append(" implements Writable");
            } else {
                cb.append(" implements WritableComparable ");
            }
            cb.append("{\n\n");
            cb.append("// optimized constructor helper \n");
            cb.append("public static " + this.name + " newInstance(Configuration conf) {\n");
            cb.append("  return ReflectionUtils.newInstance(" + this.name + ".class,conf);\n");
            cb.append("}\n");
            cb.append("// Writable Implementation\n");
            cb.append("public void write(DataOutput out) throws IOException{ \n");
            cb.append("this.serialize(out,new BinaryProtocol());\n");
            cb.append("}\n\n");
            cb.append("public void readFields(DataInput  in) throws IOException{ \n");
            cb.append("this.deserialize(in,new BinaryProtocol());\n");
            cb.append("}\n\n");
            if (this.getKeyCount() != 0) {
                cb.append("// Comparable Implementation\n");
                cb.append("public int compareTo(Object other) {\n");
                int keyCount = 0;
                for (JField<JType.JavaType> field : this.getKeys()) {
                    if (keyCount++ == 0) {
                        cb.append("int result = ");
                    } else {
                        cb.append("if (result == 0) result = ");
                    }
                    cb.append(field.getType().genCompareTo(field.getName(), "other", this.getFullName()) + ";\n");
                }
                cb.append("return result;\n");
                cb.append("}\n");
                cb.append("// getKey Implementation\n");
                cb.append("public String getKey(){\n");
                if (this.getKeyCount() == 1) {
                    cb.append(" return " + this.getKeys().get(0).getType().genGetKey(this.getKeys().get(0).getName()) + ";\n");
                } else {
                    cb.append(" return");
                    keyCount = 0;
                    for (JField<JType.JavaType> field : this.getKeys()) {
                        if (keyCount++ != 0) {
                            cb.append("+ \"_\" +");
                        }
                        cb.append("\"" + field.getName() + "_\"+" + field.getType().genGetKey(field.getName()));
                    }
                    cb.append(";\n");
                }
                cb.append("}\n\n");
            }
            cb.append("\n");
            cb.append("// Field Constants\n");
            int fieldOrdinalMax = 0;
            JField fieldMax = null;
            for (JField jf : JRecord.this.fields) {
                if ((jf.getModifiers() & JField.Modifiers.TRANSIENT) != 0) continue;
                if (jf.getOrdinal() > fieldOrdinalMax) {
                    fieldOrdinalMax = jf.getOrdinal();
                    fieldMax = jf;
                }
                cb.append("public static final int Field_" + jf.getName().toUpperCase() + " = " + Integer.toString(jf.getOrdinal()) + ";\n");
            }
            cb.append("static final int FieldID_MAX=Field_" + fieldMax.getName().toUpperCase() + ";\n");
            cb.append("\n");
            if (JRecord.this.enums.size() != 0) {
                cb.append("// Enumerations\n\n");
                for (JEnum e : JRecord.this.enums) {
                    cb.append("// Enum:" + e.getName() + "\n");
                    cb.append("public static final class " + e.getName() + " {\n");
                    for (JEnumValue v : e.getValues()) {
                        cb.append("public static final int " + v.getName() + " = " + Integer.toString(v.getValue()) + ";\n");
                    }
                    cb.append("\n");
                    cb.append("public static String toString(int enumValue){\n");
                    HashSet<Integer> visited = new HashSet<Integer>();
                    cb.append("switch (enumValue) {\n");
                    for (JEnumValue v : e.getValues()) {
                        if (visited.contains(v.getValue())) continue;
                        cb.append("case " + v.getValue() + ": return \"" + v.getName() + "\";\n");
                        visited.add(v.getValue());
                    }
                    cb.append("default: return \"\";\n");
                    cb.append("}\n");
                    cb.append("}\n");
                    cb.append("}\n");
                }
            }
            cb.append("// Field Declarations\n");
            if (this.trackDirtyFields()) {
                cb.append("private BitSet __validFields = new BitSet(FieldID_MAX+1);\n\n");
            }
            for (JField jf : JRecord.this.fields) {
                name2 = jf.getName();
                type2 = (JType.JavaType)jf.getType();
                type2.genDecl(cb, name2);
            }
            cb.append("\n");
            cb.append("// Default Constructor\n");
            cb.append("public " + this.name + "() { }\n\n");
            cb.append("// Accessors\n\n");
            if (this.trackDirtyFields()) {
                cb.append("public final boolean isFieldDirty(int fieldId) { return __validFields.get(fieldId); }\n");
                cb.append("public final " + this.name + "  setFieldDirty(int fieldId) { __validFields.set(fieldId); return this; }\n\n");
                cb.append("public final " + this.name + "  setFieldClean(int fieldId) { __validFields.clear(fieldId); return this; }\n\n");
            } else {
                cb.append("public final boolean isFieldDirty(int fieldId) { return true; }\n");
                cb.append("public final " + this.name + " setFieldDirty(int fieldId) { return this; }\n\n");
                cb.append("public final " + this.name + " setFieldClean(int fieldId) { return this; }\n\n");
            }
            for (JField jf : JRecord.this.fields) {
                String fieldName = jf.getName();
                type2 = (JType.JavaType)jf.getType();
                type2.genGetSet(cb, this.name, fieldName, (jf.getModifiers() & JField.Modifiers.TRANSIENT) == 0 && this.trackDirtyFields());
            }
            cb.append("// Object Dirty support \n\n");
            if (this.trackDirtyFields()) {
                cb.append("public final boolean isObjectDirty(){\n");
                cb.append("boolean isDirty = !__validFields.isEmpty();\n");
                boolean requiresNestedCheck = false;
                for (JField jf : JRecord.this.fields) {
                    if ((jf.getModifiers() & JField.Modifiers.TRANSIENT) != 0) continue;
                    name = jf.getName();
                    type = (JType.JavaType)jf.getType();
                    if (!type.hasDirtyState()) continue;
                    if (!requiresNestedCheck) {
                        cb.append("if (!isDirty){\n");
                        requiresNestedCheck = true;
                    }
                    type.genDirtyCheck(cb, name);
                }
                if (requiresNestedCheck) {
                    cb.append("}\n");
                }
                cb.append("return isDirty;\n");
                cb.append("}\n");
            } else {
                cb.append("public final boolean isObjectDirty(){ return true; } \n");
            }
            cb.append("\n");
            cb.append("// serialize implementation \n");
            cb.append("public final void serialize(DataOutput output,BinaryProtocol encoder)\nthrows java.io.IOException {\n");
            if (!this.serializeRaw()) {
                cb.append("encoder.beginFields(output);\n");
            }
            for (JField jf : JRecord.this.fields) {
                if ((jf.getModifiers() & JField.Modifiers.TRANSIENT) != 0) continue;
                name2 = jf.getName();
                type2 = (JType.JavaType)jf.getType();
                cb.append("// serialize field:" + name2 + "\n");
                if (this.trackDirtyFields()) {
                    if (type2.hasDirtyState()) {
                        type2.genValidFieldCheck(cb, name2);
                    } else {
                        cb.append("if (__validFields.get(Field_" + name2.toUpperCase() + "))");
                    }
                }
                cb.append("{\n");
                if (this.trackDirtyFields() && type2.hasDirtyState()) {
                    cb.append("__validFields.set(Field_" + name2.toUpperCase() + ");\n");
                }
                if (!this.serializeRaw()) {
                    cb.append("encoder.beginField(output,\"" + name2 + "\",Field_" + name2.toUpperCase() + ");\n");
                }
                type2.genWriteMethod(cb, name2, name2);
                cb.append("}\n");
                if (!this.trackDirtyFields() || !type2.hasDirtyState()) continue;
                cb.append("else {\n");
                cb.append("__validFields.clear(Field_" + name2.toUpperCase() + ");\n");
                cb.append("}\n");
            }
            if (!this.serializeRaw()) {
                cb.append("encoder.endFields(output);\n");
            }
            cb.append("}\n");
            cb.append("// deserialize implementation \n");
            cb.append("public final void deserialize(DataInput input, BinaryProtocol decoder)\nthrows java.io.IOException {\n");
            if (this.serializeRaw()) {
                for (JField jf : JRecord.this.fields) {
                    if ((jf.getModifiers() & JField.Modifiers.TRANSIENT) != 0) continue;
                    name2 = jf.getName();
                    type2 = (JType.JavaType)jf.getType();
                    cb.append("{\n");
                    type2.genReadMethod(cb, name2, name2, false);
                    cb.append("}\n");
                }
            } else {
                cb.append("// clear existing data first  \n");
                cb.append("clear();\n\n");
                cb.append("// reset protocol object to unknown field id enconding mode (for compatibility)\n");
                cb.append("decoder.pushFieldIdEncodingMode(BinaryProtocol.FIELD_ID_ENCODING_MODE_UNKNOWN);\n");
                cb.append("// keep reading fields until terminator (-1) is located \n");
                cb.append("int fieldId;\n");
                cb.append("while ((fieldId = decoder.readFieldId(input)) != -1) { \n");
                cb.append("switch (fieldId) { \n");
                for (JField jf : JRecord.this.fields) {
                    if ((jf.getModifiers() & JField.Modifiers.TRANSIENT) != 0) continue;
                    name2 = jf.getName();
                    type2 = (JType.JavaType)jf.getType();
                    cb.append("case Field_" + name2.toUpperCase() + ":{\n");
                    if (this.trackDirtyFields()) {
                        cb.append("__validFields.set(Field_" + name2.toUpperCase() + ");\n");
                    }
                    type2.genReadMethod(cb, name2, name2, false);
                    cb.append("}\n");
                    cb.append("break;\n");
                }
                cb.append("}\n");
                cb.append("}\n");
                cb.append("// pop extra encoding mode off of stack \n");
                cb.append("decoder.popFieldIdEncodingMode();\n");
            }
            cb.append("}\n");
            cb.append("// clear implementation \n");
            cb.append("public final void clear() {\n");
            if ((JRecord.this.modifiers & Modifiers.HAS_RECORDID) != 0) {
                cb.append("super.clear();\n");
            }
            if (this.trackDirtyFields()) {
                cb.append("__validFields.clear();\n");
            }
            for (JField jf : JRecord.this.fields) {
                name2 = jf.getName();
                type2 = (JType.JavaType)jf.getType();
                type2.genClearMethod(cb, name2);
            }
            cb.append("}\n");
            cb.append("// equals implementation \n");
            cb.append("public final boolean equals(final Object peer_) {\n");
            cb.append("if (!(peer_ instanceof " + this.name + ")) {\n");
            cb.append("return false;\n");
            cb.append("}\n");
            cb.append("if (peer_ == this) {\n");
            cb.append("return true;\n");
            cb.append("}\n");
            cb.append(this.name + " peer = (" + this.name + ") peer_;\n");
            if (this.trackDirtyFields()) {
                cb.append("boolean ret = __validFields.equals(peer.__validFields);\n");
                cb.append("if (!ret) return ret;\n");
            } else {
                cb.append("boolean ret = true;\n");
            }
            for (JField jf : JRecord.this.fields) {
                if ((jf.getModifiers() & JField.Modifiers.TRANSIENT) != 0) continue;
                name2 = jf.getName();
                type2 = (JType.JavaType)jf.getType();
                if (this.trackDirtyFields()) {
                    if (type2.hasDirtyState()) {
                        type2.genValidFieldCheck(cb, name2);
                    } else {
                        cb.append("if (__validFields.get(Field_" + name2.toUpperCase() + "))");
                    }
                }
                cb.append(" {\n");
                type2.genEquals(cb, name2, "peer." + name2);
                cb.append("if (!ret) return ret;\n");
                cb.append("}\n");
            }
            cb.append("return ret;\n");
            cb.append("}\n");
            cb.append("// clone implementation \n");
            cb.append("@SuppressWarnings(\"unchecked\")\n");
            cb.append("public final Object clone() throws CloneNotSupportedException {\n");
            cb.append(this.name + " other = new " + this.name + "();\n");
            if (this.trackDirtyFields()) {
                cb.append("other.__validFields.or(this.__validFields);\n");
            }
            for (JField jf : JRecord.this.fields) {
                name2 = jf.getName();
                type2 = (JType.JavaType)jf.getType();
                if (this.trackDirtyFields() && (jf.getModifiers() & JField.Modifiers.TRANSIENT) == 0 && !type2.hasDirtyState()) {
                    cb.append("if (__validFields.get(Field_" + name2.toUpperCase() + "))");
                }
                cb.append("{\n");
                type2.genClone(cb, type2.getType(), "other." + name2, "this." + name2);
                cb.append("}\n");
            }
            cb.append("return other;\n");
            cb.append("}\n");
            cb.append("// merge implementation \n");
            cb.append("@SuppressWarnings(\"unchecked\")\n");
            cb.append("public final void merge(" + this.name + " peer) throws CloneNotSupportedException  {\n");
            if (this.trackDirtyFields()) {
                cb.append("__validFields.or(peer.__validFields);\n");
            }
            for (JField jf : JRecord.this.fields) {
                name2 = jf.getName();
                type2 = (JType.JavaType)jf.getType();
                if (this.trackDirtyFields() && (jf.getModifiers() & JField.Modifiers.TRANSIENT) == 0 && !type2.hasDirtyState()) {
                    cb.append("if (peer.__validFields.get(Field_" + name2.toUpperCase() + "))");
                }
                cb.append("{\n");
                type2.genMerge(cb, type2.getType(), "this." + name2, "peer." + name2);
                cb.append("}\n");
            }
            cb.append("}\n");
            cb.append("// hashCode implementation \n");
            cb.append("public final int hashCode() {\n");
            cb.append("int result = 1;\n");
            AbstractList fieldIterator = null;
            fieldIterator = this.getKeyCount() != 0 ? this.getKeys() : JRecord.this.fields;
            for (JField jf : fieldIterator) {
                if ((jf.getModifiers() & JField.Modifiers.TRANSIENT) != 0) continue;
                name = jf.getName();
                type = (JType.JavaType)jf.getType();
                type.genHashCode(cb, name);
            }
            cb.append("return result;\n");
            cb.append("}\n");
            cb.append("}\n");
            jj.write(cb.toString());
            jj.close();
        }

        @Override
        void genMerge(CodeBuffer cb, String type, String targetField, String sourceField) {
            cb.append(targetField + ".merge(" + sourceField + ");\n");
        }

        @Override
        void genClearMethod(CodeBuffer cb, String fname) {
            cb.append(fname + ".clear();\n");
        }

        @Override
        boolean hasDirtyState() {
            return true;
        }

        @Override
        void genDirtyCheck(CodeBuffer cb, String fieldName) {
            cb.append("if (!isDirty){\n");
            cb.append("isDirty=" + fieldName + ".isObjectDirty();\n");
            cb.append("}\n");
        }

        @Override
        void genValidFieldCheck(CodeBuffer cb, String fieldName) {
            cb.append("if (" + fieldName + ".isObjectDirty())");
        }
    }

    public static class Modifiers {
        public static int HAS_RECORDID = 1;
        public static int HAS_NO_DIRTY_TRACKING = 2;
        public static int IS_ANONYMOUS_RECORD = 4;
        public static int IS_RAW = 8;
    }
}

