/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.commoncrawl.rpc.compiler.CodeBuffer;
import org.commoncrawl.rpc.compiler.JMethod;
import org.commoncrawl.rpc.compiler.JRecord;

public class JService {
    public String _serviceName;
    public ArrayList<JMethod> _methods = new ArrayList();

    public JService(String serviceName, ArrayList<JMethod> methodList) {
        this._serviceName = serviceName;
        this._methods = methodList;
    }

    public void genJavaCode(String destDir, ArrayList<String> options) throws IOException {
        String outputShortSpec;
        String inputShortSpec;
        String contextSpec;
        String outputFullSpec;
        String inputFullSpec;
        JRecord.JavaRecord outputType;
        JRecord.JavaRecord inputType;
        int idx = this._serviceName.lastIndexOf(46);
        String module = this._serviceName.substring(0, idx);
        String name = this._serviceName.substring(idx + 1);
        String pkg = module;
        String pkgpath = pkg.replaceAll("\\.", "/");
        File pkgdir = new File(destDir, pkgpath);
        if (!pkgdir.exists()) {
            boolean ret = pkgdir.mkdirs();
            if (!ret) {
                throw new IOException("Cannnot create directory: " + pkgpath);
            }
        } else if (!pkgdir.isDirectory()) {
            throw new IOException(pkgpath + " is not a directory.");
        }
        File jfile = new File(pkgdir, name + ".java");
        FileWriter jj = new FileWriter(jfile);
        CodeBuffer cb = new CodeBuffer();
        cb.append("// File generated by rpc compiler. Do not edit.\n\n");
        cb.append("package " + module + ";\n\n");
        String imports = "import java.io.DataInputStream;\nimport java.io.IOException;\nimport java.util.concurrent.CountDownLatch;\nimport java.util.concurrent.ThreadPoolExecutor;\nimport org.apache.commons.logging.Log;\nimport org.apache.commons.logging.LogFactory;\nimport org.apache.hadoop.util.StringUtils;\nimport org.commoncrawl.rpc.*;\nimport org.commoncrawl.async.EventLoop;";
        cb.append(imports);
        cb.append("\n");
        cb.append("public interface " + name + " extends ActorInterface {\n\n");
        cb.append("public static final Log LOG_PRIVATE = LogFactory.getLog(" + name + ".class);");
        cb.append(" /** interface specification **/\n\n");
        for (JMethod method : this._methods) {
            inputType = method.getInputType() != null ? (JRecord.JavaRecord)method.getInputType().getJavaType() : null;
            outputType = method.getOutputType() != null ? (JRecord.JavaRecord)method.getOutputType().getJavaType() : null;
            inputFullSpec = inputType != null ? inputType.getFullName() : "EmptyStruct";
            outputFullSpec = outputType != null ? outputType.getFullName() : "EmptyStruct";
            String outputShortSpec2 = outputType != null ? outputType.getShortName() : "EmptyStruct";
            contextSpec = "IncomingMessageContext<" + inputFullSpec + "," + outputFullSpec + ">";
            cb.append("// method " + method.getName() + " (in " + inputFullSpec + ", out " + outputShortSpec2 + ");\n");
            cb.append("void " + method.getName() + "(" + contextSpec + " message) throws RPCException;\n\n");
        }
        cb.append("/** server specification struct **/\n");
        cb.append("public static RPCSpecification spec = new RPCSpecification(\"" + name + "\",new " + name + ".Dispatcher());\n\n");
        cb.append("// Async Client  Stub\n");
        cb.append("public static class AsyncStub extends ActorInterface.AsyncStub {\n\n");
        cb.append("// constructor\n");
        cb.append("public AsyncStub(Channel channel,EventLoop optionalEventLoop) {\nsuper(channel,optionalEventLoop);\n}\n");
        for (JMethod method : this._methods) {
            inputType = method.getInputType() != null ? (JRecord.JavaRecord)method.getInputType().getJavaType() : null;
            outputType = method.getOutputType() != null ? (JRecord.JavaRecord)method.getOutputType().getJavaType() : null;
            inputFullSpec = inputType != null ? inputType.getFullName() : "EmptyStruct";
            outputFullSpec = outputType != null ? outputType.getFullName() : "EmptyStruct";
            inputShortSpec = inputType != null ? inputType.getShortName() : "EmptyStruct";
            outputShortSpec = outputType != null ? outputType.getShortName() : "EmptyStruct";
            cb.append("// public OutgoingMessageContext<" + inputShortSpec + "," + outputShortSpec + "> " + method.getName() + "(" + inputShortSpec + " input,OutgoingMessageContext<" + inputShortSpec + "," + outputShortSpec + "> callback) throws RPCException\n");
            cb.append("public OutgoingMessageContext<" + inputFullSpec + "," + outputFullSpec + "> " + method.getName() + "(");
            if (inputType != null) {
                cb.append(inputFullSpec + " input,");
            }
            cb.append("OutgoingMessageContext.Callback<" + inputFullSpec + "," + outputFullSpec + "> callback) throws RPCException  {\n");
            cb.append("OutgoingMessageContext<" + inputFullSpec + "," + outputFullSpec + "> request = new OutgoingMessageContext<" + inputFullSpec + "," + outputFullSpec + ">(spec._name,\"" + method.getName() + "\", ");
            if (inputType == null) {
                cb.append("EmptyStruct.getSingleton(),");
            } else {
                cb.append("input,");
            }
            if (outputType != null) {
                cb.append(" new " + outputFullSpec + "()");
            } else {
                cb.append(" EmptyStruct.getSingleton()");
            }
            cb.append(", callback);\n");
            cb.append("getChannel().sendRequest(request);\n");
            cb.append("return request;\n");
            cb.append("}\n\n");
        }
        cb.append("}\n\n");
        cb.append("// Blocking Client Stub\n");
        cb.append("public static class BlockingStub extends ActorInterface.BlockingStub<" + name + ".AsyncStub> {\n");
        cb.append("// constructor\n ");
        cb.append("\npublic BlockingStub(Channel channel,EventLoop optionalEventLoop) {\n");
        cb.append("super(new AsyncStub(channel,optionalEventLoop));\n");
        cb.append("}\n\n");
        for (JMethod method : this._methods) {
            inputType = method.getInputType() != null ? (JRecord.JavaRecord)method.getInputType().getJavaType() : null;
            outputType = method.getOutputType() != null ? (JRecord.JavaRecord)method.getOutputType().getJavaType() : null;
            inputFullSpec = inputType != null ? inputType.getFullName() : "EmptyStruct";
            outputFullSpec = outputType != null ? outputType.getFullName() : "EmptyStruct";
            inputShortSpec = inputType != null ? inputType.getShortName() : "EmptyStruct";
            outputShortSpec = outputType != null ? outputType.getShortName() : "EmptyStruct";
            cb.append("// public " + outputShortSpec + " " + method.getName() + "(" + inputShortSpec + " input) throws RPCException\n");
            cb.append("@SuppressWarnings(\"unchecked\")\n");
            cb.append("public ");
            if (outputType != null) {
                cb.append(outputFullSpec);
            } else {
                cb.append("void");
            }
            cb.append(" " + method.getName() + "(");
            if (inputType != null) {
                cb.append(inputFullSpec + " input");
            }
            cb.append(") throws RPCException {\n");
            cb.append("\nfinal CountDownLatch latch = new CountDownLatch(1);\n\n");
            cb.append("OutgoingMessageContext<" + inputFullSpec + "," + outputFullSpec + "> request = this.getAsyncStub()." + method.getName() + "(");
            if (inputType != null) {
                cb.append("input,");
            }
            cb.append("new OutgoingMessageContext.Callback(){\n\n");
            cb.append("public void requestComplete(OutgoingMessageContext request) {\n");
            cb.append("latch.countDown();\n");
            cb.append("}} );\n\n");
            cb.append("try {\n");
            cb.append("if (super.waitForResult(latch)) {\n");
            if (outputType != null) {
                cb.append("return request.getOutput();\n");
            } else {
                cb.append("return;\n");
            }
            cb.append("}\n");
            cb.append("throw new RPCException(\"RPC Timeout\");\n");
            cb.append("}\n");
            cb.append("catch (IOException e){\n");
            cb.append("LOG_PRIVATE.error(StringUtils.stringifyException(e));\n");
            cb.append("throw new RPCException(e);\n");
            cb.append("}\n");
            cb.append("}\n\n");
        }
        cb.append("}\n\n");
        cb.append("/** typed dispatcher object **/\n");
        cb.append("public static class Dispatcher implements RPCMessageDispatcher {\n");
        cb.append("//@Override\n");
        cb.append("public void dispatch(ActorInterface instance,RPCServerChannel serverChannel, String serviceId,String methodName,DataInputStream messagePayload,int requestId,Channel channel) throws RPCException {\n\n");
        int methodCount = 0;
        for (JMethod method : this._methods) {
            JRecord.JavaRecord inputType2 = method.getInputType() != null ? (JRecord.JavaRecord)method.getInputType().getJavaType() : null;
            JRecord.JavaRecord outputType2 = method.getOutputType() != null ? (JRecord.JavaRecord)method.getOutputType().getJavaType() : null;
            String inputFullSpec2 = inputType2 != null ? inputType2.getFullName() : "EmptyStruct";
            String outputFullSpec2 = outputType2 != null ? outputType2.getFullName() : "EmptyStruct";
            contextSpec = "IncomingMessageContext<" + inputFullSpec2 + "," + outputFullSpec2 + ">";
            if (methodCount++ == 0) {
                cb.append("if ");
            } else {
                cb.append("else if ");
            }
            cb.append("(methodName.equals(\"" + method.getName() + "\")){\n");
            if (inputType2 != null) {
                cb.append(inputFullSpec2 + " input = new " + inputFullSpec2 + "();\n");
            } else {
                cb.append(inputFullSpec2 + " input = EmptyStruct.getSingleton();\n");
            }
            if (outputType2 != null) {
                cb.append(outputFullSpec2 + " output = new " + outputFullSpec2 + "();\n");
            } else {
                cb.append(outputFullSpec2 + " output = EmptyStruct.getSingleton();\n");
            }
            if (inputType2 != null) {
                cb.append("try {\n");
                cb.append("input.deserialize(messagePayload,new BinaryProtocol());\n");
                cb.append("} catch (IOException e) {\n");
                cb.append("LOG_PRIVATE.error(StringUtils.stringifyException(e));\n");
                cb.append("throw new RPCException(e);\n");
                cb.append("}\n");
                cb.append("\n");
            }
            cb.append(contextSpec + " messageData = new " + contextSpec + "(channel,requestId,input,output);\n");
            cb.append("// Invoke " + method.getName() + "\n");
            cb.append("((" + name + ")instance)." + method.getName() + "(messageData);\n\n");
            cb.append("\n");
            cb.append("}\n\n");
        }
        cb.append("else {\n");
        cb.append("LOG_PRIVATE.error(\"UNKNOWN METHOD NAME:\" + methodName);\n\n");
        cb.append("}\n");
        cb.append("}\n");
        cb.append("}\n");
        cb.append("/** typed actor object **/\n");
        cb.append("public static class InProcessActorFactory {\n");
        cb.append("public static InProcessActor createInProcessActor(final " + name + " instance,ThreadPoolExecutor executor,InProcessActor.Events optionalListener) throws IOException {\n");
        cb.append("    InProcessActor actor = new InProcessActor(executor,optionalListener) {\n\n");
        cb.append("          @SuppressWarnings(\"unchecked\")\n");
        cb.append("      @Override\n");
        cb.append("      public void dispatch(Channel channel, IncomingMessage message)throws RPCException {\n");
        cb.append("        if (message.getServiceName().equals(spec._name)) {\n");
        for (JMethod method : this._methods) {
            cb.append("        if (message.getMethodName().equals(\"" + method.getName() + "\")){\n");
            cb.append("           instance." + method.getName() + "(message);\n");
            cb.append("        }\n");
        }
        cb.append("          else {\n");
        cb.append("            LOG_PRIVATE.error(\"Method:\" + message.getMethodName() + \" Not Found\");\n");
        cb.append("          }\n");
        cb.append("        }\n");
        cb.append("      }\n");
        cb.append("    };\n");
        cb.append("    return actor;\n");
        cb.append("  }\n");
        cb.append("}\n");
        cb.append("}\n");
        jj.write(cb.toString());
        jj.close();
    }
}

