/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler;

import org.commoncrawl.rpc.compiler.CodeBuffer;
import org.commoncrawl.rpc.compiler.JCompType;
import org.commoncrawl.rpc.compiler.JType;

public class JString
extends JCompType {
    public JString() {
        this.setJavaType(new JavaString());
    }

    String getSignature() {
        return "s";
    }

    @Override
    boolean isComparable() {
        return true;
    }

    class JavaString
    extends JCompType.JavaCompType {
        JavaString() {
            super("TextBytes", "TextBytes", "TextBytes");
        }

        @Override
        void genClone(CodeBuffer cb, String type, String targetField, String sourceField) {
            cb.append(targetField + "= (TextBytes)" + sourceField + ".clone();\n");
        }

        @Override
        void genClearMethod(CodeBuffer cb, String fname) {
            cb.append(fname + ".clear();\n");
        }

        @Override
        void genDecl(CodeBuffer cb, String fname) {
            cb.append("private " + this.getType() + " " + fname + "=  new TextBytes();\n");
        }

        @Override
        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("result = MurmurHash.hash(" + fname + ".getBytes()," + fname + ".getOffset()," + fname + ".getLength(),result);\n");
        }

        @Override
        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.getType() + " " + fname + " = new TextBytes();\n");
            }
            cb.append("decoder.read" + this.getMethodSuffix() + "(input," + fname + ");\n");
        }

        @Override
        void genGetSet(CodeBuffer cb, String enclosingClassName, String fname, boolean trackDirtyFields) {
            cb.append("public TextBytes get" + JType.toCamelCase(fname) + "AsTextBytes() {\n");
            cb.append("return " + fname + ";\n");
            cb.append("}\n");
            cb.append("public String get" + JType.toCamelCase(fname) + "() {\n");
            cb.append("return " + fname + ".toString();\n");
            cb.append("}\n");
            cb.append("public " + enclosingClassName + "  set" + JType.toCamelCase(fname) + "( String " + fname + ") {\n");
            if (trackDirtyFields) {
                cb.append("__validFields.set(Field_" + fname.toUpperCase() + ");\n");
            }
            cb.append("this." + fname + ".set(" + fname + ");\n");
            cb.append("return this;\n");
            cb.append("}\n");
        }
    }
}

