/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc.compiler;

import org.commoncrawl.rpc.compiler.CodeBuffer;

public abstract class JType {
    JavaType javaType;

    static String toCamelCase(String name) {
        char firstChar = name.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return "" + Character.toUpperCase(firstChar) + name.substring(1);
        }
        return name;
    }

    boolean isComparable() {
        return false;
    }

    void setJavaType(JavaType jType) {
        this.javaType = jType;
    }

    JavaType getJavaType() {
        return this.javaType;
    }

    abstract class JavaType {
        private String name;
        private String methodSuffix;
        private String wrapper;

        JavaType(String javaname, String suffix, String wrapper) {
            this.name = javaname;
            this.methodSuffix = suffix;
            this.wrapper = wrapper;
        }

        boolean isVariableBitRateEncoded() {
            return false;
        }

        void genDecl(CodeBuffer cb, String fname) {
            cb.append("private " + this.name + " " + fname + ";\n");
        }

        void genConstructorParam(CodeBuffer cb, String fname) {
            cb.append("final " + this.name + " " + fname);
        }

        void genGetSet(CodeBuffer cb, String enclosingClass, String fname, boolean trackDirtyFields) {
            cb.append("public " + this.name + " get" + JType.toCamelCase(fname) + "() {\n");
            cb.append("return " + fname + ";\n");
            cb.append("}\n");
            cb.append("public " + enclosingClass + " set" + JType.toCamelCase(fname) + "( " + this.name + " " + fname + ") {\n");
            if (trackDirtyFields) {
                cb.append("__validFields.set(Field_" + fname.toUpperCase() + ");\n");
            }
            cb.append("this." + fname + "=" + fname + ";\n");
            cb.append("return this;\n");
            cb.append("}\n");
        }

        void genValidFieldCheck(CodeBuffer cb, String fieldName) {
            cb.append("if (__validFields.get(Field_" + fieldName.toUpperCase() + "))");
        }

        boolean hasDirtyState() {
            return false;
        }

        void genDirtyCheck(CodeBuffer cb, String fieldName) {
        }

        String getType() {
            return this.name;
        }

        String getWrapperType() {
            return this.wrapper;
        }

        String getMethodSuffix() {
            return this.methodSuffix;
        }

        void genClearMethod(CodeBuffer cb, String fname) {
            Integer.valueOf(1).equals(2);
        }

        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            if (!this.isVariableBitRateEncoded()) {
                cb.append("encoder.write" + this.methodSuffix + "(output," + fname + ");\n");
            } else {
                cb.append("encoder.writeV" + this.methodSuffix + "(output," + fname + ");\n");
            }
        }

        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.name + " " + fname + ";\n");
            }
            if (!this.isVariableBitRateEncoded()) {
                cb.append(fname + "=decoder.read" + this.methodSuffix + "(input);\n");
            } else {
                cb.append(fname + "=decoder.readV" + this.methodSuffix + "(input);\n");
            }
        }

        void genEquals(CodeBuffer cb, String fname, String peer) {
            cb.append("ret = (" + fname + "==" + peer + ");\n");
        }

        String genCompareTo(String fname, String peer, String objectType) {
            return "((" + this.getWrapperType() + ")" + fname + ").compareTo((" + this.getWrapperType() + ")((" + objectType + ")" + peer + ")." + fname + ")";
        }

        String genGetKey(String fname) {
            return "((" + this.getWrapperType() + ")" + fname + ").toString()";
        }

        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("result = MurmurHash.hashInt((int)" + fname + ",result);\n");
        }

        void genConstructorSet(CodeBuffer cb, String fname) {
            cb.append("this." + fname + " = " + fname + ";\n");
        }

        void genClone(CodeBuffer cb, String type, String targetField, String sourceField) {
            cb.append(targetField + "= " + sourceField + ";\n");
        }

        void genMerge(CodeBuffer cb, String type, String targetField, String sourceField) {
            this.genClone(cb, type, targetField, sourceField);
        }

        boolean isComparable() {
            return JType.this.isComparable();
        }
    }
}

