/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.server;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.http.HttpServer;
import org.commoncrawl.server.AsyncWebServerRequest;
import org.commoncrawl.server.CommonCrawlServer;
import org.commoncrawl.util.shared.CCStringUtils;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.MultiException;

public class WebServer {
    private static final Log LOG = LogFactory.getLog((String)WebServer.class.getName());
    private Server webServer;
    private Connector listener;
    private boolean findPort;
    private Context webAppContext;
    private CommonCrawlServer _hostServer;
    private boolean _asyncDispatch = false;
    final String[] ALL_URLS = new String[]{"/*"};

    public Context getWebAppContext() {
        return this.webAppContext;
    }

    protected Connector createBaseListener() throws IOException {
        SelectChannelConnector ret = new SelectChannelConnector();
        ret.setLowResourceMaxIdleTime(10000);
        ret.setLowResourceMaxIdleTime(-1);
        ret.setAcceptQueueSize(500);
        ret.setResolveNames(false);
        ret.setUseDirectBuffers(false);
        ret.setAcceptors(4);
        return ret;
    }

    public WebServer(CommonCrawlServer hostServer, String bindAddress, int port, boolean findPort, boolean useAsyncDispatch) throws IOException {
        WebServer theWebServer = this;
        this._hostServer = hostServer;
        this._asyncDispatch = useAsyncDispatch;
        this.webServer = new Server();
        this.webServer.setThreadPool((ThreadPool)new QueuedThreadPool());
        this.findPort = findPort;
        this.listener = this.createBaseListener();
        this.listener.setPort(port);
        this.listener.setHost(bindAddress);
        this.webServer.addConnector(this.listener);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.webServer.setHandler((Handler)contexts);
        String logDir = System.getProperty("commoncrawl.log.dir");
        File webappDir = null;
        if (hostServer.getAppName() != null) {
            webappDir = this.getWebAppsPath();
            LOG.info((Object)("WebApps Dir is:" + webappDir));
            this.webAppContext = useAsyncDispatch ? new AsyncWebApplicationContext(this) : new WebAppContext();
            contexts.addHandler((Handler)this.webAppContext);
            this.webAppContext.setContextPath("/");
            ((WebAppContext)this.webAppContext).setWar(webappDir.getAbsolutePath());
            File webAppStaticDir = new File(webappDir, "/static");
            File[] files = webAppStaticDir.listFiles();
            boolean hasStaticFilesInRoot = false;
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        Context staticContext = new Context((HandlerContainer)contexts, "/" + file.getName());
                        staticContext.setResourceBase(file.toURI().toString());
                        staticContext.addServlet(DefaultServlet.class, "/");
                        continue;
                    }
                    hasStaticFilesInRoot = true;
                }
            }
            if (hasStaticFilesInRoot) {
                Context staticContext = new Context((HandlerContainer)contexts, "/");
                staticContext.setResourceBase(webAppStaticDir.toURI().toString());
                staticContext.addServlet(DefaultServlet.class, "/");
            }
        }
        if (logDir != null) {
            Context logContext = new Context((HandlerContainer)contexts, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(DefaultServlet.class, "/");
        }
        this.addServlet("stacks", "/stacks", HttpServer.StackServlet.class);
    }

    protected void defineFilter(Context ctx, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        holder.setInitParameters(parameters);
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(15);
        fmap.setFilterName(name);
        ServletHandler handler = ctx.getServletHandler();
        handler.addFilter(holder, fmap);
    }

    public Server getServer() {
        return this.webServer;
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public <T extends HttpServlet> ServletHolder addServlet(String name, String pathSpec, Class<T> servletClass) {
        ServletHolder holder = new ServletHolder(servletClass);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
        return holder;
    }

    private static RuntimeException makeRuntimeException(String msg, Throwable cause) {
        RuntimeException result = new RuntimeException(msg);
        if (cause != null) {
            result.initCause(cause);
        }
        return result;
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    public File getWebAppsPath() throws IOException {
        String webAppName = this._hostServer.getAppName();
        URL url = WebServer.class.getClassLoader().getResource(webAppName);
        if (url == null) {
            throw new IOException("webapps path not found in CLASSPATH");
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            throw new IOException(e);
        }
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void setThreads(int min, int max, int low) {
        ((QueuedThreadPool)this.webServer.getThreadPool()).setMinThreads(min);
        ((QueuedThreadPool)this.webServer.getThreadPool()).setMaxThreads(max);
        ((QueuedThreadPool)this.webServer.getThreadPool()).setLowThreads(low);
    }

    public void setLowResourceTimeout(int milliseconds) {
        ((QueuedThreadPool)this.webServer.getThreadPool()).setMaxIdleTimeMs(milliseconds);
    }

    public void start() throws IOException {
        try {
            try {
                this.webServer.start();
            }
            catch (MultiException ex) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)ex));
                throw ex;
            }
        }
        catch (IOException ie) {
            throw ie;
        }
        catch (Exception e) {
            IOException ie = new IOException("Problem starting http server");
            ie.initCause(e);
            throw ie;
        }
    }

    public void stop() throws InterruptedException {
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        }
    }

    public ContextHandlerCollection getContextHandlerCollection() {
        return (ContextHandlerCollection)this.webServer.getHandler();
    }

    public static class AsyncWebApplicationContext
    extends WebAppContext {
        WebServer _server = null;

        public AsyncWebApplicationContext(WebServer webServer) {
            this._server = webServer;
        }

        public void handle(final String pathInContext, final HttpServletRequest request, final HttpServletResponse response, final int dispatch) throws IOException, ServletException {
            LOG.info((Object)("Received Web Request for Path:" + pathInContext));
            if (pathInContext.endsWith(".jsp")) {
                AsyncWebServerRequest asyncWebRequest = new AsyncWebServerRequest("", null){

                    @Override
                    public boolean handleRequest(Semaphore completionSemaphore) throws IOException {
                        try {
                            AsyncWebApplicationContext.super.handle(pathInContext, request, response, dispatch);
                        }
                        catch (ServletException e) {
                            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                            throw new IOException(e);
                        }
                        return false;
                    }
                };
                asyncWebRequest.dispatch(this._server._hostServer.getEventLoop());
                if (asyncWebRequest.getException() != null) {
                    throw asyncWebRequest.getException();
                }
            } else {
                super.handle(pathInContext, request, response, dispatch);
            }
        }
    }
}

