/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.commoncrawl.io.shared.NIOHttpHeaders;
import org.commoncrawl.protocol.shared.ArcFileHeaderItem;
import org.commoncrawl.protocol.shared.ArcFileItem;
import org.commoncrawl.util.shared.ByteArrayUtils;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.TextBytes;

public class ArcFileItemUtils {
    private static final Log LOG = LogFactory.getLog(ArcFileItemUtils.class);
    static SimpleDateFormat TIMESTAMP14 = new SimpleDateFormat("yyyyMMddHHmmss");

    public static NIOHttpHeaders buildHeaderFromArcFileItemHeaders(ArrayList<ArcFileHeaderItem> items) {
        NIOHttpHeaders headers = new NIOHttpHeaders();
        for (ArcFileHeaderItem headerItem : items) {
            headers.add(headerItem.getItemKey(), headerItem.getItemValue());
        }
        return headers;
    }

    public static void bytesWritableToArcFileItem(Text key, BytesWritable rawArcPayload, ArcFileItem arcFileItem) throws IOException {
        arcFileItem.clear();
        int indexOfTrailingCRLF = ByteArrayUtils.indexOf(rawArcPayload.getBytes(), 0, rawArcPayload.getLength(), "\r\n\r\n".getBytes());
        int headerLen = indexOfTrailingCRLF + 4;
        int contentLen = rawArcPayload.getLength() - headerLen;
        String headerStr = new TextBytes(rawArcPayload.getBytes(), 0, headerLen, true).toString();
        NIOHttpHeaders headers = NIOHttpHeaders.parseHttpHeaders(headerStr);
        arcFileItem.getUriAsTextBytes().set(key, true);
        arcFileItem.setHostIP(headers.findValue("x_commoncrawl_HostIP"));
        try {
            arcFileItem.setTimestamp(TIMESTAMP14.parse(headers.findValue("x_commoncrawl_ArcTimestamp")).getTime());
        }
        catch (Exception e) {
            LOG.error((Object)("Invalid Timestamp Encountered in Item Metdata. URL:" + arcFileItem.getUri() + " Timestamp:" + headers.findValue("x_commoncrawl_ArcTimestamp")));
        }
        arcFileItem.setMimeType(headers.findValue("x_commoncrawl_ArcMimeType"));
        arcFileItem.setRecordLength(rawArcPayload.getLength());
        for (int i = 0; i < headers.getKeyCount(); ++i) {
            String headerKey = headers.getKey(i);
            String headerValue = headers.getValue(i);
            ArcFileHeaderItem headerItem = new ArcFileHeaderItem();
            headerItem.setItemKey(headerKey != null ? headerKey : "");
            headerItem.setItemValue(headerValue != null ? headerValue : "");
            arcFileItem.getHeaderItems().add(headerItem);
        }
        arcFileItem.setContent(new FlexBuffer(rawArcPayload.getBytes(), headerLen, contentLen, true));
    }
}

